/*
 * Decompiled with CFR 0.152.
 */
package ambience.cms.management.resources;

import ambience.cms.management.resources.ResourceBinaryStore$;
import ambience.cms.management.resources.ResourceBulkDownload$;
import ambience.cms.management.resources.ResourceBulkDownload$Info$;
import ambience.cms.management.resources.ResourceBulkDownload$Store$;
import ambience.cms.management.resources.ResourceBulkDownload$StoreZipResult$;
import ambience.codex.BulkDownload;
import ambience.module.UserDB;
import better.files.File;
import better.files.File$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ResourceBulkDownload {
    public static String ElxResourceMetaJSON() {
        return ResourceBulkDownload$.MODULE$.ElxResourceMetaJSON();
    }

    public static Task<BulkDownload.Result> apply(UserDB.User user, String string, Set<BsonValue> set) {
        return ResourceBulkDownload$.MODULE$.apply(user, string, set);
    }

    public static Task<BulkDownload.Intermediate> build(UserDB.User user, File file, List<Tuple2<Info, Json>> list) {
        return ResourceBulkDownload$.MODULE$.build(user, file, list);
    }

    public static String buildZipFilename(String string) {
        return ResourceBulkDownload$.MODULE$.buildZipFilename(string);
    }

    public static void dispose(File file) {
        ResourceBulkDownload$.MODULE$.dispose(file);
    }

    public static LoggingInterface log() {
        return ResourceBulkDownload$.MODULE$.log();
    }

    public static String nameField() {
        return ResourceBulkDownload$.MODULE$.nameField();
    }

    public static class Builder {
        private final UserDB.User user;
        private final Store store;
        private final File tmpDir;
        private final File zipFile;
        private final File outFolder;

        public Builder(UserDB.User user, Store store, File zipsFolder) {
            this.user = user;
            this.store = store;
            String string = File$.MODULE$.newTemporaryDirectory$default$1();
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            this.tmpDir = File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
            String string2 = store.value() + ".zip";
            boolean bl = zipsFolder.createChild$default$3();
            this.zipFile = zipsFolder.createChild(string2, false, bl, zipsFolder.createChild$default$4(string2, false, bl), zipsFolder.createChild$default$5(string2, false, bl));
            boolean bl2 = this.tmpDir().createChild$default$3();
            this.outFolder = this.tmpDir().createChild("root", true, bl2, this.tmpDir().createChild$default$4("root", true, bl2), this.tmpDir().createChild$default$5("root", true, bl2));
        }

        public File tmpDir() {
            return this.tmpDir;
        }

        public File zipFile() {
            return this.zipFile;
        }

        public File outFolder() {
            return this.outFolder;
        }

        public Task<StoreZipResult> run(List<Tuple2<Info, Json>> list) {
            List tasks = list.map((Function1 & Serializable)info -> this.exportInfo((Tuple2<Info, Json>)info));
            this.createMetainfo(list);
            return Task$.MODULE$.now((Object)BoxedUnit.UNIT).$greater$greater(() -> this.run$$anonfun$1(tasks));
        }

        public Task<String> exportInfo(Tuple2<Info, Json> info) {
            File file = this.outFolder().$div(this.safe(((Info)info._1()).category())).$div(this.getFileName$1(info));
            File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
            return ResourceBinaryStore$.MODULE$.read(this.user, (Json)info._2()).flatMap(arg_0 -> ResourceBulkDownload$.ambience$cms$management$resources$ResourceBulkDownload$Builder$$_$exportInfo$$anonfun$1(file2, info, arg_0));
        }

        public void createMetainfo(List<Tuple2<Info, Json>> info) {
            File file = this.outFolder().$div(ResourceBulkDownload$.MODULE$.ElxResourceMetaJSON());
            File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
            String str = info.map(ResourceBulkDownload$::ambience$cms$management$resources$ResourceBulkDownload$Builder$$_$_$$anonfun$6).mkString("[", ",", "]");
            file2.write(str, file2.write$default$2(str), file2.write$default$3(str));
        }

        public String safe(String fullName) {
            return fullName.replace("\\", "_").replace("/", "_").replace(":", "_");
        }

        private final Task run$$anonfun$1(List tasks$1) {
            return Task$.MODULE$.sequence((Iterable)tasks$1, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)names -> {
                int n = this.outFolder().zipTo$default$2();
                this.outFolder().zipTo(this.zipFile(), n, this.outFolder().zipTo$default$3(this.zipFile(), n));
                return ResourceBulkDownload$StoreZipResult$.MODULE$.apply(this.zipFile(), this.store, (List<String>)names);
            });
        }

        private final String getFileName$1(Tuple2 info$1) {
            String n = this.safe(((Info)info$1._1()).name());
            Path p = Path$.MODULE$.apply(n);
            Option option = p.extension();
            if (option instanceof Some) {
                return n;
            }
            if (None$.MODULE$.equals(option)) {
                return n + "." + MimeInfo$.MODULE$.extension(MimeType$.MODULE$.apply(((Info)info$1._1()).contentType()));
            }
            throw new MatchError((Object)option);
        }
    }

    public static final class Info
    implements Product,
    Serializable {
        private final String id;
        private final String store;
        private final String name;
        private final String category;
        private final String description;
        private final String contentType;

        public static Option<Info> apply(Document document) {
            return ResourceBulkDownload$Info$.MODULE$.apply(document);
        }

        public static Info apply(String string, String string2, String string3, String string4, String string5, String string6) {
            return ResourceBulkDownload$Info$.MODULE$.apply(string, string2, string3, string4, string5, string6);
        }

        public static Info fromProduct(Product product) {
            return ResourceBulkDownload$Info$.MODULE$.fromProduct(product);
        }

        public static Info unapply(Info info) {
            return ResourceBulkDownload$Info$.MODULE$.unapply(info);
        }

        public Info(String id, String store, String name, String category, String description, String contentType) {
            this.id = id;
            this.store = store;
            this.name = name;
            this.category = category;
            this.description = description;
            this.contentType = contentType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            String string = this.id();
            String string2 = info.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.store();
            String string4 = info.store();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.name();
            String string6 = info.name();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.category();
            String string8 = info.category();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.description();
            String string10 = info.description();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.contentType();
            String string12 = info.contentType();
            if (string11 == null) {
                if (string12 == null) return true;
                return false;
            } else {
                if (!string11.equals(string12)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "store";
                }
                case 2: {
                    return "name";
                }
                case 3: {
                    return "category";
                }
                case 4: {
                    return "description";
                }
                case 5: {
                    return "contentType";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String store() {
            return this.store;
        }

        public String name() {
            return this.name;
        }

        public String category() {
            return this.category;
        }

        public String description() {
            return this.description;
        }

        public String contentType() {
            return this.contentType;
        }

        public Info copy(String id, String store, String name, String category, String description, String contentType) {
            return new Info(id, store, name, category, description, contentType);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.store();
        }

        public String copy$default$3() {
            return this.name();
        }

        public String copy$default$4() {
            return this.category();
        }

        public String copy$default$5() {
            return this.description();
        }

        public String copy$default$6() {
            return this.contentType();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.store();
        }

        public String _3() {
            return this.name();
        }

        public String _4() {
            return this.category();
        }

        public String _5() {
            return this.description();
        }

        public String _6() {
            return this.contentType();
        }
    }

    public static final class Store
    implements Product,
    Serializable {
        private final String value;

        public static Store apply(String string) {
            return ResourceBulkDownload$Store$.MODULE$.apply(string);
        }

        public static Store fromProduct(Product product) {
            return ResourceBulkDownload$Store$.MODULE$.fromProduct(product);
        }

        public static Store unapply(Store store) {
            return ResourceBulkDownload$Store$.MODULE$.unapply(store);
        }

        public Store(String value) {
            this.value = value;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Store)) return false;
            Store store = (Store)object;
            String string = this.value();
            String string2 = store.value();
            if (string != null) {
                if (!string.equals(string2)) return false;
                return true;
            }
            if (string2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Store;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Store";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "value";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String value() {
            return this.value;
        }

        public Store copy(String value) {
            return new Store(value);
        }

        public String copy$default$1() {
            return this.value();
        }

        public String _1() {
            return this.value();
        }
    }

    public static final class StoreZipResult
    implements Product,
    Serializable {
        private final File file;
        private final Store store;
        private final List names;

        public static StoreZipResult apply(File file, Store store, List<String> list) {
            return ResourceBulkDownload$StoreZipResult$.MODULE$.apply(file, store, list);
        }

        public static StoreZipResult fromProduct(Product product) {
            return ResourceBulkDownload$StoreZipResult$.MODULE$.fromProduct(product);
        }

        public static StoreZipResult unapply(StoreZipResult storeZipResult) {
            return ResourceBulkDownload$StoreZipResult$.MODULE$.unapply(storeZipResult);
        }

        public StoreZipResult(File file, Store store, List<String> names) {
            this.file = file;
            this.store = store;
            this.names = names;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StoreZipResult)) return false;
            StoreZipResult storeZipResult = (StoreZipResult)object;
            File file = this.file();
            File file2 = storeZipResult.file();
            if (file == null) {
                if (file2 != null) {
                    return false;
                }
            } else if (!file.equals(file2)) return false;
            Store store = this.store();
            Store store2 = storeZipResult.store();
            if (store == null) {
                if (store2 != null) {
                    return false;
                }
            } else if (!((Object)store).equals(store2)) return false;
            List<String> list = this.names();
            List<String> list2 = storeZipResult.names();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StoreZipResult;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "StoreZipResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "file";
                }
                case 1: {
                    return "store";
                }
                case 2: {
                    return "names";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public File file() {
            return this.file;
        }

        public Store store() {
            return this.store;
        }

        public List<String> names() {
            return this.names;
        }

        public StoreZipResult copy(File file, Store store, List<String> names) {
            return new StoreZipResult(file, store, names);
        }

        public File copy$default$1() {
            return this.file();
        }

        public Store copy$default$2() {
            return this.store();
        }

        public List<String> copy$default$3() {
            return this.names();
        }

        public File _1() {
            return this.file();
        }

        public Store _2() {
            return this.store();
        }

        public List<String> _3() {
            return this.names();
        }
    }
}

