/*
 * Decompiled with CFR 0.152.
 */
package ambience.dataExplorer.validate;

import com.elixirtech.coredata.Data;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DateConversions$
implements Serializable {
    private static final DateTimeFormatter timestampFormatter;
    public static final DateConversions$ MODULE$;

    private DateConversions$() {
    }

    static {
        MODULE$ = new DateConversions$();
        timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-hh-mm");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DateConversions$.class);
    }

    public DateTimeFormatter timestampFormatter() {
        return timestampFormatter;
    }

    public String extractString(Data.Field field, BsonValue value) {
        return (String)Option$.MODULE$.apply((Object)value).flatMap((Function1 & Serializable)x$1 -> {
            BsonValue bsonValue = x$1;
            if (bsonValue instanceof BsonDateTime) {
                BsonDateTime dt = (BsonDateTime)bsonValue;
                return Some$.MODULE$.apply((Object)this.timestampFormatter().format(Instant.ofEpochMilli(dt.getValue()).atZone(ZoneId.systemDefault())));
            }
            if (bsonValue instanceof BsonTimestamp) {
                BsonTimestamp ts = (BsonTimestamp)bsonValue;
                return Some$.MODULE$.apply((Object)this.timestampFormatter().format(Instant.ofEpochMilli(ts.getValue()).atZone(ZoneId.systemDefault())));
            }
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String value = bs.getValue().trim();
                return Option$.MODULE$.apply((Object)field.dataType()).collect((PartialFunction)new Serializable(value){
                    private final String value$1;
                    {
                        this.value$1 = value$2;
                    }

                    public final boolean isDefinedAt(Data.Type x) {
                        Data.Type type = x;
                        if (Data.IsoLocalTimeType$.MODULE$.equals(type)) {
                            return true;
                        }
                        if (Data.IsoLocalDateType$.MODULE$.equals(type)) {
                            return true;
                        }
                        return Data.StringType$.MODULE$.equals(type);
                    }

                    public final Object applyOrElse(Data.Type x, Function1 function1) {
                        Data.Type type = x;
                        if (Data.IsoLocalTimeType$.MODULE$.equals(type)) {
                            return this.value$1.replace(":", "-");
                        }
                        if (Data.IsoLocalDateType$.MODULE$.equals(type)) {
                            return this.value$1;
                        }
                        if (Data.StringType$.MODULE$.equals(type)) {
                            return this.value$1;
                        }
                        return function1.apply((Object)x);
                    }
                });
            }
            if (bsonValue instanceof BsonBoolean) {
                BsonBoolean b = (BsonBoolean)bsonValue;
                if (b.getValue()) {
                    return Some$.MODULE$.apply((Object)"True");
                }
                return Some$.MODULE$.apply((Object)"False");
            }
            if (bsonValue instanceof BsonInt32) {
                BsonInt32 id = (BsonInt32)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)id.getValue()).toString());
            }
            if (bsonValue instanceof BsonInt64) {
                BsonInt64 id = (BsonInt64)bsonValue;
                return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)id.getValue()).toString());
            }
            return None$.MODULE$;
        }).getOrElse(DateConversions$::extractString$$anonfun$2);
    }

    private static final String extractString$$anonfun$2() {
        return "";
    }
}

