/*
 * Decompiled with CFR 0.152.
 */
package ambience.dataExplorer.validate;

import ambience.dataExplorer.DataColumn;
import ambience.dataExplorer.DataColumnValidations$;
import ambience.dataExplorer.validate.DateSupport;
import ambience.dataExplorer.validate.DateSupport$LocalDateSupport$;
import ambience.dataExplorer.validate.DateSupport$LocalTimeSupport$;
import ambience.dataExplorer.validate.Measures;
import ambience.dataExplorer.validate.Measures$Count$;
import ambience.dataExplorer.validate.Measures$DT$;
import ambience.dataExplorer.validate.Measures$Max$;
import ambience.dataExplorer.validate.Measures$Min$;
import ambience.dataExplorer.validate.Measures$Nulls$;
import ambience.dataExplorer.validate.Measures$Unique$;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import org.bson.BsonDecimal128;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonNumber;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.BsonValue;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.deriving.Mirror;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public final class Measures$
implements Mirror.Product,
Serializable {
    private static final Regex dateR;
    private static final Regex timeR;
    public static final Measures$DT$ DT;
    public static final Measures$Count$ Count;
    public static final Measures$Nulls$ Nulls;
    public static final Measures$Unique$ Unique;
    public static final Measures$Max$ Max;
    public static final Measures$Min$ Min;
    public static final Measures$ MODULE$;

    private Measures$() {
    }

    static {
        MODULE$ = new Measures$();
        dateR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{4}-\\d{2}-\\d{2})$"));
        timeR = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(\\d{2}:\\d{2}:\\d{2})$"));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Measures$.class);
    }

    public Measures apply(Map<String, String> validations) {
        return new Measures(validations);
    }

    public Measures unapply(Measures x$1) {
        return x$1;
    }

    public Map<String, String> $lessinit$greater$default$1() {
        return DataColumnValidations$.MODULE$.empty();
    }

    public Function1<Map<String, String>, Map<String, String>> fn(Measures.Measure measure) {
        return (Function1 & Serializable)vs -> {
            String string;
            Try<String> try_ = measure.calculate();
            if (try_ instanceof Success) {
                String text;
                string = text = (String)((Success)try_).value();
            } else if (try_ instanceof Failure) {
                Throwable throwable = ((Failure)try_).exception();
                if (throwable instanceof BsonInvalidOperationException) {
                    BsonInvalidOperationException ex = (BsonInvalidOperationException)throwable;
                    string = ex.getMessage().replace("Value expected to be of type", "Expected:").replace("is of unexpected type", "Actual:");
                } else {
                    Throwable exception = throwable;
                    string = exception.toString();
                }
            } else {
                throw new MatchError(try_);
            }
            String result = string;
            return (Map)vs.updated((Object)measure.name(), (Object)result);
        };
    }

    public String stringifyTimestamp(BsonTimestamp timestamp) {
        long ms = timestamp.getValue();
        Instant instant = Instant.ofEpochMilli(ms);
        LocalDateTime datetime = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
        return datetime.format(DateTimeFormatter.ISO_DATE_TIME);
    }

    public final Measures.DateTimeList DateTimeList(List<BsonValue> list) {
        return new Measures.DateTimeList(list);
    }

    private boolean isDate(String str) {
        return dateR.matches((CharSequence)str);
    }

    private boolean isDate(BsonString bs) {
        return this.isDate(bs.getValue());
    }

    private boolean isTime(String str) {
        return timeR.matches((CharSequence)str);
    }

    private boolean isTime(BsonString bs) {
        return this.isTime(bs.getValue());
    }

    public Function1<Map<String, String>, Map<String, String>> dt(DataColumn.ValidColumn valid) {
        return this.fn(Measures$DT$.MODULE$.apply(valid));
    }

    public Function1<Map<String, String>, Map<String, String>> count(DataColumn.ValidColumn valid) {
        return this.fn(Measures$Count$.MODULE$.apply(valid));
    }

    public Function1<Map<String, String>, Map<String, String>> nulls(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Nulls$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> unique(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Unique$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> maximumValue(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Max$.MODULE$.apply(vc));
    }

    public Function1<Map<String, String>, Map<String, String>> minimumValue(DataColumn.ValidColumn vc) {
        return this.fn(Measures$Min$.MODULE$.apply(vc));
    }

    public Measures fromProduct(Product x$0) {
        return new Measures((Map<String, String>)((Map)x$0.productElement(0)));
    }

    public static final /* synthetic */ long ambience$dataExplorer$validate$Measures$DateTimeList$$_$maxDate$$anonfun$1(BsonTimestamp _$1) {
        return _$1.getValue();
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$DateTimeList$$_$maxDate$$anonfun$2(BsonTimestamp timestamp) {
        return MODULE$.stringifyTimestamp(timestamp);
    }

    public static final /* synthetic */ long ambience$dataExplorer$validate$Measures$DateTimeList$$_$minDate$$anonfun$1(BsonTimestamp _$2) {
        return _$2.getValue();
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$DateTimeList$$_$minDate$$anonfun$2(BsonTimestamp timestamp) {
        return MODULE$.stringifyTimestamp(timestamp);
    }

    public static final /* synthetic */ boolean ambience$dataExplorer$validate$Measures$Nulls$$_$calculate$$anonfun$3$$anonfun$1(BsonValue _$3) {
        return _$3.isNull();
    }

    public static final /* synthetic */ IterableOnce ambience$dataExplorer$validate$Measures$Max$$_$_$$anonfun$1(BsonValue x$1) {
        BsonValue bsonValue = x$1;
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 dec = (BsonDecimal128)bsonValue;
            return (List)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)dec.doubleValue()), (List)Nil$.MODULE$);
        }
        if (bsonValue instanceof BsonNumber) {
            BsonNumber num = (BsonNumber)bsonValue;
            return (List)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)num.doubleValue()), (List)Nil$.MODULE$);
        }
        return package$.MODULE$.Nil();
    }

    public static /* bridge */ /* synthetic */ IterableOnce ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$adapted$1(Object x) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x)));
    }

    public static final /* synthetic */ double ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$2(double x1, double x2) {
        return Math.max(x1, x2);
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$3$$anonfun$1(String _$4) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(_$4), 64);
    }

    public static final /* synthetic */ boolean ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$3$$anonfun$2(String str) {
        return MODULE$.isDate(str);
    }

    public static final /* synthetic */ DateSupport.LocalDateSupport ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$3$$anonfun$3(String x$1) {
        Option<DateSupport.LocalDateSupport> option;
        String string = x$1;
        if (string != null && !(option = DateSupport$LocalDateSupport$.MODULE$.unapply(string)).isEmpty()) {
            DateSupport.LocalDateSupport localDateSupport;
            DateSupport.LocalDateSupport lds = localDateSupport = (DateSupport.LocalDateSupport)option.get();
            return lds;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ boolean ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$3$$anonfun$4(String str) {
        return MODULE$.isTime(str);
    }

    public static final /* synthetic */ DateSupport.LocalTimeSupport ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$3$$anonfun$5(String x$1) {
        Option<DateSupport.LocalTimeSupport> option;
        String string = x$1;
        if (string != null && !(option = DateSupport$LocalTimeSupport$.MODULE$.unapply(string)).isEmpty()) {
            DateSupport.LocalTimeSupport localTimeSupport;
            DateSupport.LocalTimeSupport lt = localTimeSupport = (DateSupport.LocalTimeSupport)option.get();
            return lt;
        }
        throw new MatchError((Object)string);
    }

    public static final String ambience$dataExplorer$validate$Measures$Max$$_$calculate$$anonfun$5$$anonfun$4() {
        return "";
    }

    public static final /* synthetic */ IterableOnce ambience$dataExplorer$validate$Measures$Min$$_$_$$anonfun$2(BsonValue x$1) {
        BsonValue bsonValue = x$1;
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 dec = (BsonDecimal128)bsonValue;
            return (List)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)dec.doubleValue()), (List)Nil$.MODULE$);
        }
        if (bsonValue instanceof BsonNumber) {
            BsonNumber num = (BsonNumber)bsonValue;
            return (List)new .colon.colon((Object)BoxesRunTime.boxToDouble((double)num.doubleValue()), (List)Nil$.MODULE$);
        }
        return package$.MODULE$.Nil();
    }

    public static /* bridge */ /* synthetic */ IterableOnce ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$adapted$1(Object x) {
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)x)));
    }

    public static final /* synthetic */ double ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$2(double x1, double x2) {
        return Math.min(x1, x2);
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$1(String _$5) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(_$5), 64);
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$2(BsonValue _$6) {
        return _$6.asString().getValue();
    }

    public static final /* synthetic */ boolean ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$3(String str) {
        return MODULE$.isDate(str);
    }

    public static final /* synthetic */ DateSupport.LocalDateSupport ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$4(String x$1) {
        Option<DateSupport.LocalDateSupport> option;
        String string = x$1;
        if (string != null && !(option = DateSupport$LocalDateSupport$.MODULE$.unapply(string)).isEmpty()) {
            DateSupport.LocalDateSupport localDateSupport;
            DateSupport.LocalDateSupport lds = localDateSupport = (DateSupport.LocalDateSupport)option.get();
            return lds;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ String ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$5(BsonValue _$7) {
        return _$7.asString().getValue();
    }

    public static final /* synthetic */ boolean ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$6(String str) {
        return MODULE$.isTime(str);
    }

    public static final /* synthetic */ DateSupport.LocalTimeSupport ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$3$$anonfun$7(String x$1) {
        Option<DateSupport.LocalTimeSupport> option;
        String string = x$1;
        if (string != null && !(option = DateSupport$LocalTimeSupport$.MODULE$.unapply(string)).isEmpty()) {
            DateSupport.LocalTimeSupport localTimeSupport;
            DateSupport.LocalTimeSupport lt = localTimeSupport = (DateSupport.LocalTimeSupport)option.get();
            return lt;
        }
        throw new MatchError((Object)string);
    }

    public static final String ambience$dataExplorer$validate$Measures$Min$$_$calculate$$anonfun$6$$anonfun$4() {
        return "";
    }
}

