/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.opc.docprocessor.BTInfo;
import com.elixirtech.opc.docprocessor.Backtrack;
import com.elixirtech.opc.docprocessor.StackFrame;
import com.elixirtech.opc.docprocessor.TablePos;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.mozilla.javascript.Scriptable;

public class DocRenderContext {
    private JavaScriptEngine m_JSEngine;
    private Stack<StackFrame> m_StackFrames = new Stack();
    private StackFrame m_CurrentStackFrame;
    private Stack<BTInfo> m_LocalStack = new Stack();
    private Map<String, DataTable> m_TableLookup = new HashMap<String, DataTable>();
    private boolean m_Ended;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger((String)"com.elixirtech.opc.DocProcessor");

    public DocRenderContext() {
        this.m_JSEngine = JavaScriptEngine.getInstance();
        this.m_JSEngine.reset();
    }

    public void declareBean(String string, Object object) {
        this.m_JSEngine.declareBean(string, object);
    }

    public void pushScope(Scriptable scriptable) {
        this.m_JSEngine.pushScope(scriptable);
    }

    public Object evaluate(String string, String string2) throws ScriptException {
        return this.m_JSEngine.evaluate(string, string2);
    }

    public void popScope() {
        this.m_JSEngine.popScope();
    }

    public void dispose() {
        JavaScriptEngine.disposeInstance();
    }

    public boolean hasTable() {
        return this.m_CurrentStackFrame != null;
    }

    public TablePos getTablePos() {
        return this.m_CurrentStackFrame.tablePos;
    }

    public void pushBacktrack(BTInfo bTInfo) {
        this.getBacktrack().push(bTInfo);
    }

    public BTInfo popBacktrack() {
        return this.getBacktrack().pop();
    }

    public boolean isBacktrackEmpty() {
        return this.getBacktrack().isEmpty();
    }

    public Backtrack peekBacktrack() {
        return this.getBacktrack().peek().bt;
    }

    public String peekBacktrackInfo() {
        return this.getBacktrack().peek().info;
    }

    public boolean isTableDefined(String string) {
        return this.m_TableLookup.containsKey(string);
    }

    public void addTable(String string, DataTable dataTable) {
        this.m_TableLookup.put(string, dataTable);
    }

    public void elxTable(String string, DataTable dataTable) {
        this.addTable(string, dataTable);
        if (this.m_Ended) {
            this.m_Ended = false;
            this.m_CurrentStackFrame = null;
            this.popScope();
        }
        StackFrame stackFrame = new StackFrame(new TablePos(string, dataTable));
        if (this.m_CurrentStackFrame != null) {
            this.m_StackFrames.push(this.m_CurrentStackFrame);
        }
        this.m_CurrentStackFrame = stackFrame;
        this.pushScope((Scriptable)stackFrame.tablePos.getScope());
    }

    public DataTable getTable(String string) {
        return this.m_TableLookup.get(string);
    }

    public String getCurrentTableName() {
        if (this.m_CurrentStackFrame == null) {
            return null;
        }
        return this.m_CurrentStackFrame.getTableName();
    }

    public String getValue(String string, String string2, String string3) {
        DataTable dataTable;
        StackFrame stackFrame = this.getStackFrame(string2);
        DataRecord dataRecord = null;
        if (stackFrame != null) {
            dataRecord = stackFrame.tablePos.getRecord();
        } else {
            dataTable = this.getTable(string2);
            if (dataTable != null && dataTable.getRecordCount() > 0) {
                dataRecord = dataTable.getRecord(0);
            }
        }
        if (dataRecord != null) {
            dataTable = dataRecord.getSchema();
            int n = dataTable.getColumnIndex(string3);
            if (n < 0) {
                m_Log.warn((Object)("No substitution field for " + string2 + ":" + string3));
                return "";
            }
            DataType dataType = dataTable.getColumnType(n);
            Object object = dataRecord.getData(n);
            if ("%s".equals(string)) {
                return dataTable.format(dataType, object);
            }
            return String.format(string, object);
        }
        m_Log.warn((Object)("No substitution value for " + string2 + ":" + string3));
        return "";
    }

    private StackFrame getStackFrame(String string) {
        for (StackFrame stackFrame : this.m_StackFrames) {
            if (!stackFrame.getTableName().equals(string)) continue;
            return stackFrame;
        }
        return null;
    }

    public void elxEnd() {
        if (!this.m_StackFrames.isEmpty()) {
            this.m_CurrentStackFrame = this.m_StackFrames.pop();
            this.popScope();
        } else {
            this.m_Ended = true;
        }
    }

    public void error(String string) {
        m_Log.error((Object)string);
    }

    public void error(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    public void info(String string) {
        m_Log.info((Object)string);
    }

    public void warn(String string) {
        m_Log.warn((Object)string);
    }

    public void debug(String string) {
        m_Log.debug((Object)string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (StackFrame stackFrame : this.m_StackFrames) {
            stringBuffer.append("Stack {" + stackFrame + "}\n");
        }
        return stringBuffer.toString();
    }

    private Stack<BTInfo> getBacktrack() {
        return this.m_LocalStack;
    }
}

