/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.arch.ByteUtil;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.opc.docprocessor.DocRenderContext;
import com.elixirtech.opc.docprocessor.MediaHandler;
import com.elixirtech.opc.docprocessor.Processor;
import com.elixirtech.opc.docprocessor.TablePos;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class ImageHandler {
    static String handle(Processor processor, DocRenderContext docRenderContext, String string) {
        TablePos tablePos = docRenderContext.getTablePos();
        DataSchema dataSchema = tablePos.getSchema();
        int n = dataSchema.getColumnIndex(string);
        if (n >= 0) {
            Object object;
            DataRecord dataRecord = tablePos.getRecord();
            DataType dataType = dataSchema.getColumnType(n);
            byte[] byArray = null;
            switch (dataType.getTypeId()) {
                case 17: {
                    byArray = (byte[])dataRecord.getData(n);
                    break;
                }
                case 2: {
                    object = (String)dataRecord.getData(n);
                    byArray = ByteUtil.decodeBase64((String)object);
                    break;
                }
                default: {
                    docRenderContext.error("Unexpected image data type: " + dataType.getTypeName());
                    return null;
                }
            }
            try {
                Object object2;
                object = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray));
                Iterator<ImageReader> iterator = ImageIO.getImageReaders(object);
                boolean bl = false;
                while (iterator.hasNext()) {
                    object2 = iterator.next().getFormatName();
                    if (!((String)object2).toUpperCase(Locale.ENGLISH).contains("PNG")) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    object2 = ImageIO.read(new ByteArrayInputStream(byArray));
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)object2, "PNG", byteArrayOutputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                }
                return ImageHandler.addMedia(processor, byArray);
            }
            catch (IOException iOException) {
                docRenderContext.error("Error reading bytes as image: " + iOException);
                return null;
            }
        }
        docRenderContext.error("No such column: " + string);
        return null;
    }

    static String addMedia(Processor processor, byte[] byArray) {
        MediaHandler mediaHandler = new MediaHandler(processor);
        String string = mediaHandler.addMedia("image/png", byArray);
        return string;
    }
}

