/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.docprocessor;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.RecordScope;
import java.util.List;

class TablePos {
    public final String name;
    public final DataTable table;
    public GroupNode group;
    public int depth;
    private int m_Index;
    private RecordScope m_Scope;

    public TablePos(String string, DataTable dataTable) {
        this.name = string;
        this.table = dataTable;
        this.group = dataTable.getGroups();
        this.m_Scope = new RecordScope(dataTable.getSchema());
        if (dataTable.getRecordCount() > 0) {
            this.setIndex(0);
        }
    }

    public RecordScope getScope() {
        return this.m_Scope;
    }

    public boolean isGrouped() {
        return this.group.hasChildren();
    }

    public DataSchema getSchema() {
        return this.table.getSchema();
    }

    public DataRecord getRecord() {
        return this.table.getRecord(this.m_Index);
    }

    public boolean hasNextRecord() {
        return this.m_Index < this.group.getStop();
    }

    public boolean hasMoreRecords() {
        return this.m_Index < this.table.getRecordCount() - 1;
    }

    public void nextRecord() {
        this.setIndex(this.m_Index + 1);
    }

    public boolean hasChildGroup() {
        return this.group.hasChildren();
    }

    public boolean hasNextGroup() {
        GroupNode groupNode = this.group.getParent();
        if (groupNode == null) {
            return false;
        }
        List list = groupNode.getChildList();
        int n = list.indexOf(this.group);
        return n + 1 < list.size();
    }

    public void nextGroup() {
        GroupNode groupNode = this.group.getParent();
        List list = groupNode.getChildList();
        int n = list.indexOf(this.group);
        this.group = (GroupNode)list.get(n + 1);
        this.setIndex(this.group.getStart());
    }

    public void pushGroup() {
        ++this.depth;
        this.group = (GroupNode)this.group.getChildIterator().next();
    }

    public void popGroup() {
        --this.depth;
        this.group = this.group.getParent();
    }

    public String toString() {
        return "TablePos name: " + this.name + " idx: " + this.m_Index;
    }

    private void setIndex(int n) {
        this.m_Index = n;
        this.m_Scope.setData(this.table.getRecord(this.m_Index).getData());
    }
}

