/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets;

import ambience.arch.package$;
import ambience.secrets.AzureSecretsStoreLocation$AddInfo$;
import ambience.secrets.SecretsStore;
import ambience.secrets.SecretsStore$Content$;
import ambience.secrets.SecretsStore$ContentId$;
import ambience.secrets.SecretsStoreAPI;
import com.azure.core.credential.TokenCredential;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.SyncPoller;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.SecretClientBuilder;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexUpdate;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class AzureSecretsStoreLocation
implements SecretsStore.Location,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AzureSecretsStoreLocation.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final SecretsStoreAPI.SSConfig ssConfig;
    private final String vault;
    private final String clientId;
    private final String clientSecret;
    private final String tenantId;
    private final ClientSecretCredential credentials;
    private final SecretClient client;
    private final boolean explicitPurge;
    private final boolean isAddable;
    private final boolean isLinkable;

    public AzureSecretsStoreLocation(SecretsStoreAPI.SSConfig ssConfig) {
        this.ssConfig = ssConfig;
        this.vault = "https://" + Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("vault")) + ".vault.azure.net";
        this.clientId = Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("clientId"));
        this.clientSecret = Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("clientSecret"));
        this.tenantId = Crypt$.MODULE$.encPrefixDecrypt(ssConfig.config().getString("tenantId"));
        this.credentials = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId(this.clientId())).clientSecret(this.clientSecret()).tenantId(this.tenantId())).build();
        this.client = new SecretClientBuilder().vaultUrl(this.vault()).credential((TokenCredential)this.credentials()).buildClient();
        this.explicitPurge = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> AzureSecretsStoreLocation.$init$$$anonfun$1(ssConfig)).toOption().getOrElse(AzureSecretsStoreLocation::$init$$$anonfun$2));
        boolean req = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> AzureSecretsStoreLocation.$anonfun$1(ssConfig)).toOption().getOrElse(AzureSecretsStoreLocation::$anonfun$2));
        if (req) {
            this.log().warn(AzureSecretsStoreLocation::$init$$$anonfun$3, Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.secrets.AzureSecretsStoreLocation.isAddable"));
        }
        this.isAddable = false;
        this.isLinkable = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> AzureSecretsStoreLocation.$init$$$anonfun$4(ssConfig)).toOption().getOrElse(AzureSecretsStoreLocation::$init$$$anonfun$5));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String vault() {
        return this.vault;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientSecret() {
        return this.clientSecret;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public ClientSecretCredential credentials() {
        return this.credentials;
    }

    public SecretClient client() {
        return this.client;
    }

    public boolean explicitPurge() {
        return this.explicitPurge;
    }

    @Override
    public boolean isAddable() {
        return this.isAddable;
    }

    @Override
    public boolean isLinkable() {
        return this.isLinkable;
    }

    @Override
    public String id() {
        return this.ssConfig.id();
    }

    @Override
    public Task<Either<LogMessage, Document>> add(Document doc) {
        return Task$.MODULE$.apply(() -> this.add$$anonfun$1(doc));
    }

    public Either<LogMessage, Document> addToVault(Document doc, AddInfo info) {
        Either either;
        try {
            KeyVaultSecret keyVaultSecret = this.client().setSecret(new KeyVaultSecret(info.name(), info.secret()));
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentId");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(String.valueOf(info.name()))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"control");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBoolean$.MODULE$.apply(true)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            either = package$.MODULE$.right(((BaseDocument)((BaseDocument)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"secret"}))).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)));
        }
        catch (Exception e) {
            either = package$.MODULE$.leftError("unable to add secret to vault: " + e);
        }
        return either;
    }

    public Either<LogMessage, Document> linkToVault(Document doc, AddInfo info) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"control");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBoolean$.MODULE$.apply(false)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.right(((BaseDocument)doc.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"secret"}))).$plus((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    @Override
    public Task<Either<LogMessage, List<SecretsStore.ContentId>>> all() {
        Task task;
        try {
            task = Task$.MODULE$.apply(this::all$$anonfun$1);
        }
        catch (Exception e) {
            task = Task$.MODULE$.apply(() -> AzureSecretsStoreLocation.all$$anonfun$2(e));
        }
        return task;
    }

    @Override
    public Task<Option<SecretsStore.Content>> get(String id) {
        return Task$.MODULE$.apply(() -> this.get$$anonfun$1(id));
    }

    @Override
    public Task<Option<Object>> remove(String id) {
        return Task$.MODULE$.apply(() -> this.remove$$anonfun$1(id));
    }

    public void purge(String id) {
        try {
            this.client().purgeDeletedSecret(id);
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)("Unable to purge secret: " + e));
        }
    }

    @Override
    public Task<Option<CodexUpdate>> update(Document doc) {
        Tuple2 tuple2;
        Option d = doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> Crypt$.MODULE$.encPrefixDecrypt(s.getValue(), false)).flatMap((Function1 & Serializable)name -> doc.get("secret", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> this.asSecret(s.getValue())).map((Function1 & Serializable)secret -> Tuple2$.MODULE$.apply(name, secret)));
        Option option = d;
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            String name2 = (String)tuple2._1();
            String secret = (String)tuple2._2();
            this.client().setSecret(new KeyVaultSecret(name2, secret));
            return Task$.MODULE$.none();
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.none();
        }
        throw new MatchError((Object)option);
    }

    public String asSecret(String s) {
        return new String(Base64.getDecoder().decode(s), StandardCharsets.UTF_8);
    }

    private static final boolean $init$$$anonfun$1(SecretsStoreAPI.SSConfig ssConfig$1) {
        return ssConfig$1.config().getBoolean("explicit-purge");
    }

    private static final boolean $init$$$anonfun$2() {
        return true;
    }

    private static final boolean $anonfun$1(SecretsStoreAPI.SSConfig ssConfig$2) {
        return ssConfig$2.config().getBoolean("is-addable");
    }

    private static final boolean $anonfun$2() {
        return false;
    }

    private static final Object $init$$$anonfun$3() {
        return "Azure does not support addable true. Defaulting to false";
    }

    private static final boolean $init$$$anonfun$4(SecretsStoreAPI.SSConfig ssConfig$3) {
        return ssConfig$3.config().getBoolean("is-linkable");
    }

    private static final boolean $init$$$anonfun$5() {
        return true;
    }

    private final Either add$$anonfun$1(Document doc$1) {
        Option d = doc$1.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> Crypt$.MODULE$.encPrefixDecrypt(s.getValue(), false)).flatMap((Function1 & Serializable)name -> doc$1.get("secret", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)s -> this.asSecret(s.getValue())).flatMap((Function1 & Serializable)secret -> doc$1.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue()).map((Function1 & Serializable)contentId -> AzureSecretsStoreLocation$AddInfo$.MODULE$.apply((String)name, (String)secret, (String)contentId))));
        Option option = d;
        if (option instanceof Some) {
            AddInfo addInfo = (AddInfo)((Some)option).value();
            AddInfo info = addInfo;
            if (info.isLink()) {
                return this.linkToVault(doc$1, info);
            }
            AddInfo info2 = addInfo;
            return this.addToVault(doc$1, info2);
        }
        return package$.MODULE$.leftError("malformed doc");
    }

    private final Either all$$anonfun$1() {
        return package$.MODULE$.right((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.client().listPropertiesOfSecrets().stream().toList()).asScala().toList().map((Function1 & Serializable)a -> new SecretsStore.ContentId(SecretsStore$ContentId$.MODULE$.apply(a.getName()))).toList());
    }

    private static final Either all$$anonfun$2(Exception e$1) {
        return package$.MODULE$.left((LogMessage)LogMessage.Error$.MODULE$.apply("Unable to list all Azure secrets: " + e$1));
    }

    private static final Object get$$anonfun$1$$anonfun$1(String id$2) {
        return "Reading " + id$2;
    }

    private final Some get$$anonfun$1(String id$1) {
        this.log().info(() -> AzureSecretsStoreLocation.get$$anonfun$1$$anonfun$1(id$1), Line$.MODULE$.apply(96), FullName$.MODULE$.apply("ambience.secrets.AzureSecretsStoreLocation.get"));
        KeyVaultSecret secret = this.client().getSecret(id$1);
        String secretValue = secret.getValue();
        return Some$.MODULE$.apply((Object)SecretsStore$Content$.MODULE$.apply(secretValue, (Option<Object>)None$.MODULE$));
    }

    private final Some remove$$anonfun$1(String id$3) {
        Some some;
        try {
            SyncPoller d = this.client().beginDeleteSecret(id$3);
            PollResponse end = d.waitUntil(LongRunningOperationStatus.SUCCESSFULLY_COMPLETED);
            if (this.explicitPurge()) {
                this.purge(id$3);
            }
            some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)end.getStatus().isComplete()));
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)("Unable to delete secret: " + e));
            some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return some;
    }

    public static final class AddInfo
    implements Product,
    Serializable {
        private final String name;
        private final String secret;
        private final String contentId;

        public static AddInfo apply(String string, String string2, String string3) {
            return AzureSecretsStoreLocation$AddInfo$.MODULE$.apply(string, string2, string3);
        }

        public static AddInfo fromProduct(Product product) {
            return AzureSecretsStoreLocation$AddInfo$.MODULE$.fromProduct(product);
        }

        public static AddInfo unapply(AddInfo addInfo) {
            return AzureSecretsStoreLocation$AddInfo$.MODULE$.unapply(addInfo);
        }

        public AddInfo(String name, String secret, String contentId) {
            this.name = name;
            this.secret = secret;
            this.contentId = contentId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AddInfo)) return false;
            AddInfo addInfo = (AddInfo)object;
            String string = this.name();
            String string2 = addInfo.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.secret();
            String string4 = addInfo.secret();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.contentId();
            String string6 = addInfo.contentId();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AddInfo;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "AddInfo";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "secret";
                }
                case 2: {
                    return "contentId";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public String secret() {
            return this.secret;
        }

        public String contentId() {
            return this.contentId;
        }

        public boolean isLink() {
            return StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.contentId()));
        }

        public AddInfo copy(String name, String secret, String contentId) {
            return new AddInfo(name, secret, contentId);
        }

        public String copy$default$1() {
            return this.name();
        }

        public String copy$default$2() {
            return this.secret();
        }

        public String copy$default$3() {
            return this.contentId();
        }

        public String _1() {
            return this.name();
        }

        public String _2() {
            return this.secret();
        }

        public String _3() {
            return this.contentId();
        }
    }
}

