/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets.etl;

import ambience.api.Secrets;
import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.framework.AESCipher;
import ambience.framework.AESCipher$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.secrets.etl.LookupToken;
import ambience.secrets.etl.LookupToken$Info$;
import ambience.secrets.etl.SecretsCategory$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.codex.CodexFilter;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class LookupToken$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    public static final LookupToken$Info$ Info;
    public static final LookupToken$ MODULE$;

    private LookupToken$() {
    }

    static {
        MODULE$ = new LookupToken$();
        stepType = ETLStepType$.MODULE$.apply("secrets.LookupToken");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LookupToken$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        return SecretsCategory$.MODULE$.getSecretChoices(cxt.user()).map((Function1 & Serializable)secretChoices -> {
            String string = "tokenField";
            String string2 = "resultField";
            String string3 = "secret";
            int size = 3;
            LookupToken.Info info = (LookupToken.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", LookupToken$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), LookupToken$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(LookupToken$::$anonfun$3))))).toOption().getOrElse(LookupToken$::$anonfun$4);
            Panel.Item tokenField = PanelItem$.MODULE$.text("tokenField", "Token Field", info.tokenField(), PanelItem$.MODULE$.text$default$4());
            Panel.Item resultField = PanelItem$.MODULE$.text("resultField", "Result Field", info.resultField(), PanelItem$.MODULE$.text$default$4());
            Panel.Item secretField = PanelItem$.MODULE$.select("secret", "Secret", Json$.MODULE$.fromString(info.secret()), secretChoices, PanelItem$.MODULE$.select$default$5());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)tokenField, (List)new .colon.colon((Object)resultField, (List)new .colon.colon((Object)secretField, (List)Nil$.MODULE$))));
        });
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> LookupToken$.savePanel$$anonfun$1(results, step));
    }

    public Task<Option<String>> explain(ETLStep step) {
        return Task$.MODULE$.apply(() -> LookupToken$.explain$$anonfun$1(step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "tokenField";
        String string2 = "resultField";
        String string3 = "secret";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", LookupToken$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), LookupToken$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(LookupToken$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (LookupToken.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, LookupToken.Info info, Observable<Document> from) {
        if (info.tokenField().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Token Field"));
        }
        if (info.resultField().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Result Field"));
        }
        if (info.secret().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Secret"));
        }
        return Observable$.MODULE$.fromTask(SecretsCategory$.MODULE$.getSecret(cxt.user(), info.secret())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Secrets.Value secret = (Secrets.Value)((Right)either).value();
                return from.mapEval((Function1 & Serializable)doc -> MODULE$.runDoc(cxt, info, secret, (Document)doc));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return cxt.logStart(from, msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Document> runDoc(Builder.Context cxt, LookupToken.Info info, Secrets.Value secret, Document doc) {
        BsonValue bsonValue;
        Option option = BsonETL$.MODULE$.get(doc, info.tokenField());
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString bs = (BsonString)bsonValue;
            return SecretsCategory$.MODULE$.tokenCltnT().flatMap((Function1 & Serializable)cltn -> cltn.findOneO((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)bs)).firstOptionL().flatMap((Function1 & Serializable)optResult -> Task$.MODULE$.apply(() -> LookupToken$.runDoc$$anonfun$1$$anonfun$1$$anonfun$1(optResult, secret)).map((Function1 & Serializable)optBson -> (Document)optBson.map((Function1 & Serializable)value -> BsonETL$.MODULE$.put(doc, info.resultField(), value)).getOrElse(() -> LookupToken$.runDoc$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(doc)))));
        }
        return cxt.logRecord(doc, (LogMessage)LogMessage.Info$.MODULE$.apply("No token in field " + info.resultField()));
    }

    public BsonValue recreateBson(AESCipher.Secret secret, Document doc) {
        Option option = doc.get("value", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class));
        if (option instanceof Some) {
            BsonBinary bs = (BsonBinary)((Some)option).value();
            String json = new String(AESCipher$.MODULE$.decrypt(secret, bs.getData()));
            Document doc2 = ambience.etl.package$.MODULE$.ETLRecord().apply(json);
            if (doc2.contains("elxWrapper")) {
                return doc2.apply("elxWrapper", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            }
            return ((BaseDocument)doc2.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"elxWhen"}))).toBsonDocument();
        }
        return BsonNull$.MODULE$.apply();
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        LookupToken$Info$ lookupToken$Info$ = LookupToken$Info$.MODULE$;
        return (Function1 & Serializable)p -> (LookupToken.Info)lookupToken$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final LookupToken.Info $anonfun$4() {
        return LookupToken$Info$.MODULE$.apply(LookupToken$Info$.MODULE$.$lessinit$greater$default$1(), LookupToken$Info$.MODULE$.$lessinit$greater$default$2(), LookupToken$Info$.MODULE$.$lessinit$greater$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        LookupToken$Info$ lookupToken$Info$ = LookupToken$Info$.MODULE$;
        return (Function1 & Serializable)p -> (LookupToken.Info)lookupToken$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "tokenField";
        String string2 = "resultField";
        String string3 = "secret";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", LookupToken$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), LookupToken$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(LookupToken$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            LookupToken.Info info2 = (LookupToken.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "tokenField";
            String string2 = "resultField";
            String string3 = "secret";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(LookupToken$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$2.copy$default$1();
            String string5 = step$2.copy$default$2();
            String string6 = step$2.copy$default$3();
            String string7 = step$2.copy$default$4();
            String string8 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List explain$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 explain$$anonfun$1$$anonfun$2() {
        LookupToken$Info$ lookupToken$Info$ = LookupToken$Info$.MODULE$;
        return (Function1 & Serializable)p -> (LookupToken.Info)lookupToken$Info$.fromProduct((Product)p);
    }

    private static final Product explain$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final Option explain$$anonfun$1(ETLStep step$4) {
        String string = "tokenField";
        String string2 = "resultField";
        String string3 = "secret";
        int size = 3;
        return step$4.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", LookupToken$::explain$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), LookupToken$::explain$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(LookupToken$::explain$$anonfun$1$$anonfun$3))))).toOption().map((Function1 & Serializable)info -> "Lookup token defined in field <pre>" + info.tokenField() + "</pre> returning the value into <pre>" + info.resultField() + ".");
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        LookupToken$Info$ lookupToken$Info$ = LookupToken$Info$.MODULE$;
        return (Function1 & Serializable)p -> (LookupToken.Info)lookupToken$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)LookupToken$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final Option runDoc$$anonfun$1$$anonfun$1$$anonfun$1(Option optResult$1, Secrets.Value secret$4) {
        AESCipher.Secret secret = AESCipher.Secret$.MODULE$.apply(secret$4.value());
        return optResult$1.map((Function1 & Serializable)doc -> MODULE$.recreateBson(secret, (Document)doc));
    }

    private static final Document runDoc$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Document doc$5) {
        return doc$5;
    }
}

