/*
 * Decompiled with CFR 0.152.
 */
package ambience.secrets.etl;

import ambience.api.Secrets;
import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.framework.AESCipher;
import ambience.framework.AESCipher$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.secrets.etl.SecretsCategory$;
import ambience.secrets.etl.TokeniseData;
import ambience.secrets.etl.TokeniseData$Info$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.gravity.Gravity$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TokeniseData$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(TokeniseData$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final TokeniseData$Info$ Info;
    public static final TokeniseData$ MODULE$;

    private TokeniseData$() {
    }

    static {
        MODULE$ = new TokeniseData$();
        stepType = ETLStepType$.MODULE$.apply("secrets.TokeniseData");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TokeniseData$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        return SecretsCategory$.MODULE$.getSecretChoices(cxt.user()).map((Function1 & Serializable)secretChoices -> {
            String string = "field";
            String string2 = "tokenField";
            String string3 = "secret";
            int size = 3;
            TokeniseData.Info info = (TokeniseData.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", TokeniseData$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), TokeniseData$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(TokeniseData$::$anonfun$3))))).toOption().getOrElse(TokeniseData$::$anonfun$4);
            Panel.Item nameField = PanelItem$.MODULE$.text("field", "Field to Store", info.field(), PanelItem$.MODULE$.text$default$4());
            Panel.Item tokenField = PanelItem$.MODULE$.text("tokenField", "Token Field", info.tokenField(), PanelItem$.MODULE$.text$default$4());
            Panel.Item secretField = PanelItem$.MODULE$.select("secret", "Secret", Json$.MODULE$.fromString(info.secret()), secretChoices, PanelItem$.MODULE$.select$default$5());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)nameField, (List)new .colon.colon((Object)tokenField, (List)new .colon.colon((Object)secretField, (List)Nil$.MODULE$))));
        });
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> TokeniseData$.savePanel$$anonfun$1(results, step));
    }

    public Task<Option<String>> explain(ETLStep step) {
        return Task$.MODULE$.apply(() -> TokeniseData$.explain$$anonfun$1(step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "field";
        String string2 = "tokenField";
        String string3 = "secret";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", TokeniseData$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), TokeniseData$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(TokeniseData$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (TokeniseData.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, TokeniseData.Info info, Observable<Document> from) {
        if (info.field().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Field To Store"));
        }
        if (info.tokenField().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Token Field"));
        }
        if (info.secret().isEmpty()) {
            return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Empty Secret"));
        }
        return Observable$.MODULE$.fromTask(SecretsCategory$.MODULE$.getSecret(cxt.user(), info.secret())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Secrets.Value secret = (Secrets.Value)((Right)either).value();
                return from.mapEval((Function1 & Serializable)doc -> MODULE$.runDoc(cxt, info, secret, (Document)doc));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return cxt.logStart(from, msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Document> runDoc(Builder.Context cxt, TokeniseData.Info info, Secrets.Value secret, Document doc) {
        Option option = BsonETL$.MODULE$.get(doc, info.field());
        if (option instanceof Some) {
            BsonValue bv = (BsonValue)((Some)option).value();
            String uuid = UUID.randomUUID().toString();
            Document rec = this.buildDoc(secret, bv, uuid);
            return SecretsCategory$.MODULE$.tokenCltnT().flatMap((Function1 & Serializable)cltn -> cltn.insertOneT(rec).map((Function1 & Serializable)x$1 -> {
                CodexDB.InsertOneResult insertOneResult = x$1;
                return (Document)BsonETL$.MODULE$.put(doc, info.tokenField(), (BsonValue)BsonString$.MODULE$.apply(uuid)).$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{info.field()}));
            }));
        }
        if (None$.MODULE$.equals(option)) {
            return cxt.logRecord(doc, (LogMessage)LogMessage.Info$.MODULE$.apply("No value in field " + info.field()));
        }
        throw new MatchError((Object)option);
    }

    public Document buildDoc(Secrets.Value secret, BsonValue bv, String uuid) {
        String jsonString = this.bsonToJson(bv);
        byte[] encrypted = AESCipher$.MODULE$.encrypt(AESCipher.Secret$.MODULE$.apply(secret.value()), jsonString.getBytes(Gravity$.MODULE$.UTF_8()));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)uuid), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"value");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBinary$.MODULE$.apply(encrypted)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return ambience.etl.package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public String bsonToJson(BsonValue bv) {
        BsonDocument bsonDocument;
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonDocument) {
            BsonDocument bdoc;
            bsonDocument = bdoc = (BsonDocument)bsonValue;
        } else {
            BsonValue other = bsonValue;
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"elxWrapper");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)other), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        BsonDocument bdoc = bsonDocument;
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"elxWhen");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return ((BaseDocument)ambience.etl.package$.MODULE$.ETLRecord().apply(bdoc).updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).toJson(JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).build());
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        TokeniseData$Info$ tokeniseData$Info$ = TokeniseData$Info$.MODULE$;
        return (Function1 & Serializable)p -> (TokeniseData.Info)tokeniseData$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final TokeniseData.Info $anonfun$4() {
        return TokeniseData$Info$.MODULE$.apply(TokeniseData$Info$.MODULE$.$lessinit$greater$default$1(), TokeniseData$Info$.MODULE$.$lessinit$greater$default$2(), TokeniseData$Info$.MODULE$.$lessinit$greater$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        TokeniseData$Info$ tokeniseData$Info$ = TokeniseData$Info$.MODULE$;
        return (Function1 & Serializable)p -> (TokeniseData.Info)tokeniseData$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "field";
        String string2 = "tokenField";
        String string3 = "secret";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", TokeniseData$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), TokeniseData$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(TokeniseData$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            TokeniseData.Info info2 = (TokeniseData.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "field";
            String string2 = "tokenField";
            String string3 = "secret";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(TokeniseData$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$2.copy$default$1();
            String string5 = step$2.copy$default$2();
            String string6 = step$2.copy$default$3();
            String string7 = step$2.copy$default$4();
            String string8 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List explain$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 explain$$anonfun$1$$anonfun$2() {
        TokeniseData$Info$ tokeniseData$Info$ = TokeniseData$Info$.MODULE$;
        return (Function1 & Serializable)p -> (TokeniseData.Info)tokeniseData$Info$.fromProduct((Product)p);
    }

    private static final Product explain$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final Option explain$$anonfun$1(ETLStep step$4) {
        String string = "field";
        String string2 = "tokenField";
        String string3 = "secret";
        int size = 3;
        return step$4.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", TokeniseData$::explain$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), TokeniseData$::explain$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(TokeniseData$::explain$$anonfun$1$$anonfun$3))))).toOption().map((Function1 & Serializable)info -> "Tokenise data in field <pre>" + info.field() + "</pre> returning a string token into <pre>" + info.tokenField() + ".");
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        TokeniseData$Info$ tokeniseData$Info$ = TokeniseData$Info$.MODULE$;
        return (Function1 & Serializable)p -> (TokeniseData.Info)tokeniseData$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)TokeniseData$Info$.MODULE$.$lessinit$greater$default$3()));
    }
}

