/*
 * Decompiled with CFR 0.152.
 */
package ambience.dashboard.view.pivot.table;

import ambience.dashboard.view.pivot.Pdf;
import ambience.dashboard.view.pivot.Pdf$Dim$;
import ambience.dashboard.view.pivot.table.Presenter;
import ambience.dashboard.view.pivot.table.TableDisplay;
import ambience.dashboard.view.pivot.table.TableDisplay$DHidden$;
import ambience.dashboard.view.pivot.table.TableDisplay$DRow$;
import ambience.dashboard.view.pivot.table.TableDisplay$DTopLeft$;
import ambience.dashboard.view.pivot.table.TableDisplay$Irregular$;
import ambience.dashboard.view.pivot.table.TableStructure;
import ambience.dashboard.view.pivot.table.TextMetrics;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class TableDisplay$
implements Serializable {
    public static final TableDisplay$DRow$ DRow;
    public static final TableDisplay$DTopLeft$ DTopLeft;
    public static final TableDisplay$DHidden$ DHidden;
    public static final TableDisplay$Irregular$ Irregular;
    private static final Pdf.Dim HPadding;
    private static final Pdf.Dim VPadding;
    public static final TableDisplay$ MODULE$;

    private TableDisplay$() {
    }

    static {
        MODULE$ = new TableDisplay$();
        HPadding = Pdf$Dim$.MODULE$.pts(5.0f);
        VPadding = Pdf$Dim$.MODULE$.pts(3.0f);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TableDisplay$.class);
    }

    public Pdf.Dim HPadding() {
        return HPadding;
    }

    public Pdf.Dim VPadding() {
        return VPadding;
    }

    public void apply(TableStructure.Table t, TextMetrics metrics, Presenter presenter) {
        ListBuffer rows = new ListBuffer();
        try {
            ((List)t.rows().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
                Tuple2 tuple2 = x$12;
                if (tuple2 != null) {
                    TableStructure.Row row = (TableStructure.Row)tuple2._1();
                    int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    IntRef xOffset = IntRef.create((int)MODULE$.initialGap((ListBuffer<TableDisplay.DRow>)rows, rowIdx));
                    ((List)row.cells().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            TableStructure.Cell cell = (TableStructure.Cell)tuple2._1();
                            int colIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                            MODULE$.addCell((ListBuffer<TableDisplay.DRow>)rows, xOffset$1.elem + colIdx, rowIdx, cell);
                            xOffset$1.elem += cell.colSpan() - 1;
                            return;
                        }
                        throw new MatchError((Object)tuple2);
                    });
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
        }
        catch (Exception ex) {
            Predef$.MODULE$.println((Object)("Error while adding cells: " + ex));
        }
        int totalColumns = BoxesRunTime.unboxToInt((Object)rows.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(x$1, x$2) -> TableDisplay$.$anonfun$1(BoxesRunTime.unboxToInt((Object)x$1), (TableDisplay.DRow)x$2)));
        if (rows.exists((Function1 & Serializable)_$1 -> _$1.cells().size() != totalColumns)) {
            Predef$.MODULE$.println((Object)"Irregular table");
            ListBuffer rows2 = (ListBuffer)rows.map((Function1 & Serializable)row -> {
                if (row.cells().size() < totalColumns) {
                    return MODULE$.pad((TableDisplay.DRow)row, totalColumns);
                }
                return row;
            });
            rows.clear();
            rows.$plus$plus$eq((IterableOnce)rows2);
        }
        IndexedSeq colWidths = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), totalColumns).map((Function1)(JFunction1.mcFI.sp & Serializable)colIdx -> {
            ListBuffer widths = (ListBuffer)rows.map((Function1 & Serializable)row -> {
                float f;
                block3: {
                    try {
                        TableDisplay.DTopLeft c;
                        TableDisplay.DCell dCell = (TableDisplay.DCell)row.cells().apply(colIdx);
                        if (dCell instanceof TableDisplay.DTopLeft && (c = (TableDisplay.DTopLeft)dCell).cell().colSpan() == 1) {
                            f = (float)2 * MODULE$.HPadding().pts() + metrics.width(c.cell().text()).pts();
                            break block3;
                        }
                        f = 0.0f;
                    }
                    catch (Exception ex) {
                        Predef$.MODULE$.println((Object)("Error building widths: " + ex));
                        f = 0.0f;
                    }
                }
                return f;
            });
            return BoxesRunTime.unboxToFloat((Object)widths.foldLeft((Object)BoxesRunTime.boxToFloat((float)0.0f), (Function2 & Serializable)(x$1, x$2) -> TableDisplay$.$anonfun$3$$anonfun$1(BoxesRunTime.unboxToFloat((Object)x$1), BoxesRunTime.unboxToFloat((Object)x$2))));
        });
        float rowHeight = metrics.lineHeight().pts() + (float)2 * this.VPadding().pts();
        List colOffsets = ((List)colWidths.foldLeft((Object)new .colon.colon((Object)BoxesRunTime.boxToFloat((float)0.0f), (List)Nil$.MODULE$), (Function2 & Serializable)(x$1, x$2) -> TableDisplay$.$anonfun$5((List)x$1, BoxesRunTime.unboxToFloat((Object)x$2)))).reverse();
        Pdf.Dim totalWidth = Pdf$Dim$.MODULE$.pts(BoxesRunTime.unboxToFloat((Object)colWidths.sum((Numeric)Numeric.FloatIsFractional$.MODULE$)) + 1.0f);
        Pdf.Dim totalHeight = Pdf$Dim$.MODULE$.pts(rowHeight * (float)rows.size());
        presenter.setSize(totalWidth, totalHeight);
        ((IterableOnceOps)rows.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$12 -> {
            Tuple2 tuple2 = x$12;
            if (tuple2 != null) {
                TableDisplay.DRow row = (TableDisplay.DRow)tuple2._1();
                int rowIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                ((List)row.cells().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        TableDisplay.DCell cell = (TableDisplay.DCell)tuple2._1();
                        int colIdx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        TableDisplay.DCell dCell = cell;
                        if (dCell instanceof TableDisplay.DTopLeft) {
                            TableDisplay.DTopLeft c = (TableDisplay.DTopLeft)dCell;
                            try {
                                Pdf.Dim x = Pdf$Dim$.MODULE$.pts(BoxesRunTime.unboxToFloat((Object)colOffsets.apply(colIdx)));
                                Pdf.Dim y = Pdf$Dim$.MODULE$.pts(rowHeight * (float)rowIdx);
                                Pdf.Dim width = Pdf$Dim$.MODULE$.pts(BoxesRunTime.unboxToFloat((Object)((IterableOnceOps)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(colIdx), colIdx + c.cell().colSpan()).flatMap(colWidths.lift())).sum((Numeric)Numeric.FloatIsFractional$.MODULE$)));
                                Pdf.Dim height = Pdf$Dim$.MODULE$.pts(rowHeight * (float)c.cell().rowSpan());
                                if (MODULE$.isFilled(c.cell())) {
                                    presenter.fillBox(x, y, width, height);
                                } else {
                                    presenter.box(x, y, width, height);
                                }
                                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(c.cell().text()))) {
                                    Pdf.Dim xx = MODULE$.isRightAligned(c.cell()) ? x.$plus(width).$minus(metrics.width(c.cell().text())).$minus(MODULE$.HPadding()) : (MODULE$.isCenterAligned(c.cell()) ? x.$plus(Pdf$Dim$.MODULE$.pts((width.pts() - metrics.width(c.cell().text()).pts()) / (float)2)) : x.$plus(MODULE$.HPadding()));
                                    presenter.set(xx, y.$plus(metrics.lineHeight()), c.cell().text());
                                }
                            }
                            catch (Exception ex) {
                                Predef$.MODULE$.println((Object)("Error " + ex + " in rowIdx " + rowIdx + " colIdx " + colIdx));
                            }
                            return;
                        }
                        return;
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public int initialGap(ListBuffer<TableDisplay.DRow> rows, int rowIdx) {
        Option option = (Option)rows.lift().apply((Object)BoxesRunTime.boxToInteger((int)rowIdx));
        if (option instanceof Some) {
            TableDisplay.DRow row = (TableDisplay.DRow)((Some)option).value();
            int idx = ((SeqOps)row.cells().zipWithIndex()).indexWhere((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    TableDisplay.DCell cell = (TableDisplay.DCell)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return cell.x() != idx;
                }
                throw new MatchError((Object)tuple2);
            });
            if (idx < 0) {
                return row.cells().size();
            }
            return idx;
        }
        if (None$.MODULE$.equals(option)) {
            return 0;
        }
        throw new MatchError((Object)option);
    }

    public boolean isFilled(TableStructure.Cell cell) {
        return cell.classes().contains((Object)"elx-cube-ch") || cell.classes().contains((Object)"elx-cube-rh");
    }

    public boolean isRightAligned(TableStructure.Cell cell) {
        return cell.classes().contains((Object)"cell-right");
    }

    public boolean isCenterAligned(TableStructure.Cell cell) {
        return this.isFilled(cell);
    }

    public void addCell(ListBuffer<TableDisplay.DRow> rows, int x2, int y, TableStructure.Cell cell) {
        LazyRef lazyRef = new LazyRef();
        while (rows.length() < y + cell.rowSpan()) {
            rows.$plus$eq((Object)TableDisplay$DRow$.MODULE$.apply((List<TableDisplay.DCell>)package$.MODULE$.Nil()));
        }
        TableDisplay.DTopLeft tl = TableDisplay$DTopLeft$.MODULE$.apply(x2, y, cell);
        List spacers = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(x2 + 1), x2 + cell.colSpan()).map((Function1 & Serializable)x -> TableDisplay$DHidden$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)x), tl)).toList();
        rows.update(y, (Object)this.insertCells((TableDisplay.DRow)rows.apply(y), (List<TableDisplay.DCell>)spacers.$colon$colon((Object)tl)));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), cell.rowSpan()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> rows.update(y + i, (Object)this.insertCells((TableDisplay.DRow)rows.apply(y + i), (List<TableDisplay.DCell>)this.spacers2$1(lazyRef, x2, cell, tl))));
    }

    public TableDisplay.DRow insertCells(TableDisplay.DRow row, List<TableDisplay.DCell> cells) {
        TableDisplay.DRow ret = TableDisplay$DRow$.MODULE$.apply((List<TableDisplay.DCell>)((List)cells.$colon$colon$colon(row.cells()).sortBy((Function1 & Serializable)_$2 -> _$2.x(), (Ordering)Ordering.Int$.MODULE$)));
        return ret;
    }

    public TableDisplay.DRow pad(TableDisplay.DRow row, int cols) {
        int diff = cols - row.cells().size();
        return TableDisplay$DRow$.MODULE$.apply((List<TableDisplay.DCell>)((List)row.cells().$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(diff, TableDisplay$::pad$$anonfun$1, ClassTag$.MODULE$.apply(TableDisplay.DCell.class))))));
    }

    private static final /* synthetic */ int $anonfun$1(int x$1, TableDisplay.DRow x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)x$1), (Object)x$2);
        if (tuple2 != null) {
            int total = BoxesRunTime.unboxToInt((Object)tuple2._1());
            TableDisplay.DRow row = (TableDisplay.DRow)tuple2._2();
            return scala.math.package$.MODULE$.max(total, row.cells().size());
        }
        throw new MatchError((Object)tuple2);
    }

    private static final /* synthetic */ float $anonfun$3$$anonfun$1(float x$1, float x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToFloat((float)x$1), (Object)BoxesRunTime.boxToFloat((float)x$2));
        if (tuple2 != null) {
            float biggest = BoxesRunTime.unboxToFloat((Object)tuple2._1());
            float width = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            return scala.math.package$.MODULE$.max(biggest, width);
        }
        throw new MatchError((Object)tuple2);
    }

    private static final float $anonfun$6() {
        return 0.0f;
    }

    private static final /* synthetic */ List $anonfun$5(List x$1, float x$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToFloat((float)x$2));
        if (tuple2 != null) {
            List list = (List)tuple2._1();
            float w = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            float f = BoxesRunTime.unboxToFloat((Object)list.headOption().getOrElse(TableDisplay$::$anonfun$6)) + w;
            return list.$colon$colon((Object)BoxesRunTime.boxToFloat((float)f));
        }
        throw new MatchError((Object)tuple2);
    }

    private final List spacers2$lzyINIT1$1(LazyRef spacers2$lzy1$1, int x$1, TableStructure.Cell cell$1, TableDisplay.DTopLeft tl$2) {
        List list;
        LazyRef lazyRef = spacers2$lzy1$1;
        synchronized (lazyRef) {
            list = (List)(spacers2$lzy1$1.initialized() ? spacers2$lzy1$1.value() : spacers2$lzy1$1.initialize((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(x$1), x$1 + cell$1.colSpan()).map((Function1 & Serializable)x -> TableDisplay$DHidden$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)x), tl$2)).toList()));
        }
        return list;
    }

    private final List spacers2$1(LazyRef spacers2$lzy1$2, int x$2, TableStructure.Cell cell$2, TableDisplay.DTopLeft tl$4) {
        return (List)(spacers2$lzy1$2.initialized() ? spacers2$lzy1$2.value() : this.spacers2$lzyINIT1$1(spacers2$lzy1$2, x$2, cell$2, tl$4));
    }

    private static final TableDisplay.DCell pad$$anonfun$1() {
        return TableDisplay$Irregular$.MODULE$;
    }
}

