/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.pivot;

import ambience.dashboard.view.pivot.AggExt$;
import com.elixirtech.coredata.Data;
import com.elixirtech.pivot.Operation$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.Map;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public final class Operation {
    public static Type newInstance(String string) {
        return Operation$.MODULE$.newInstance(string);
    }

    public static class AverageBuilder
    implements Builder {
        private final CountBuilder count;
        private final SumBuilder sum;

        public AverageBuilder(Data.Field f) {
            this.count = new CountBuilder(f);
            this.sum = new SumBuilder(f);
        }

        @Override
        public void add(Map<String, Json> rec) {
            this.count.add(rec);
            this.sum.add(rec);
        }

        @Override
        public Json result() {
            if (this.count.resultInt() == 0) {
                return Json$.MODULE$.Null();
            }
            return (Json)Json$.MODULE$.fromDouble(this.sum.resultDouble() / (double)this.count.resultInt()).getOrElse(this::result$$anonfun$2);
        }

        private final Json result$$anonfun$2() {
            throw new RuntimeException("Double: " + this.sum.resultDouble() + "/" + this.count.resultInt() + " can't be represented as a Double");
        }
    }

    public static interface Builder {
        public void add(Map<String, Json> var1);

        public Json result();
    }

    public static class CountBuilder
    implements Builder {
        private final String fieldName;
        private int value;

        public CountBuilder(Data.Field f) {
            this.fieldName = AggExt$.MODULE$.stripUpToDot(f.name()) + "_count";
            this.value = 0;
        }

        @Override
        public void add(Map<String, Json> rec) {
            rec.get((Object)this.fieldName).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.asNumber().foreach((Function1)(JProcedure1 & Serializable)n -> this.value += BoxesRunTime.unboxToInt((Object)n.toInt().getOrElse(Operation$::com$elixirtech$pivot$Operation$CountBuilder$$_$add$$anonfun$3$$anonfun$1$$anonfun$1))));
        }

        @Override
        public Json result() {
            return Json$.MODULE$.fromInt(this.value);
        }

        public int resultInt() {
            return this.value;
        }
    }

    public static class MaxBuilder
    implements Builder {
        private final String fieldName;
        private double max;

        public MaxBuilder(Data.Field f) {
            this.fieldName = AggExt$.MODULE$.stripUpToDot(f.name()) + "_max";
            this.max = Double.NaN;
        }

        @Override
        public void add(Map<String, Json> rec) {
            rec.get((Object)this.fieldName).flatMap(Operation$::com$elixirtech$pivot$Operation$MaxBuilder$$_$add$$anonfun$6).foreach((Function1)(JFunction1.mcVD.sp & Serializable)n -> {
                if (Predef$.MODULE$.double2Double(this.max).isNaN()) {
                    this.max = n;
                    return;
                }
                this.max = package$.MODULE$.max(this.max, n);
            });
        }

        @Override
        public Json result() {
            if (Predef$.MODULE$.double2Double(this.max).isNaN()) {
                return Json$.MODULE$.Null();
            }
            return (Json)Json$.MODULE$.fromDouble(this.max).getOrElse(this::result$$anonfun$4);
        }

        private final Json result$$anonfun$4() {
            throw new RuntimeException("Max: " + this.max + " can't be represented as a Double");
        }
    }

    public static class MinBuilder
    implements Builder {
        private final String fieldName;
        private double min;

        public MinBuilder(Data.Field f) {
            this.fieldName = AggExt$.MODULE$.stripUpToDot(f.name()) + "_min";
            this.min = Double.NaN;
        }

        @Override
        public void add(Map<String, Json> rec) {
            rec.get((Object)this.fieldName).flatMap(Operation$::com$elixirtech$pivot$Operation$MinBuilder$$_$add$$anonfun$4).foreach((Function1)(JFunction1.mcVD.sp & Serializable)n -> {
                if (Predef$.MODULE$.double2Double(this.min).isNaN()) {
                    this.min = n;
                    return;
                }
                this.min = package$.MODULE$.min(this.min, n);
            });
        }

        @Override
        public Json result() {
            if (Predef$.MODULE$.double2Double(this.min).isNaN()) {
                return Json$.MODULE$.Null();
            }
            return (Json)Json$.MODULE$.fromDouble(this.min).getOrElse(this::result$$anonfun$3);
        }

        private final Json result$$anonfun$3() {
            throw new RuntimeException("Min: " + this.min + " can't be represented as a Double");
        }
    }

    public static class Overall
    implements Type {
        private final Type inner;

        public Overall(Type inner) {
            this.inner = inner;
        }

        @Override
        public String opName() {
            return this.inner.opName();
        }

        @Override
        public String name(Data.Field field) {
            return this.inner.name(field);
        }

        @Override
        public Builder builder(Data.Field f) {
            return this.inner.builder(f);
        }

        @Override
        public boolean isOverall() {
            return true;
        }
    }

    public static class SumBuilder
    implements Builder {
        private final String fieldName;
        private double value;

        public SumBuilder(Data.Field f) {
            this.fieldName = AggExt$.MODULE$.stripUpToDot(f.name()) + "_sum";
            this.value = 0.0;
        }

        @Override
        public void add(Map<String, Json> rec) {
            rec.get((Object)this.fieldName).flatMap(Operation$::com$elixirtech$pivot$Operation$SumBuilder$$_$add$$anonfun$1).foreach((Function1)(JFunction1.mcVD.sp & Serializable)n -> this.value += n);
        }

        @Override
        public Json result() {
            return (Json)Json$.MODULE$.fromDouble(this.value).getOrElse(this::result$$anonfun$1);
        }

        public double resultDouble() {
            return this.value;
        }

        private final Json result$$anonfun$1() {
            throw new RuntimeException("Sum: " + this.value + " can't be represented as a Double");
        }
    }

    public static interface Type {
        public String opName();

        public String name(Data.Field var1);

        public Builder builder(Data.Field var1);

        public static boolean isOverall$(Type $this) {
            return $this.isOverall();
        }

        default public boolean isOverall() {
            return false;
        }
    }
}

