/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.sftp;

import ambience.arch.Arch$;
import ambience.etl.Builder;
import ambience.etl.ETLStepCategory;
import ambience.etl.sftp.FingerprintVerifier$;
import ambience.etl.sftp.SFTPAuthProvider;
import ambience.etl.sftp.SFTPAuthProvider$;
import ambience.etl.sftp.SFTPCategory$;
import ambience.etl.sftp.SFTPCategory$Conn$;
import ambience.panel.Panel;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingInterface;
import java.io.File;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SFTPCategory {
    public static List<Builder> all() {
        return SFTPCategory$.MODULE$.all();
    }

    public static ETLStepCategory definition() {
        return SFTPCategory$.MODULE$.definition();
    }

    public static LoggingInterface log() {
        return SFTPCategory$.MODULE$.log();
    }

    public static void register() {
        SFTPCategory$.MODULE$.register();
    }

    public static List<Panel.SelectChoice> userChoices() {
        return SFTPCategory$.MODULE$.userChoices();
    }

    public static final class Conn
    implements Product,
    Serializable {
        private final SSHClient sshClient;
        private final SFTPClient sftpClient;

        public static Conn apply(SSHClient sSHClient, SFTPClient sFTPClient) {
            return SFTPCategory$Conn$.MODULE$.apply(sSHClient, sFTPClient);
        }

        public static Conn fromProduct(Product product) {
            return SFTPCategory$Conn$.MODULE$.fromProduct(product);
        }

        public static Conn unapply(Conn conn) {
            return SFTPCategory$Conn$.MODULE$.unapply(conn);
        }

        public Conn(SSHClient sshClient, SFTPClient sftpClient) {
            this.sshClient = sshClient;
            this.sftpClient = sftpClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Conn)) return false;
            Conn conn = (Conn)object;
            SSHClient sSHClient = this.sshClient();
            SSHClient sSHClient2 = conn.sshClient();
            if (sSHClient == null) {
                if (sSHClient2 != null) {
                    return false;
                }
            } else if (!sSHClient.equals(sSHClient2)) return false;
            SFTPClient sFTPClient = this.sftpClient();
            SFTPClient sFTPClient2 = conn.sftpClient();
            if (sFTPClient == null) {
                if (sFTPClient2 == null) return true;
                return false;
            } else {
                if (!sFTPClient.equals(sFTPClient2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Conn;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Conn";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "sshClient";
            }
            if (1 == n2) {
                return "sftpClient";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public SSHClient sshClient() {
            return this.sshClient;
        }

        public SFTPClient sftpClient() {
            return this.sftpClient;
        }

        public Conn copy(SSHClient sshClient, SFTPClient sftpClient) {
            return new Conn(sshClient, sftpClient);
        }

        public SSHClient copy$default$1() {
            return this.sshClient();
        }

        public SFTPClient copy$default$2() {
            return this.sftpClient();
        }

        public SSHClient _1() {
            return this.sshClient();
        }

        public SFTPClient _2() {
            return this.sftpClient();
        }
    }

    public static class Connection {
        private final Builder.Context cxt;
        private final CoreInfo info;

        public Connection(Builder.Context cxt, CoreInfo info) {
            this.cxt = cxt;
            this.info = info;
        }

        public Task<SSHClient> build() {
            SSHClient sshClient = new SSHClient();
            sshClient.addHostKeyVerifier((HostKeyVerifier)FingerprintVerifier$.MODULE$);
            sshClient.connect(this.info.host(), this.info.port());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.info.user()))) {
                Option option = SFTPAuthProvider$.MODULE$.Entries().get((Object)this.info.user());
                if (option instanceof Some) {
                    SFTPAuthProvider.Entry auth = (SFTPAuthProvider.Entry)((Some)option).value();
                    return this.cxt.logT(this.logMessage(auth)).map(arg_0 -> SFTPCategory$.ambience$etl$sftp$SFTPCategory$Connection$$_$build$$anonfun$1(auth, sshClient, arg_0));
                }
                if (None$.MODULE$.equals(option)) {
                    return this.cxt.logT((LogMessage)LogMessage.Warn$.MODULE$.apply("No key provider found for user: " + this.info.user())).as((Object)sshClient);
                }
                throw new MatchError((Object)option);
            }
            return Task$.MODULE$.now((Object)sshClient);
        }

        public LogMessage logMessage(SFTPAuthProvider.Entry auth) {
            Option option = Arch$.MODULE$.opts(auth.password());
            if (option instanceof Some) {
                return LogMessage.Debug$.MODULE$.apply("Using key provider: " + auth.name() + " with password");
            }
            if (None$.MODULE$.equals(option)) {
                return LogMessage.Debug$.MODULE$.apply("Using key provider: " + auth.name() + " with keys " + auth.keys() + " (" + new File(auth.keys()).exists() + ")");
            }
            throw new MatchError((Object)option);
        }

        public Task<Conn> open() {
            return this.build().flatMap((Function1 & Serializable)sshClient -> this.cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Connecting to " + this.info.host() + ":" + this.info.port())).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(() -> SFTPCategory$.ambience$etl$sftp$SFTPCategory$Connection$$_$open$$anonfun$1$$anonfun$1$$anonfun$1(sshClient)).flatMap((Function1 & Serializable)sftpClient -> this.cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Opening SFTP " + this.info.host() + ":" + this.info.port())).flatMap(arg_0 -> SFTPCategory$.ambience$etl$sftp$SFTPCategory$Connection$$_$open$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(sshClient, sftpClient, arg_0)));
            }));
        }

        public Task<BoxedUnit> close(Conn conn) {
            return Task$.MODULE$.apply(SFTPCategory$::ambience$etl$sftp$SFTPCategory$Connection$$_$close$$anonfun$adapted$1).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Closing SFTP")).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply(() -> SFTPCategory$.ambience$etl$sftp$SFTPCategory$Connection$$_$close$$anonfun$2$$anonfun$1$$anonfun$adapted$1(conn)).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return this.cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Disconnecting " + this.info.host() + ":" + this.info.port())).flatMap(arg_0 -> SFTPCategory$.ambience$etl$sftp$SFTPCategory$Connection$$_$close$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(conn, arg_0));
                    });
                });
            });
        }
    }

    public static interface CoreInfo {
        public String host();

        public int port();

        public String user();
    }
}

