/*
 * Decompiled with CFR 0.152.
 */
package ambience.docxengine;

import ambience.api.DocXEngine;
import ambience.api.Lifecycle;
import ambience.api.ReportEngine;
import ambience.api.Repository;
import ambience.arch.Arch$;
import ambience.docxengine.ActivityLogger$;
import ambience.docxengine.DocXEngineModule$;
import ambience.docxengine.DocXResourceLoader;
import ambience.docxengine.TimeoutLogic$;
import ambience.module.CurrentUser$;
import ambience.module.UserDB;
import ambience.queue.JobQueueStorage$;
import com.elixirtech.api.SchedulerAPI;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.IJobLogging;
import com.elixirtech.arch.job.JobByteCount$;
import com.elixirtech.arch.job.JobDescription$;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobException$;
import com.elixirtech.arch.job.JobLog;
import com.elixirtech.arch.job.JobLogStorage$;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.job.JobTimeout$;
import com.elixirtech.arch.job.NestedJobLogging;
import com.elixirtech.arch.util.ThrowableInfo$;
import com.elixirtech.coredata.JsonToString$;
import com.elixirtech.opc.docprocessor.DocRenderContext;
import com.elixirtech.opc.docprocessor.Processor;
import com.elixirtech.opc.docprocessor.ResourceLoader;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.TimeoutException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DocXEngineAPI
implements DocXEngine,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(DocXEngineAPI.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DocXEngineAPI.class.getDeclaredField("repository$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object repository$lzy1;

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Repository repository() {
        Object object = this.repository$lzy1;
        if (object instanceof Repository) {
            return (Repository)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Repository)this.repository$lzyINIT1();
    }

    private Object repository$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repository$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Repository repository = null;
                    try {
                        repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
                        object2 = repository == null ? LazyVals.NullValue$.MODULE$ : repository;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repository$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return repository;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Observable<ReportEngine.TemplatePath> getAvailableReports(UserDB.User user) {
        return this.repository().getByExtensionO(user, "docx").map((Function1 & Serializable)path -> new ReportEngine.TemplatePath(ReportEngine.TemplatePath$.MODULE$.apply(path.toString())));
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> renderReport(UserDB.User user, ReportEngine.Template docx, MimeType mimeType, Json params) {
        ReportEngine.Request request = ReportEngine.Request$.MODULE$.apply(ReportEngine.TemplatePath$.MODULE$.apply("report"), mimeType, params, Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        Task task = ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(this.doRenderReport(user, docx, request));
        return task.executeOn((Scheduler)DocXEngineModule$.MODULE$.io(), task.executeOn$default$2());
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> renderReport(UserDB.User user, ReportEngine.Request request) {
        Repository repository = (Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class));
        Task task = ((Lifecycle)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Lifecycle.class))).runJob(repository.readFileT(user, Path$.MODULE$.apply(request.path())).flatMap((Function1 & Serializable)docxBytes -> this.doRenderReport(user, ReportEngine.Template$.MODULE$.apply((DataBytes)FullDataBytes$.MODULE$.apply(docxBytes)), request).map((Function1 & Serializable)result -> result)));
        return task.executeOn((Scheduler)DocXEngineModule$.MODULE$.io(), task.executeOn$default$2());
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> buildResult(Document doc) {
        return JobQueueStorage$.MODULE$.bsonToReport(doc);
    }

    public Task<Either<ReportEngine.Error, ReportEngine.Report>> doRenderReport(UserDB.User user, ReportEngine.Template docx, ReportEngine.Request request) {
        this.log().info(() -> DocXEngineAPI.doRenderReport$$anonfun$1(request, user), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.doRenderReport"));
        return (Task)CurrentUser$.MODULE$.withUser(user, () -> this.doRenderReport$$anonfun$2(request, docx, user));
    }

    public Document failedWithException(Exception ex) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"entries");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonValue[]{BsonMagnets$.MODULE$.singleToCanBeBsonValue((Object)this.failedEntry(ex), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument())}))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Document failedWithMessage(String msg) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"entries");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonArray$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonMagnets.CanBeBsonValue[]{BsonMagnets$.MODULE$.singleToCanBeBsonValue((Object)this.failedEntry(msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument())}))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Document failedEntry(Exception ex) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"entry");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"JobException"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"timestamp");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformLong());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"extra");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"DocXEngineAPI.E1"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"exception");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)String.valueOf(ex)), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Document failedEntry(String msg) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"entry");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"JobError"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"timestamp");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformLong());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"extra");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"DocXEngineAPI.E2"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"message");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)msg), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        return Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public byte[] combine(List<byte[]> chunks) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])chunks.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
        return (byte[])ArrayOps$.MODULE$.flatten$extension(object, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public Either<ReportEngine.Error, ReportEngine.Report> buildReply(UserDB.User user, ReportEngine.Request request, ByteArrayOutputStream baos, JobLog jobLog) {
        Path path = Path$.MODULE$.apply(request.path());
        SchedulerAPI.TriggerStatus triggerStatus = jobLog.statusCode();
        SchedulerAPI.TriggerStatus triggerStatus2 = SchedulerAPI.TriggerStatus$.MODULE$.Completed();
        if (!(triggerStatus != null ? !triggerStatus.equals(triggerStatus2) : triggerStatus2 != null)) {
            byte[] bytes = baos.toByteArray();
            Document jobLogDoc = JobLogStorage$.MODULE$.save((IJobLog)jobLog);
            String filename = this.getResultFilename(request);
            return package$.MODULE$.Right().apply((Object)ReportEngine.Report$.MODULE$.apply(ReportEngine.ReportMetadata$.MODULE$.apply(filename, Int$.MODULE$.int2long(bytes.length), request.mimeType(), jobLogDoc), (SyncDataBytes)FullDataBytes$.MODULE$.apply(bytes)));
        }
        SchedulerAPI.TriggerStatus triggerStatus3 = jobLog.statusCode();
        SchedulerAPI.TriggerStatus triggerStatus4 = SchedulerAPI.TriggerStatus$.MODULE$.StartedButNotFinished();
        if (!(triggerStatus3 != null ? !triggerStatus3.equals(triggerStatus4) : triggerStatus4 != null)) {
            Document jobLogDoc = JobLogStorage$.MODULE$.save((IJobLog)jobLog);
            ActivityLogger$.MODULE$.log(user, "render-docx", path, jobLogDoc).runAsyncAndForget(DocXEngineModule$.MODULE$.shortIO());
            return package$.MODULE$.Left().apply((Object)ReportEngine.Error$.MODULE$.apply("JobTimeout", jobLogDoc));
        }
        Document jobLogDoc = JobLogStorage$.MODULE$.save((IJobLog)jobLog);
        ActivityLogger$.MODULE$.log(user, "render-docx", path, jobLogDoc).runAsyncAndForget(DocXEngineModule$.MODULE$.shortIO());
        return package$.MODULE$.Left().apply((Object)ReportEngine.Error$.MODULE$.apply(jobLog.statusCode().value() + " " + jobLog.statusCode().name(), this.failedWithMessage("jobLog has " + jobLog.entries() + " items")));
    }

    public String getResultFilename(ReportEngine.Request request) {
        String filename = (String)request.params().hcursor().downField("elx-filename").as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)s -> Arch$.MODULE$.opts(s)).getOrElse(() -> DocXEngineAPI.$anonfun$6(request));
        return Path$.MODULE$.apply(filename).withExtension(MimeInfo$.MODULE$.extension(request.mimeType())).name();
    }

    public Task<Processor> buildProcessor(UserDB.User user, byte[] bytes) {
        return Task$.MODULE$.apply(() -> DocXEngineAPI.buildProcessor$$anonfun$1(user, bytes));
    }

    public Task<JobLog> renderDocX(UserDB.User user, Processor p, ByteArrayOutputStream outputStream, MimeType mimeType, scala.collection.immutable.Map<String, String> props, String path) {
        NestedJobLogging logger = new NestedJobLogging(JobLogging$.MODULE$.getInstance(), "elx.DocXEngineAPI");
        return TimeoutLogic$.MODULE$.runWithTimeout(p, props, path, () -> this.renderDocX$$anonfun$1(user, logger, path, p, props, mimeType, outputStream)).onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof TimeoutException) {
                TimeoutException ex = (TimeoutException)throwable;
                this.log().error(() -> DocXEngineAPI.renderDocX$$anonfun$2$$anonfun$1(path, ex), Line$.MODULE$.apply(173), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.renderDocX"));
                logger.error("elx.DocXEngineAPI", () -> DocXEngineAPI.renderDocX$$anonfun$2$$anonfun$2(ex));
                logger.add((JobEntry)JobTimeout$.MODULE$.apply(JobTimeout$.MODULE$.$lessinit$greater$default$1()));
                return logger.getJobLog();
            }
            if (throwable != null) {
                Throwable ex = throwable;
                this.log().error(() -> DocXEngineAPI.renderDocX$$anonfun$2$$anonfun$3(path, ex), ex, Line$.MODULE$.apply(178), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.renderDocX"));
                logger.add((JobEntry)JobException$.MODULE$.apply(ThrowableInfo$.MODULE$.apply(ex), JobException$.MODULE$.$lessinit$greater$default$2()));
                return logger.getJobLog();
            }
            throw new MatchError((Object)throwable);
        });
    }

    private static final Object doRenderReport$$anonfun$1(ReportEngine.Request request$2, UserDB.User user$2) {
        return "Rendering docx report " + request$2.path() + " for " + user$2.name();
    }

    private static final scala.collection.immutable.Map $anonfun$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private final byte[] $anonfun$4$$anonfun$1(List chunks$1) {
        return this.combine((List<byte[]>)chunks$1);
    }

    private final Either $anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$8, ReportEngine.Request request$8, ByteArrayOutputStream baos$5, JobLog jobLog$1) {
        return this.buildReply(user$8, request$8, baos$5, jobLog$1);
    }

    private final Task doRenderReport$$anonfun$2(ReportEngine.Request request$3, ReportEngine.Template docx$1, UserDB.User user$3) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        scala.collection.immutable.Map paramsMap = (scala.collection.immutable.Map)request$3.params().asObject().map((Function1 & Serializable)obj -> obj.toList().flatMap((Function1 & Serializable)kv -> JsonToString$.MODULE$.apply((Json)kv._2()).map((Function1 & Serializable)_$1 -> {
            String string = (String)Predef$.MODULE$.ArrowAssoc(kv._1());
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, _$1);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).getOrElse(DocXEngineAPI::$anonfun$3);
        Task tReply = docx$1.bytes().observable().toListL().flatMap((Function1 & Serializable)chunks -> Task$.MODULE$.apply(() -> this.$anonfun$4$$anonfun$1(chunks)).flatMap((Function1 & Serializable)all -> this.buildProcessor(user$3, (byte[])all).flatMap((Function1 & Serializable)processor -> this.renderDocX(user$3, (Processor)processor, baos, request$3.mimeType(), (scala.collection.immutable.Map<String, String>)paramsMap, request$3.path()).flatMap((Function1 & Serializable)jobLog -> Task$.MODULE$.apply(() -> this.$anonfun$4$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(user$3, request$3, baos, jobLog)).map((Function1 & Serializable)reply -> reply)))));
        return tReply.onErrorRecover((PartialFunction)new Serializable(request$3, this){
            private final ReportEngine.Request request$9;
            private final /* synthetic */ DocXEngineAPI $outer;
            {
                this.request$9 = request$11;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    this.$outer.log().error(() -> this.applyOrElse$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(71), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.doRenderReport"));
                    return package$.MODULE$.Left().apply((Object)ReportEngine.Error$.MODULE$.apply("Error rendering docx report", this.$outer.failedWithException(ex)));
                }
                return function1.apply((Object)x);
            }

            private final Object applyOrElse$$anonfun$1(Exception ex$1) {
                return "Error rendering docx report " + this.request$9.path() + ": " + ex$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Exception )}, serializedLambda);
            }
        });
    }

    private static final String $anonfun$6(ReportEngine.Request request$10) {
        return request$10.path();
    }

    private static final Processor buildProcessor$$anonfun$1$$anonfun$1(UserDB.User user$10, byte[] bytes$2) {
        DocXResourceLoader loader = new DocXResourceLoader(user$10);
        return new Processor(bytes$2, (ResourceLoader)loader);
    }

    private static final Processor buildProcessor$$anonfun$1(UserDB.User user$9, byte[] bytes$1) {
        return (Processor)CurrentUser$.MODULE$.withUser(user$9, () -> DocXEngineAPI.buildProcessor$$anonfun$1$$anonfun$1(user$9, bytes$1));
    }

    private static final Object renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String path$5, Throwable ex$2) {
        return "Error from docx render logic " + path$5 + ": " + ex$2;
    }

    private final void renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(NestedJobLogging logger$4, String path$4, Processor p$4, scala.collection.immutable.Map props$4, MimeType mimeType$4, ByteArrayOutputStream outputStream$4) {
        try {
            logger$4.add((JobEntry)JobDescription$.MODULE$.apply("report=" + path$4, JobDescription$.MODULE$.$lessinit$greater$default$2()));
            DocRenderContext cxt = new DocRenderContext();
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
            p$4.render(cxt, CollectionConverters$.MODULE$.MapHasAsJava((Map)props$4.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)mimeType$4.value()))).asJava(), (OutputStream)outputStream$4);
            logger$4.add((JobEntry)JobByteCount$.MODULE$.apply(Int$.MODULE$.int2long(outputStream$4.size()), JobByteCount$.MODULE$.$lessinit$greater$default$2()));
            cxt.dispose();
        }
        catch (Throwable ex) {
            this.log().error(() -> DocXEngineAPI.renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(path$4, ex), ex, Line$.MODULE$.apply(162), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.renderDocX"));
            logger$4.add((JobEntry)JobException$.MODULE$.apply(ThrowableInfo$.MODULE$.apply(ex), JobException$.MODULE$.$lessinit$greater$default$2()));
        }
    }

    private static final Object renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(NestedJobLogging logger$5) {
        return "Finishing with " + logger$5.getJobLog().entries().length() + " entries";
    }

    private final JobLog renderDocX$$anonfun$1$$anonfun$1$$anonfun$1(NestedJobLogging logger$3, String path$3, Processor p$3, scala.collection.immutable.Map props$3, MimeType mimeType$3, ByteArrayOutputStream outputStream$3) {
        JobLogging$.MODULE$.run((IJobLogging)logger$3, (Function0 & Serializable)() -> {
            this.renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(logger$3, path$3, p$3, props$3, mimeType$3, outputStream$3);
            return BoxedUnit.UNIT;
        });
        this.log().info(() -> DocXEngineAPI.renderDocX$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2(logger$3), Line$.MODULE$.apply(166), FullName$.MODULE$.apply("ambience.docxengine.DocXEngineAPI.renderDocX"));
        return logger$3.getJobLog();
    }

    private final JobLog renderDocX$$anonfun$1$$anonfun$1(UserDB.User user$12, NestedJobLogging logger$2, String path$2, Processor p$2, scala.collection.immutable.Map props$2, MimeType mimeType$2, ByteArrayOutputStream outputStream$2) {
        return (JobLog)CurrentUser$.MODULE$.withUser(user$12, () -> this.renderDocX$$anonfun$1$$anonfun$1$$anonfun$1(logger$2, path$2, p$2, props$2, mimeType$2, outputStream$2));
    }

    private final Task renderDocX$$anonfun$1(UserDB.User user$11, NestedJobLogging logger$1, String path$1, Processor p$1, scala.collection.immutable.Map props$1, MimeType mimeType$1, ByteArrayOutputStream outputStream$1) {
        return Task$.MODULE$.apply(() -> this.renderDocX$$anonfun$1$$anonfun$1(user$11, logger$1, path$1, p$1, props$1, mimeType$1, outputStream$1));
    }

    private static final Object renderDocX$$anonfun$2$$anonfun$1(String path$7, TimeoutException ex$3) {
        return "Error rendering docx report " + path$7 + ": " + ex$3;
    }

    private static final String renderDocX$$anonfun$2$$anonfun$2(TimeoutException ex$4) {
        return "Timeout error rendering report. Monitor " + ex$4.getMessage();
    }

    private static final Object renderDocX$$anonfun$2$$anonfun$3(String path$8, Throwable ex$5) {
        return "Error rendering docx report " + path$8 + ": " + ex$5;
    }
}

