/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.gravity.netty4;

import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.FileDataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingInterfaceT;
import com.elixirtech.arch.NoDataBytes$;
import com.elixirtech.arch.ObservableDataBytes;
import com.elixirtech.arch.ObservableDataBytes$;
import com.elixirtech.gravity.AsyncResponseHelper$;
import com.elixirtech.gravity.ContentType;
import com.elixirtech.gravity.ContentType$;
import com.elixirtech.gravity.Discard4xxResponseBody$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.Gravity$Header$;
import com.elixirtech.gravity.Gravity$Status$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.netty4.BodyBuilder;
import com.elixirtech.gravity.netty4.ByteUtil$;
import com.elixirtech.gravity.netty4.FormBodyBuilder;
import com.elixirtech.gravity.netty4.HttpHandler$;
import com.elixirtech.gravity.netty4.HttpHandler$State$;
import com.elixirtech.gravity.netty4.RawBodyBuilder;
import com.elixirtech.gravity.netty4.Request$;
import com.elixirtech.gravity.netty4.TaskUtil$;
import com.typesafe.config.Config;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.ssl.SslHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLPeerUnverifiedException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;
import sourcecode.FullName$;
import sourcecode.Line$;

public class HttpHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private final Function1<GravityRequest, Task<GravityResponse>> system;
    private Option<State> myState;
    public static final long OFFSET$_m_16 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_15 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("developerDelay$lzy1"));
    public static final long OFFSET$_m_14 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("PeerIPHeader$lzy1"));
    public static final long OFFSET$_m_13 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("LogClosedChannelException$lzy1"));
    public static final long OFFSET$_m_12 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("MaxBufferedBytes$lzy1"));
    public static final long OFFSET$_m_11 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("MaxFormItems$lzy1"));
    public static final long OFFSET$_m_10 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("MaxFileSize$lzy1"));
    public static final long OFFSET$_m_9 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("RequireHostHeaderRegex$lzy1"));
    public static final long OFFSET$_m_8 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("RequireHostHeader$lzy1"));
    public static final long OFFSET$_m_7 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("ClientCertEnabled$lzy1"));
    public static final long OFFSET$_m_6 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("NettyWorkerGroupThreads$lzy1"));
    public static final long OFFSET$_m_5 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("NettyBossGroupThreads$lzy1"));
    public static final long OFFSET$_m_4 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("HttpDebug$lzy1"));
    public static final long OFFSET$_m_3 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("DeveloperDelayDuration$lzy1"));
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("DeveloperDelayMs$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("DeveloperMode$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(HttpHandler$.class.getDeclaredField("elxConfig$lzy1"));

    public static boolean ClientCertEnabled() {
        return HttpHandler$.MODULE$.ClientCertEnabled();
    }

    public static DefaultHttpDataFactory DataFactory() {
        return HttpHandler$.MODULE$.DataFactory();
    }

    public static FiniteDuration DeveloperDelayDuration() {
        return HttpHandler$.MODULE$.DeveloperDelayDuration();
    }

    public static long DeveloperDelayMs() {
        return HttpHandler$.MODULE$.DeveloperDelayMs();
    }

    public static boolean DeveloperMode() {
        return HttpHandler$.MODULE$.DeveloperMode();
    }

    public static boolean HttpDebug() {
        return HttpHandler$.MODULE$.HttpDebug();
    }

    public static boolean LogClosedChannelException() {
        return HttpHandler$.MODULE$.LogClosedChannelException();
    }

    public static int MaxBufferedBytes() {
        return HttpHandler$.MODULE$.MaxBufferedBytes();
    }

    public static long MaxFileSize() {
        return HttpHandler$.MODULE$.MaxFileSize();
    }

    public static int MaxFormItems() {
        return HttpHandler$.MODULE$.MaxFormItems();
    }

    public static int NettyBossGroupThreads() {
        return HttpHandler$.MODULE$.NettyBossGroupThreads();
    }

    public static int NettyWorkerGroupThreads() {
        return HttpHandler$.MODULE$.NettyWorkerGroupThreads();
    }

    public static String PeerIPHeader() {
        return HttpHandler$.MODULE$.PeerIPHeader();
    }

    public static String RequireHostHeader() {
        return HttpHandler$.MODULE$.RequireHostHeader();
    }

    public static Regex RequireHostHeaderRegex() {
        return HttpHandler$.MODULE$.RequireHostHeaderRegex();
    }

    public static Task<BoxedUnit> developerDelay() {
        return HttpHandler$.MODULE$.developerDelay();
    }

    public static Config elxConfig() {
        return HttpHandler$.MODULE$.elxConfig();
    }

    public static LoggingInterfaceT log() {
        return HttpHandler$.MODULE$.log();
    }

    public static Task<BoxedUnit> send100Continue(ChannelHandlerContext channelHandlerContext) {
        return HttpHandler$.MODULE$.send100Continue(channelHandlerContext);
    }

    public static Task<BoxedUnit> send400BadRequest(ChannelHandlerContext channelHandlerContext, LogMessage logMessage) {
        return HttpHandler$.MODULE$.send400BadRequest(channelHandlerContext, logMessage);
    }

    public static Task<BoxedUnit> send4xx(ChannelHandlerContext channelHandlerContext, HttpResponseStatus httpResponseStatus, LogMessage logMessage) {
        return HttpHandler$.MODULE$.send4xx(channelHandlerContext, httpResponseStatus, logMessage);
    }

    public static Task<BoxedUnit> send500InternalServerError(ChannelHandlerContext channelHandlerContext, LogMessage logMessage) {
        return HttpHandler$.MODULE$.send500InternalServerError(channelHandlerContext, logMessage);
    }

    public static Task<BoxedUnit> write(ChannelHandlerContext channelHandlerContext, HttpResponse httpResponse) {
        return HttpHandler$.MODULE$.write(channelHandlerContext, httpResponse);
    }

    public HttpHandler(Function1<GravityRequest, Task<GravityResponse>> system) {
        this.system = system;
        this.myState = None$.MODULE$;
    }

    public void setState(ChannelHandlerContext cxt, Option<State> state) {
        this.myState = state;
    }

    public Option<State> getState(ChannelHandlerContext cxt) {
        return this.myState;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
        super.channelReadComplete(ctx);
    }

    public void channelRead0(ChannelHandlerContext cxt, HttpObject msg) {
        Task<BoxedUnit> task;
        HttpObject httpObject = msg;
        if (httpObject instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpObject;
            task = this.handleRequest(cxt, req);
        } else if (httpObject instanceof HttpContent) {
            HttpContent content = (HttpContent)httpObject;
            task = this.handleContent(cxt, content);
        } else {
            task = Task$.MODULE$.unit();
        }
        Task<BoxedUnit> task2 = task;
        task2.onErrorHandleWith((Function1 & Serializable)ex -> this.handleError(cxt, msg, (Throwable)ex)).flatMap((Function1 & Serializable)_$1 -> this.handleClose(cxt, msg)).runAsyncAndForget(Scheduler$.MODULE$.global());
    }

    public Task<BoxedUnit> handleRequest(ChannelHandlerContext cxt, HttpRequest httpRequest) {
        return (HttpUtil.is100ContinueExpected((HttpMessage)httpRequest) ? HttpHandler$.MODULE$.send100Continue(cxt) : Task$.MODULE$.unit()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.buildStateT(httpRequest).flatMap((Function1 & Serializable)either -> {
                Task<BoxedUnit> task;
                Either either2 = either;
                if (either2 instanceof Right) {
                    State s = (State)((Right)either2).value();
                    this.setState(cxt, (Option<State>)Some$.MODULE$.apply((Object)s));
                    task = this.requestWithContent(cxt, httpRequest);
                } else if (either2 instanceof Left) {
                    LogMessage msg = (LogMessage)((Left)either2).value();
                    task = HttpHandler$.MODULE$.send400BadRequest(cxt, msg);
                } else {
                    throw new MatchError((Object)either2);
                }
                return task.map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    public Task<BoxedUnit> requestWithContent(ChannelHandlerContext cxt, HttpRequest httpRequest) {
        HttpRequest httpRequest2 = httpRequest;
        if (httpRequest2 instanceof HttpContent) {
            HttpContent content = (HttpContent)httpRequest2;
            return this.handleContent(cxt, content);
        }
        return Task$.MODULE$.unit();
    }

    public Task<BoxedUnit> handleError(ChannelHandlerContext cxt, HttpObject msg, Throwable ex) {
        return HttpHandler$.MODULE$.log().errorT(() -> HttpHandler.handleError$$anonfun$1(msg), ex, Line$.MODULE$.apply(152), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.handleError")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return HttpHandler$.MODULE$.send500InternalServerError(cxt, (LogMessage)LogMessage.Error$.MODULE$.apply("Error handling request\n" + this.developerStackTrace(ex))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    public Task<BoxedUnit> handleClose(ChannelHandlerContext cxt, HttpObject msg) {
        return Task$.MODULE$.apply(() -> HttpHandler.handleClose$$anonfun$1(cxt)).void();
    }

    public String developerStackTrace(Throwable throwable) {
        if (HttpHandler$.MODULE$.DeveloperMode()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            throwable.printStackTrace(ps);
            return new String(baos.toByteArray(), Gravity$.MODULE$.UTF_8());
        }
        return "";
    }

    public DataBytes buildBody(FullHttpRequest request) {
        return FullDataBytes$.MODULE$.apply(ByteUtil$.MODULE$.getByteArray(request.content()));
    }

    public Task<Either<LogMessage, State>> buildStateT(HttpRequest request) {
        return (Task)EitherT$.MODULE$.apply(this.buildState1(request)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherT$.MODULE$.apply((Object)Task$.MODULE$.now(this.buildState2(request))).map((Function1 & Serializable)state -> state, (Functor)Task$.MODULE$.catsAsync());
        }, (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<LogMessage, BoxedUnit>> buildState1(HttpRequest request) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(HttpHandler$.MODULE$.RequireHostHeader()))) {
            Option option = Option$.MODULE$.apply((Object)request.headers().get("Host"));
            if (option instanceof Some) {
                String value = (String)((Some)option).value();
                if (HttpHandler$.MODULE$.RequireHostHeaderRegex().matches((CharSequence)value)) {
                    return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
                }
            }
            Option x = option;
            return HttpHandler$.MODULE$.log().warnT(() -> HttpHandler.buildState1$$anonfun$1(x), Line$.MODULE$.apply(186), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.buildState1")).as((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid host")));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT));
    }

    public Either<LogMessage, State> buildState2(HttpRequest request) {
        HttpMethod httpMethod = request.method();
        HttpMethod httpMethod2 = HttpMethod.POST;
        RawBodyBuilder builder = !(httpMethod != null ? !httpMethod.equals(httpMethod2) : httpMethod2 != null) && this.isFormType(request) ? new FormBodyBuilder(request) : new RawBodyBuilder();
        return Request$.MODULE$.apply(request).map((Function1 & Serializable)req -> HttpHandler$State$.MODULE$.apply(request, (GravityRequest)req, builder));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isFormType(HttpRequest request) {
        ContentType contentType = ContentType$.MODULE$.apply((String)Option$.MODULE$.apply((Object)request.headers().get("Content-Type")).getOrElse(HttpHandler::$anonfun$1));
        String string = contentType.value();
        String string2 = "application/x-www-form-urlencoded";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = contentType.value();
        String string4 = "multipart/form-data";
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public Task<BoxedUnit> handleContent(ChannelHandlerContext cxt, HttpContent httpContent) {
        return (Task)this.getState(cxt).map((Function1 & Serializable)state -> {
            boolean isLast = state.builder().add(httpContent);
            if (isLast) {
                this.setState(cxt, (Option<State>)None$.MODULE$);
                cxt.fireChannelReadComplete();
                Option<BodyBuilder.Error> option = state.builder().error();
                if (option instanceof Some) {
                    BodyBuilder.Error err = (BodyBuilder.Error)((Some)option).value();
                    return HttpHandler$.MODULE$.send4xx(cxt, err.status(), err.msg());
                }
                if (None$.MODULE$.equals(option)) {
                    return this.runRequest(cxt, state.raw(), state.builder().updateRequest(state.request())).map((Function1)(JProcedure1 & Serializable)_$2 -> state.builder().release());
                }
                throw new MatchError(option);
            }
            return Task$.MODULE$.unit();
        }).getOrElse(HttpHandler::handleContent$$anonfun$2);
    }

    public Option<String> getRemoteAddress(ChannelHandlerContext cxt, HttpRequest httpRequest) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(HttpHandler$.MODULE$.PeerIPHeader()))) {
            return Option$.MODULE$.apply((Object)httpRequest.headers().get(HttpHandler$.MODULE$.PeerIPHeader()));
        }
        SocketAddress socketAddress = cxt.channel().remoteAddress();
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)socketAddress;
            return Some$.MODULE$.apply((Object)isa.getAddress().getHostAddress());
        }
        SocketAddress cxt2 = socketAddress;
        return None$.MODULE$;
    }

    public Task<BoxedUnit> runRequest(ChannelHandlerContext cxt, HttpRequest httpRequest, GravityRequest inRequest) {
        return this.getClientCert(cxt).flatMap((Function1 & Serializable)clientCert -> HttpHandler$.MODULE$.log().debugT(() -> HttpHandler.runRequest$$anonfun$1$$anonfun$1(clientCert), Line$.MODULE$.apply(233), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.runRequest")).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.now((Object)this.updateRequest(inRequest, (Option<String>)clientCert, this.getRemoteAddress(cxt, httpRequest))).flatMap((Function1 & Serializable)request -> HttpHandler$.MODULE$.log().debugT(() -> HttpHandler.runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(request), Line$.MODULE$.apply(235), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.runRequest")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Task$.MODULE$.apply(HttpHandler::runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)startMs -> this.runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2((GravityRequest)request, httpRequest, cxt, BoxesRunTime.unboxToLong((Object)startMs)));
            }));
        }));
    }

    public GravityRequest updateRequest(GravityRequest req, Option<String> optClientCert, Option<String> optClientIP) {
        if (optClientCert.isEmpty() && optClientIP.isEmpty()) {
            return req;
        }
        Gravity.Headers h1 = (Gravity.Headers)optClientCert.map((Function1 & Serializable)cc -> req.headers().$plus(Gravity$Header$.MODULE$.apply(Gravity$.MODULE$.ElxPeerCertificateSubjectDN(), (String)cc))).getOrElse(() -> HttpHandler.$anonfun$3(req));
        Gravity.Headers h2 = (Gravity.Headers)optClientIP.map((Function1 & Serializable)ip -> h1.$plus(Gravity$Header$.MODULE$.apply(Gravity$.MODULE$.ElxPeerIP(), (String)ip))).getOrElse(() -> HttpHandler.$anonfun$5(h1));
        return req.copy(req.copy$default$1(), req.copy$default$2(), req.copy$default$3(), req.copy$default$4(), req.copy$default$5(), h2, req.copy$default$7(), req.copy$default$8(), req.copy$default$9());
    }

    public Task<Option<String>> getClientCert(ChannelHandlerContext cxt) {
        if (HttpHandler$.MODULE$.ClientCertEnabled()) {
            return Task$.MODULE$.apply(() -> HttpHandler.getClientCert$$anonfun$1(cxt)).onErrorRecoverWith((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof SSLPeerUnverifiedException) {
                        SSLPeerUnverifiedException ex = (SSLPeerUnverifiedException)throwable;
                        return true;
                    }
                    Throwable ex = throwable;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof SSLPeerUnverifiedException) {
                        SSLPeerUnverifiedException ex = (SSLPeerUnverifiedException)throwable;
                        return HttpHandler$.MODULE$.log().debugT(() -> HttpHandler.com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(269), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.getClientCert")).as((Object)None$.MODULE$);
                    }
                    Throwable ex = throwable;
                    return HttpHandler$.MODULE$.log().infoT(() -> HttpHandler.com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$2(ex), Line$.MODULE$.apply(270), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.getClientCert")).as((Object)None$.MODULE$);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$1(javax.net.ssl.SSLPeerUnverifiedException ), com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
                }
            });
        }
        return Task$.MODULE$.now((Object)None$.MODULE$);
    }

    public Task<GravityResponse> handleFailure(GravityRequest request, Task<GravityResponse> response) {
        return response.onErrorRecoverWith((PartialFunction)new Serializable(request, this){
            private final GravityRequest request$14;
            private final /* synthetic */ HttpHandler $outer;
            {
                this.request$14 = request$16;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return HttpHandler$.MODULE$.log().errorT(() -> this.applyOrElse$$anonfun$3(x), x, Line$.MODULE$.apply(278), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.handleFailure")).map((Function1 & Serializable)_$4 -> {
                    int n = Gravity$Status$.MODULE$.InternalServerError();
                    DataBytes dataBytes = DataBytes$.MODULE$.apply(this.$outer.developerStackTrace(x));
                    Gravity.Headers headers = GravityResponse$.MODULE$.$lessinit$greater$default$2();
                    return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
                });
            }

            private final Object applyOrElse$$anonfun$3(Throwable x$2) {
                return "Exception handling " + this.request$14.path() + this.request$14.queryString() + ": " + x$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(java.lang.Throwable ), applyOrElse$$anonfun$4(java.lang.Throwable scala.runtime.BoxedUnit )}, serializedLambda);
            }
        });
    }

    public HttpResponse buildResponse(HttpRequest request, GravityResponse response) {
        DataBytes dataBytes = response.body();
        if (NoDataBytes$.MODULE$.equals(dataBytes)) {
            return this.buildQuickResponse(request, response, new byte[0]);
        }
        if (dataBytes instanceof FullDataBytes) {
            byte[] byArray;
            FullDataBytes fullDataBytes = FullDataBytes$.MODULE$.unapply((FullDataBytes)dataBytes);
            byte[] bytes = byArray = fullDataBytes._1();
            return this.buildQuickResponse(request, response, bytes);
        }
        if (dataBytes instanceof FileDataBytes) {
            File file;
            FileDataBytes fileDataBytes = FileDataBytes$.MODULE$.unapply((FileDataBytes)dataBytes);
            File file2 = file = fileDataBytes._1();
            return this.buildQuickResponse(request, response, com.elixirtech.arch.package$.MODULE$.enrichFile(file2).data());
        }
        if (dataBytes instanceof ObservableDataBytes) {
            Observable observable;
            ObservableDataBytes observableDataBytes = ObservableDataBytes$.MODULE$.unapply((ObservableDataBytes)dataBytes);
            Observable observable2 = observable = observableDataBytes._1();
            return this.buildStreamedResponse(request, response, (Observable<byte[]>)observable2);
        }
        throw new MatchError((Object)dataBytes);
    }

    public HttpResponse buildQuickResponse(HttpRequest request, GravityResponse response, byte[] bytes) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        DefaultFullHttpResponse full = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status()), Unpooled.wrappedBuffer((byte[])bytes));
        response.headers().items().foreach(arg_0 -> HttpHandler.buildQuickResponse$$anonfun$1((FullHttpResponse)full, arg_0));
        if (keepAlive) {
            full.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, full.content().readableBytes());
            full.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        return full;
    }

    public HttpResponse buildStreamedResponse(HttpRequest request, GravityResponse response, Observable<byte[]> value) {
        DefaultHttpResponse reply = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)response.status()));
        response.headers().items().foreach(arg_0 -> HttpHandler.buildStreamedResponse$$anonfun$1((HttpResponse)reply, arg_0));
        reply.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        return reply;
    }

    public Task<BoxedUnit> streamRemainder2(ChannelHandlerContext cxt, HttpRequest request, GravityResponse response) {
        DataBytes dataBytes = response.body();
        if (dataBytes instanceof ObservableDataBytes) {
            Observable observable;
            ObservableDataBytes observableDataBytes = ObservableDataBytes$.MODULE$.unapply((ObservableDataBytes)dataBytes);
            Observable observable2 = observable = observableDataBytes._1();
            return AsyncResponseHelper$.MODULE$.run(response, this.streamObservable(cxt, (Observable<byte[]>)observable2));
        }
        return Task$.MODULE$.unit();
    }

    public Observable<BoxedUnit> streamObservable(ChannelHandlerContext cxt, Observable<byte[]> ob) {
        return ob.doOnStart((Function1 & Serializable)_$5 -> HttpHandler$.MODULE$.log().debugT(HttpHandler::streamObservable$$anonfun$1$$anonfun$1, Line$.MODULE$.apply(337), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.streamObservable"))).mapEval((Function1 & Serializable)bytes -> this.sendBytes(cxt, (byte[])bytes)).onErrorRecoverWith((PartialFunction)new Serializable(this){
            private final /* synthetic */ HttpHandler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                return this.$outer.sendBytesError(x);
            }
        }).guarantee(this.sendEmptyLastContext(cxt)).guarantee(HttpHandler$.MODULE$.log().debugT(HttpHandler::streamObservable$$anonfun$3, Line$.MODULE$.apply(341), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.streamObservable")));
    }

    public Task<BoxedUnit> sendBytes(ChannelHandlerContext cxt, byte[] bytes) {
        return TaskUtil$.MODULE$.toTask(cxt.writeAndFlush((Object)new DefaultHttpContent(Unpooled.wrappedBuffer((byte[])bytes)))).void().map((Function1)(JProcedure1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
    }

    public Observable<BoxedUnit> sendBytesError(Throwable ex) {
        return Observable$.MODULE$.fromTask(HttpHandler$.MODULE$.log().errorT(() -> this.sendBytesError$$anonfun$1(ex), Line$.MODULE$.apply(353), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.sendBytesError"))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.empty().map((Function1)(JProcedure1 & Serializable)ret -> {});
        });
    }

    public String logError(Throwable ex) {
        Throwable throwable = ex;
        if (throwable instanceof ClosedChannelException) {
            return "Connection closed";
        }
        return String.valueOf(ex);
    }

    public Task<BoxedUnit> sendEmptyLastContext(ChannelHandlerContext cxt) {
        return HttpHandler$.MODULE$.log().debugT(HttpHandler::sendEmptyLastContext$$anonfun$1, Line$.MODULE$.apply(367), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.sendEmptyLastContext")).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return TaskUtil$.MODULE$.toTask(cxt.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT)).void().onErrorRecover((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    return true;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    return BoxedUnit.UNIT;
                }
            }).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        super.exceptionCaught(ctx, cause);
    }

    private static final Object handleError$$anonfun$1(HttpObject msg$3) {
        return "Error handling request " + msg$3;
    }

    private static final ChannelHandlerContext handleClose$$anonfun$1(ChannelHandlerContext cxt$6) {
        return cxt$6.flush();
    }

    private static final Object buildState1$$anonfun$1(Option x$1) {
        return "Failed host header test: " + x$1;
    }

    private static final String $anonfun$1() {
        return "";
    }

    private static final Task handleContent$$anonfun$2() {
        return Task$.MODULE$.unit();
    }

    private static final Object runRequest$$anonfun$1$$anonfun$1(Option clientCert$1) {
        return "Got client certificate: " + clientCert$1;
    }

    private static final Object runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(GravityRequest request$3) {
        return "starting request " + request$3.method() + " " + request$3.path() + "\nwith headers\n" + request$3.headers().items();
    }

    private static final long runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1() {
        return System.currentTimeMillis();
    }

    private final HttpResponse runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(HttpRequest httpRequest$10, GravityResponse response$2) {
        return this.buildResponse(httpRequest$10, response$2);
    }

    private static final Object runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(GravityRequest request$9) {
        return "Writing response to " + request$9.method() + " " + request$9.path();
    }

    private static final Object runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(GravityRequest request$13, long startMs$7) {
        return "finished request " + request$13.method() + " " + request$13.path() + " in " + (System.currentTimeMillis() - startMs$7) + "ms";
    }

    private final /* synthetic */ Task runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2(GravityRequest request$5, HttpRequest httpRequest$6, ChannelHandlerContext cxt$11, long startMs) {
        return this.handleFailure(request$5, (Task<GravityResponse>)((Task)this.system.apply((Object)request$5)).map((Function1 & Serializable)_$3 -> Discard4xxResponseBody$.MODULE$.apply((GravityResponse)_$3))).flatMap((Function1 & Serializable)response -> HttpHandler$.MODULE$.developerDelay().flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Task$.MODULE$.apply(() -> this.runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(httpRequest$6, response)).flatMap((Function1 & Serializable)http -> HttpHandler$.MODULE$.log().debugT(() -> HttpHandler.runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(request$5), Line$.MODULE$.apply(240), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.runRequest")).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return HttpHandler$.MODULE$.write(cxt$11, (HttpResponse)http).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.streamRemainder2(cxt$11, httpRequest$6, (GravityResponse)response).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return HttpHandler$.MODULE$.log().debugT(() -> HttpHandler.runRequest$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(request$5, startMs), Line$.MODULE$.apply(243), FullName$.MODULE$.apply("com.elixirtech.gravity.netty4.HttpHandler.runRequest")).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                });
            }));
        }));
    }

    private static final Gravity.Headers $anonfun$3(GravityRequest req$2) {
        return req$2.headers();
    }

    private static final Gravity.Headers $anonfun$5(Gravity.Headers h1$2) {
        return h1$2;
    }

    private static final Option getClientCert$$anonfun$1(ChannelHandlerContext cxt$18) {
        Option option = Option$.MODULE$.apply((Object)cxt$18.channel().pipeline().get(SslHandler.class));
        if (option instanceof Some) {
            SslHandler sslHandler = (SslHandler)((Some)option).value();
            Object[] certs = sslHandler.engine().getSession().getPeerCertificates();
            Object object = Predef$.MODULE$.refArrayOps(certs);
            Option option2 = ArrayOps$.MODULE$.headOption$extension(object);
            if (option2 instanceof Some) {
                Certificate certificate = (Certificate)((Some)option2).value();
                if (certificate instanceof X509Certificate) {
                    X509Certificate x509 = (X509Certificate)certificate;
                    return Some$.MODULE$.apply((Object)("X509:" + x509.getSubjectX500Principal().getName()));
                }
                Certificate other = certificate;
                return Some$.MODULE$.apply((Object)(other.getType() + ":" + other.getClass()));
            }
            if (None$.MODULE$.equals(option2)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option2);
        }
        Option x = option;
        return None$.MODULE$;
    }

    public static final Object com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$1(SSLPeerUnverifiedException ex$2) {
        return "Can't get clientCert: " + ex$2;
    }

    public static final Object com$elixirtech$gravity$netty4$HttpHandler$$anon$1$$_$applyOrElse$$anonfun$2(Throwable ex$3) {
        return "Can't get clientCert: " + ex$3;
    }

    private static final /* synthetic */ HttpHeaders buildQuickResponse$$anonfun$1(FullHttpResponse full$1, Gravity.Header header) {
        return full$1.headers().set(header.name(), (Object)header.value());
    }

    private static final /* synthetic */ HttpHeaders buildStreamedResponse$$anonfun$1(HttpResponse reply$1, Gravity.Header header) {
        return reply$1.headers().set(header.name(), (Object)header.value());
    }

    private static final Object streamObservable$$anonfun$1$$anonfun$1() {
        return "Streaming response";
    }

    private static final Object streamObservable$$anonfun$3() {
        return "Streaming response complete";
    }

    private final Object sendBytesError$$anonfun$1(Throwable ex$4) {
        return "sendBytes error: " + this.logError(ex$4);
    }

    private static final Object sendEmptyLastContext$$anonfun$1() {
        return "sendEmptyLastContext";
    }

    public static final class State
    implements Product,
    Serializable {
        private final HttpRequest raw;
        private final GravityRequest request;
        private final BodyBuilder builder;

        public static State apply(HttpRequest httpRequest, GravityRequest gravityRequest, BodyBuilder bodyBuilder) {
            return HttpHandler$State$.MODULE$.apply(httpRequest, gravityRequest, bodyBuilder);
        }

        public static State fromProduct(Product product) {
            return HttpHandler$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return HttpHandler$State$.MODULE$.unapply(state);
        }

        public State(HttpRequest raw, GravityRequest request, BodyBuilder builder) {
            this.raw = raw;
            this.request = request;
            this.builder = builder;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            HttpRequest httpRequest = this.raw();
            HttpRequest httpRequest2 = state.raw();
            if (httpRequest == null) {
                if (httpRequest2 != null) {
                    return false;
                }
            } else if (!httpRequest.equals(httpRequest2)) return false;
            GravityRequest gravityRequest = this.request();
            GravityRequest gravityRequest2 = state.request();
            if (gravityRequest == null) {
                if (gravityRequest2 != null) {
                    return false;
                }
            } else if (!((Object)gravityRequest).equals(gravityRequest2)) return false;
            BodyBuilder bodyBuilder = this.builder();
            BodyBuilder bodyBuilder2 = state.builder();
            if (bodyBuilder == null) {
                if (bodyBuilder2 == null) return true;
                return false;
            } else {
                if (!bodyBuilder.equals(bodyBuilder2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "raw";
                }
                case 1: {
                    return "request";
                }
                case 2: {
                    return "builder";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public HttpRequest raw() {
            return this.raw;
        }

        public GravityRequest request() {
            return this.request;
        }

        public BodyBuilder builder() {
            return this.builder;
        }

        public State copy(HttpRequest raw, GravityRequest request, BodyBuilder builder) {
            return new State(raw, request, builder);
        }

        public HttpRequest copy$default$1() {
            return this.raw();
        }

        public GravityRequest copy$default$2() {
            return this.request();
        }

        public BodyBuilder copy$default$3() {
            return this.builder();
        }

        public HttpRequest _1() {
            return this.raw();
        }

        public GravityRequest _2() {
            return this.request();
        }

        public BodyBuilder _3() {
            return this.builder();
        }
    }
}

