/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.webserver;

import com.elixirtech.arch.LRUCache;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.webserver.ETag;
import com.elixirtech.webserver.ETag$ETagInfo$;
import java.io.File;
import java.io.Serializable;
import java.security.MessageDigest;
import org.apache.commons.codec.digest.DigestUtils;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

public final class ETag$
implements Serializable {
    private static final int LRUSize;
    private static final String Algorithm;
    public static final ETag$ETagInfo$ ETagInfo;
    private static final LRUCache<String, ETag.ETagInfo> etagCache;
    public static final ETag$ MODULE$;

    private ETag$() {
    }

    static {
        MODULE$ = new ETag$();
        LRUSize = 500;
        Algorithm = "SHA-256";
        etagCache = new LRUCache(MODULE$.LRUSize());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ETag$.class);
    }

    public int LRUSize() {
        return LRUSize;
    }

    public String Algorithm() {
        return Algorithm;
    }

    public String addQuotes(String etag) {
        return "\"" + etag + "\"";
    }

    public Set<String> getIfNoneMatch(GravityRequest req) {
        return req.headers().getAll("If-None-Match").flatMap((Function1 & Serializable)header -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])header.split(","));
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s.trim()), "\"")), "\""), ClassTag$.MODULE$.apply(String.class)));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$1 -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(_$1))));
        }).toSet();
    }

    public ETag.ETagInfo apply(File file) {
        ETag.ETagInfo info;
        String key = file.getAbsolutePath();
        Option option = etagCache.get((Object)key);
        if (option instanceof Some && (info = (ETag.ETagInfo)((Some)option).value()).length() == file.length() && info.lastModified() == file.lastModified()) {
            return info;
        }
        ETag.ETagInfo ret = ETag$ETagInfo$.MODULE$.apply(key, file.lastModified(), file.length(), this.computeETag(file));
        etagCache.put((Object)key, (Object)ret);
        return ret;
    }

    public ETag.ETagInfo apply(String key, byte[] bytes, long lastModified) {
        ETag.ETagInfo info;
        Option option = etagCache.get((Object)key);
        if (option instanceof Some && (info = (ETag.ETagInfo)((Some)option).value()).length() == (long)bytes.length && info.lastModified() == lastModified) {
            return info;
        }
        ETag.ETagInfo ret = ETag$ETagInfo$.MODULE$.apply(key, lastModified, Int$.MODULE$.int2long(bytes.length), this.computeETag(bytes));
        etagCache.put((Object)key, (Object)ret);
        return ret;
    }

    public String computeETag(File file) {
        return new DigestUtils(MessageDigest.getInstance(this.Algorithm())).digestAsHex(file);
    }

    public String computeETag(byte[] bytes) {
        return new DigestUtils(MessageDigest.getInstance(this.Algorithm())).digestAsHex(bytes);
    }
}

