/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.timestamp;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.dateops.DateUtil$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.etl.timestamp.FormatLogic$;
import ambience.etl.timestamp.ParseString;
import ambience.etl.timestamp.ParseString$Info$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonDateTime;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple4$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Left$;
import scala.util.Right;
import scala.util.Right$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ParseString$
implements Builder,
PanelBuilder,
Serializable {
    private static final String stepType;
    public static final ParseString$Info$ Info;
    private static final Json InfoJson;
    public static final ParseString$ MODULE$;

    private ParseString$() {
    }

    static {
        MODULE$ = new ParseString$();
        stepType = ETLStepType$.MODULE$.apply("timestamp.ParseString");
        ParseString.Info info = (ParseString.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)ParseString$Info$.MODULE$.apply(ParseString$Info$.MODULE$.$lessinit$greater$default$1(), ParseString$Info$.MODULE$.$lessinit$greater$default$2(), ParseString$Info$.MODULE$.$lessinit$greater$default$3(), ParseString$Info$.MODULE$.$lessinit$greater$default$4()));
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ParseString$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        ParseString.Info info = (ParseString.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ParseString$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ParseString$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ParseString$::$anonfun$3))))).toOption().getOrElse(ParseString$::$anonfun$4);
        Panel.Item fieldName = PanelItem$.MODULE$.text("sourceField", "String Field", info.sourceField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item format = PanelItem$.MODULE$.text("format", "Format", info.format(), PanelItem$.MODULE$.text$default$4());
        Panel.Item locale = PanelItem$.MODULE$.select("locale", "Locale", Json$.MODULE$.fromString(info.locale()), DateUtil$.MODULE$.localeChoices(), PanelItem$.MODULE$.select$default$5());
        Panel.Item destField = PanelItem$.MODULE$.text("destField", "To Field", info.destField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> ParseString$.buildPanel$$anonfun$1(fieldName, format, locale, destField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> ParseString$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> parse(Builder.Context cxt, ParseString.Info info, DateTimeFormatter formatter, Observable<Document> from) {
        if (info.destField().isEmpty()) {
            return from;
        }
        ZoneId zoneId = ((Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class))).zoneId();
        return from.mapEval((Function1 & Serializable)doc -> MODULE$.run(cxt, info, formatter, zoneId, (Document)doc));
    }

    public Task<Document> run(Builder.Context cxt, ParseString.Info info, DateTimeFormatter formatter, ZoneId zoneId, Document doc) {
        Option option = doc.get(info.sourceField(), DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
        if (option instanceof Some) {
            BsonString ts = (BsonString)((Some)option).value();
            String str = ts.getValue().trim();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(str))) {
                Try try_ = Try$.MODULE$.apply(() -> ParseString$.run$$anonfun$1(str, formatter));
                if (try_ instanceof Success) {
                    LocalDateTime dt = (LocalDateTime)((Success)try_).value();
                    BsonDateTime newValue = BsonDateTime$.MODULE$.apply(dt.atZone(zoneId).toInstant().toEpochMilli());
                    return Task$.MODULE$.now((Object)BsonETL$.MODULE$.put(doc, info.destField(), (BsonValue)newValue));
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    return cxt.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Can't parse " + str + ": " + ex)).flatMap((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return cxt.logRecord(doc, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't parse " + str)).map((Function1 & Serializable)ret -> ret);
                    });
                }
                throw new MatchError((Object)try_);
            }
            return Task$.MODULE$.now((Object)doc);
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)doc);
        }
        throw new MatchError((Object)option);
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        Either either = this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ParseString$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ParseString$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ParseString$::build$$anonfun$3)))));
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            return Left$.MODULE$.apply((Object)this.error(step, err));
        }
        if (either instanceof Right) {
            ParseString.Info info = (ParseString.Info)((Right)either).value();
            Locale locale = DateUtil$.MODULE$.getLocale(info.locale());
            Try<DateTimeFormatter> try_ = FormatLogic$.MODULE$.buildFormatter(info.format(), locale);
            if (try_ instanceof Success) {
                DateTimeFormatter formatter = (DateTimeFormatter)((Success)try_).value();
                return Right$.MODULE$.apply((Function1 & Serializable)from -> MODULE$.parse(cxt, info, formatter, (Observable<Document>)from));
            }
            if (try_ instanceof Failure) {
                Throwable err = ((Failure)try_).exception();
                return Left$.MODULE$.apply((Object)BuildError$.MODULE$.apply("Can't build formatter " + info.format(), step, err));
            }
            throw new MatchError(try_);
        }
        throw new MatchError((Object)either);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var2_1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        ParseString$Info$ parseString$Info$ = ParseString$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ParseString.Info)parseString$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final ParseString.Info $anonfun$4() {
        return ParseString$Info$.MODULE$.apply(ParseString$Info$.MODULE$.$lessinit$greater$default$1(), ParseString$Info$.MODULE$.$lessinit$greater$default$2(), ParseString$Info$.MODULE$.$lessinit$greater$default$3(), ParseString$Info$.MODULE$.$lessinit$greater$default$4());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item fieldName$1, Panel.Item format$1, Panel.Item locale$1, Panel.Item destField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)fieldName$1, (List)new .colon.colon((Object)format$1, (List)new .colon.colon((Object)locale$1, (List)new .colon.colon((Object)destField$1, (List)Nil$.MODULE$)))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        ParseString$Info$ parseString$Info$ = ParseString$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ParseString.Info)parseString$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "sourceField";
        String string2 = "format";
        String string3 = "locale";
        String string4 = "destField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", ParseString$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), ParseString$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ParseString$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            ParseString.Info info2 = (ParseString.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "sourceField";
            String string2 = "format";
            String string3 = "locale";
            String string4 = "destField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(ParseString$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string5 = step$1.copy$default$1();
            String string6 = step$1.copy$default$2();
            String string7 = step$1.copy$default$3();
            String string8 = step$1.copy$default$4();
            String string9 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }

    private static final LocalDateTime run$$anonfun$1(String str$1, DateTimeFormatter formatter$2) {
        return LocalDateTime.parse(str$1, formatter$2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        ParseString$Info$ parseString$Info$ = ParseString$Info$.MODULE$;
        return (Function1 & Serializable)p -> (ParseString.Info)parseString$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)ParseString$Info$.MODULE$.$lessinit$greater$default$4()));
    }
}

