/*
 * Decompiled with CFR 0.152.
 */
package ambience.developer;

import ambience.developer.BsonPipeline;
import ambience.developer.PipelineSubstitution$;
import io.circe.Json;
import java.io.Serializable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonDocument$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;

public class BsonPipelineSubstitution {
    private final BsonPipeline pipeline;
    private final PartialFunction lookupBsonFn;
    private final Function1 lookup;

    public BsonPipelineSubstitution(BsonPipeline pipeline, PartialFunction<String, Json> lookupFn) {
        this.pipeline = pipeline;
        this.lookupBsonFn = lookupFn.andThen((Function1 & Serializable)_$2 -> PipelineSubstitution$.MODULE$.toBson((Json)_$2));
        this.lookup = pipeline.parameters().orElse(this.lookupBsonFn()).lift();
    }

    public PartialFunction<String, BsonValue> lookupBsonFn() {
        return this.lookupBsonFn;
    }

    public Function1<String, Option<BsonValue>> lookup() {
        return this.lookup;
    }

    public BsonPipeline run() {
        List newSteps = this.pipeline.steps().flatMap((Function1 & Serializable)step -> this.fix((BsonValue)step)).flatMap((Function1 & Serializable)bv -> this.ensureDocSteps((BsonValue)bv));
        return this.pipeline.copy((List<BsonValue>)newSteps, this.pipeline.copy$default$2());
    }

    public Option<BsonValue> fix(BsonValue step2) {
        BsonValue bsonValue = step2;
        if (bsonValue instanceof BsonDocument) {
            BsonDocument doc = (BsonDocument)bsonValue;
            Option option = Option$.MODULE$.apply((Object)doc.get((Object)"$elx-lookup"));
            if (option instanceof Some) {
                BsonValue elx = (BsonValue)((Some)option).value();
                return this.decodeElx(elx);
            }
            if (None$.MODULE$.equals(option)) {
                List fixed = CollectionConverters$.MODULE$.SetHasAsScala(doc.entrySet()).asScala().toList().flatMap((Function1 & Serializable)entry -> {
                    String key = (String)entry.getKey();
                    BsonValue value = (BsonValue)entry.getValue();
                    BsonValue bsonValue = value;
                    if (bsonValue instanceof BsonDocument) {
                        BsonDocument child = (BsonDocument)bsonValue;
                        return this.fix((BsonValue)child).map((Function1 & Serializable)nv -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, nv);
                        });
                    }
                    if (bsonValue instanceof BsonArray) {
                        BsonArray child = (BsonArray)bsonValue;
                        return this.fix((BsonValue)child).map((Function1 & Serializable)nv -> {
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, nv);
                        });
                    }
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)key);
                    return Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)value));
                });
                return Some$.MODULE$.apply((Object)BsonDocument$.MODULE$.apply((Iterable)fixed));
            }
            throw new MatchError((Object)option);
        }
        if (bsonValue instanceof BsonArray) {
            BsonArray arr = (BsonArray)bsonValue;
            return Some$.MODULE$.apply((Object)BsonArray$.MODULE$.fromIterable((Iterable)CollectionConverters$.MODULE$.ListHasAsScala(arr.getValues()).asScala().flatMap((Function1 & Serializable)step -> this.fix((BsonValue)step))));
        }
        return Some$.MODULE$.apply((Object)step2);
    }

    public List<BsonValue> ensureDocSteps(BsonValue bv2) {
        BsonValue bsonValue = bv2;
        if (bsonValue instanceof BsonArray) {
            BsonArray array = (BsonArray)bsonValue;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(array.getValues()).asScala().flatMap((Function1 & Serializable)bv -> this.ensureDocSteps((BsonValue)bv))).toList();
        }
        if (bsonValue instanceof BsonDocument) {
            BsonDocument obj = (BsonDocument)bsonValue;
            return (List)new .colon.colon((Object)obj, (List)Nil$.MODULE$);
        }
        return package$.MODULE$.Nil();
    }

    public Option<BsonValue> decodeElx(BsonValue elx) {
        return this.asString(elx).flatMap(this.lookup());
    }

    public Option<String> asString(BsonValue bv) {
        if (bv.isString()) {
            return Some$.MODULE$.apply((Object)bv.asString().getValue());
        }
        return None$.MODULE$;
    }
}

