/*
 * Decompiled with CFR 0.152.
 */
package ambience.developer;

import ambience.developer.CollectionManagement;
import ambience.developer.CollectionManagement$;
import ambience.developer.CollectionManagement$CollectionRow$;
import ambience.developer.DBAccess$;
import ambience.developer.DBUtils$;
import ambience.developer.DeveloperModule$;
import ambience.developer.DocId;
import ambience.developer.IndexManagement$;
import ambience.developer.MongoDBConfig;
import ambience.developer.MongoDBQuery;
import ambience.developer.MongoDBQuerySorted;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.result.DeleteResult;
import io.circe.Json;
import io.circe.ParsingFailure;
import io.circe.parser.package$;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.zip.GZIPOutputStream;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.json.JsonMode;
import org.bson.json.JsonWriterSettings;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonDouble$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class CollectionManagementHelper$
implements Serializable {
    private static final JsonWriterSettings extendedJsonSettings;
    private static final String JSON;
    private static final String JSONGZ;
    private static final Gravity.Header JsonType;
    private static final Gravity.Header JsonGzType;
    private static final Gravity.Header BsonType;
    public static final CollectionManagementHelper$ MODULE$;

    private CollectionManagementHelper$() {
    }

    static {
        MODULE$ = new CollectionManagementHelper$();
        extendedJsonSettings = JsonWriterSettings.builder().outputMode(JsonMode.EXTENDED).build();
        JSON = "application/json";
        JSONGZ = "application/json+gzip";
        JsonType = Gravity.Header$.MODULE$.ContentType(MODULE$.JSON());
        JsonGzType = Gravity.Header$.MODULE$.ContentType(MODULE$.JSONGZ());
        BsonType = Gravity.Header$.MODULE$.ContentType("application/bson");
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CollectionManagementHelper$.class);
    }

    public JsonWriterSettings extendedJsonSettings() {
        return extendedJsonSettings;
    }

    public String JSON() {
        return JSON;
    }

    public String JSONGZ() {
        return JSONGZ;
    }

    public Gravity.Header JsonType() {
        return JsonType;
    }

    public Gravity.Header JsonGzType() {
        return JsonGzType;
    }

    public Gravity.Header BsonType() {
        return BsonType;
    }

    public Observable<Document> aggregate(MongoCollection<Document> cltn, List<BsonDocument> content) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.aggregate(content, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).allowDiskUse(true));
    }

    /*
     * Enabled aggressive block sorting
     */
    public BsonValue buildBson(DocId docId) {
        String string = docId.idType();
        switch (string == null ? 0 : string.hashCode()) {
            case -1325958191: {
                if (!"double".equals(string)) break;
                BsonString bsonString = BsonDouble$.MODULE$.apply(BoxesRunTime.unboxToDouble((Object)StringOps$.MODULE$.toDoubleOption$extension(Predef$.MODULE$.augmentString(docId.value())).getOrElse(() -> CollectionManagementHelper$.buildBson$$anonfun$4(docId))));
                return (BsonValue)bsonString;
            }
            case -891985903: {
                if (!"string".equals(string)) break;
                BsonString bsonString = BsonString$.MODULE$.apply(docId.value());
                return (BsonValue)bsonString;
            }
            case 90495162: {
                if (!"objectId".equals(string)) break;
                BsonString bsonString = BsonObjectId$.MODULE$.apply(docId.value());
                return (BsonValue)bsonString;
            }
            case 100359822: {
                if (!"int32".equals(string)) break;
                BsonString bsonString = BsonInt32$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(docId.value())).getOrElse(() -> CollectionManagementHelper$.buildBson$$anonfun$1(docId))));
                return (BsonValue)bsonString;
            }
            case 100359917: {
                if (!"int64".equals(string)) break;
                BsonString bsonString = BsonInt64$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(docId.value())).getOrElse(() -> CollectionManagementHelper$.buildBson$$anonfun$2(docId))));
                return (BsonValue)bsonString;
            }
            case 1792749467: {
                if (!"dateTime".equals(string)) break;
                BsonString bsonString = BsonDateTime$.MODULE$.apply(BoxesRunTime.unboxToLong((Object)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(docId.value())).getOrElse(() -> CollectionManagementHelper$.buildBson$$anonfun$3(docId))));
                return (BsonValue)bsonString;
            }
        }
        String x = string;
        throw new RuntimeException("Can't support " + x);
    }

    public Task<CollectionManagement.CollectionRow> buildCollectionRow(MongoDatabase mdb, String dbName, String cltnName) {
        return this.getRowCount(mdb, cltnName).map((Function1 & Serializable)rowCount -> CollectionManagement$CollectionRow$.MODULE$.apply(dbName, cltnName, BoxesRunTime.unboxToLong((Object)rowCount)));
    }

    public Task<BoxedUnit> copyAllIndexes(MongoCollection<Document> fromCltn, MongoCollection<Document> toCltn) {
        return IndexManagement$.MODULE$.getIndexes(fromCltn).mapEval((Function1 & Serializable)index -> {
            String name = (String)index.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue()).getOrElse(CollectionManagementHelper$::$anonfun$2);
            CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.copyAllIndexes$$anonfun$1$$anonfun$1(fromCltn, name, toCltn), Line$.MODULE$.apply(59), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.copyAllIndexes"));
            return IndexManagement$.MODULE$.createIndexCopy(toCltn, (Document)index);
        }).completedL();
    }

    public Task<Object> createDocument(MongoCollection<Document> cltn, String doc) {
        Either either = package$.MODULE$.parse(doc);
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                CollectionManagementHelper$.createDocument$$anonfun$1(cltn, json);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return com.elixirtech.mongodb.package$.MODULE$.enrichCollection(cltn).insertOneT(org.mongodb.scala.bson.package$.MODULE$.Document().apply(json.noSpaces())).map((Function1 & Serializable)_$2 -> true).map((Function1 & Serializable)reply -> BoxesRunTime.unboxToBoolean((Object)reply));
            });
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.createDocument$$anonfun$3(err), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.createDocument"));
            Task$.MODULE$.raiseError((Throwable)err);
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        throw new MatchError((Object)either);
    }

    public Task<MongoDBConfig.Database> doBuildConfig(String dbName) {
        return this.getCollectionNames(DBAccess$.MODULE$.getDatabase(dbName)).take(Int$.MODULE$.int2long(CollectionManagement$.MODULE$.DBCollectionLimit())).toListL().map((Function1 & Serializable)cNames -> MongoDBConfig.Database$.MODULE$.apply(dbName, cNames.map((Function1 & Serializable)name -> MongoDBConfig.Collection$.MODULE$.apply(name))));
    }

    public Task<GravityResponse> doCopyCltn(CollectionManagement.CollectionCopy cltnCopy) {
        String string = cltnCopy.oldDBName();
        String string2 = cltnCopy.newDBName();
        Task<GravityResponse> responseT = !(string != null ? !string.equals(string2) : string2 != null) ? this.copyWithinDatabase(cltnCopy) : this.copyAcrossDatabases(cltnCopy);
        return responseT.onErrorHandle((Function1 & Serializable)ex -> {
            CollectionManagement$.MODULE$.log().error(() -> CollectionManagementHelper$.doCopyCltn$$anonfun$1$$anonfun$1(ex), Line$.MODULE$.apply(90), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.doCopyCltn"));
            return Gravity$.MODULE$.BadRequestResponse(ex.getMessage().replaceAll("(.*)\"errmsg\": \"", "").replaceAll("\", \"(.*)", ""));
        });
    }

    public Task<GravityResponse> copyWithinDatabase(CollectionManagement.CollectionCopy cltnCopy) {
        MongoCollection<Document> oldCltn = DBUtils$.MODULE$.getCollection(cltnCopy.oldDBName(), cltnCopy.oldCltnName());
        MongoCollection<Document> newCltn = DBUtils$.MODULE$.getCollection(cltnCopy.newDBName(), cltnCopy.newCltnName());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$out");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(cltnCopy.newCltnName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument step = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CollectionManagementHelper$.copyWithinDatabase$$anonfun$1(oldCltn, newCltn);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.aggregate(oldCltn, (List<BsonDocument>)((List)new .colon.colon((Object)step, (List)Nil$.MODULE$))).completedL().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.copyAllIndexes(oldCltn, newCltn).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                });
            });
        });
    }

    public Task<GravityResponse> copyAcrossDatabases(CollectionManagement.CollectionCopy cltnCopy) {
        if (DeveloperModule$.MODULE$.isMongoDB()) {
            return this.copyAcrossDatabasesMongoDB(cltnCopy);
        }
        return this.copyAcrossDatabasesDocumentDB(cltnCopy);
    }

    public Task<GravityResponse> copyAcrossDatabasesMongoDB(CollectionManagement.CollectionCopy cltnCopy) {
        MongoCollection<Document> oldCltn = DBUtils$.MODULE$.getCollection(cltnCopy.oldDBName(), cltnCopy.oldCltnName());
        MongoCollection<Document> newCltn = DBUtils$.MODULE$.getCollection(cltnCopy.newDBName(), cltnCopy.newCltnName());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$out");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[2];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"db");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(cltnCopy.newDBName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"coll");
        objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(cltnCopy.newCltnName())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument step = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CollectionManagementHelper$.copyAcrossDatabasesMongoDB$$anonfun$1(oldCltn, newCltn);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.aggregate(oldCltn, (List<BsonDocument>)((List)new .colon.colon((Object)step, (List)Nil$.MODULE$))).completedL().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.copyAllIndexes(oldCltn, newCltn).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                });
            });
        });
    }

    public Task<GravityResponse> copyAcrossDatabasesDocumentDB(CollectionManagement.CollectionCopy cltnCopy) {
        RichMongoCollection oldCltn = new RichMongoCollection(DBUtils$.MODULE$.getCollection(cltnCopy.oldDBName(), cltnCopy.oldCltnName()));
        RichMongoCollection newCltn = new RichMongoCollection(DBUtils$.MODULE$.getCollection(cltnCopy.newDBName(), cltnCopy.newCltnName()));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CollectionManagementHelper$.copyAcrossDatabasesDocumentDB$$anonfun$1(oldCltn, newCltn);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return newCltn.dropT().flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.copyAllIndexes((MongoCollection<Document>)oldCltn.cltn(), (MongoCollection<Document>)newCltn.cltn()).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return MODULE$.explicitClone(oldCltn, newCltn).map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
                    });
                });
            });
        });
    }

    public Task<BoxedUnit> explicitClone(RichMongoCollection from, RichMongoCollection to) {
        return from.findO().bufferTumbling(DeveloperModule$.MODULE$.ExplicitCloneChunks()).mapEval((Function1 & Serializable)docs -> to.insertManyT(docs)).completedL();
    }

    public Task<GravityResponse> doDownload(Json json, MongoCollection<Document> cltn, MongoDBQuerySorted dbQuery, String mimeType) {
        String string;
        String cltnName = com.elixirtech.mongodb.package$.MODULE$.enrichCollection(cltn).cltn().namespace().getCollectionName();
        String name = cltnName + " - Data";
        String string2 = mimeType;
        String string3 = this.JSON();
        String string4 = string2;
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            string = name + ".json";
        } else {
            String string5 = this.JSONGZ();
            String string6 = string2;
            string = !(string5 != null ? !string5.equals(string6) : string6 != null) ? name + ".json.gz" : name + ".bson";
        }
        String filename = string;
        Gravity.Header cdt = GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
        return this.executeQuerySorted(json, cltn, dbQuery).toListL().map((Function1 & Serializable)docs -> {
            String string = mimeType;
            String string2 = MODULE$.JSON();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                String json = docs.map((Function1 & Serializable)_$3 -> _$3.toJson()).mkString("\n");
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{MODULE$.JsonType(), cdt}));
                DataBytes dataBytes = DataBytes$.MODULE$.apply(json);
                int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
            }
            String string4 = MODULE$.JSONGZ();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gzip = new GZIPOutputStream(baos);
                docs.foreach((Function1)(JProcedure1 & Serializable)doc -> gzip.write((doc.toJson() + "\n").getBytes("UTF-8")));
                gzip.close();
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{MODULE$.JsonGzType(), cdt}));
                DataBytes dataBytes = DataBytes$.MODULE$.apply(baos.toByteArray());
                int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
            }
            Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{MODULE$.BsonType(), cdt}));
            DataBytes dataBytes = DataBytes$.MODULE$.apply(BsonUtils$.MODULE$.toByteArray((Seq)docs));
            int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
            return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
        });
    }

    public Task<BoxedUnit> dropDocs(MongoCollection<Document> cltn, List<DocId> ids) {
        Bson filter = Filters$.MODULE$.in("_id", (Seq)ids.map((Function1 & Serializable)docId -> MODULE$.buildBson((DocId)docId)));
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.dropDocs$$anonfun$1(filter), Line$.MODULE$.apply(164), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.dropDocs"));
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CollectionManagementHelper$.dropDocs$$anonfun$2(cltn, ids);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.deleteMany(filter)).map((Function1)(JProcedure1 & Serializable)reply -> CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.dropDocs$$anonfun$3$$anonfun$1$$anonfun$1(reply), Line$.MODULE$.apply(167), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.dropDocs"))).completedL().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
    }

    public Observable<Document> executeCountQuery(Json json, RichMongoCollection cltn, MongoDBQuery query) {
        if (json.isArray()) {
            Vector steps = (Vector)json.asArray().map((Function1 & Serializable)v -> (Vector)v.map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces()))).getOrElse(CollectionManagementHelper$::$anonfun$6);
            Object[] objectArray = new BsonDocument[1];
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$count");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("count")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            Vector countStep = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.cltn().aggregate((Seq)steps.$plus$plus((IterableOnce)countStep), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).allowDiskUse(true));
        }
        Object[] objectArray = new BsonDocument[1];
        Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply(json.noSpaces())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
        Vector steps = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray4 = new BsonDocument[1];
        Object[] objectArray5 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$count");
        objectArray5[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply("count")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray4[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
        Vector countStep = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.cltn().aggregate((Seq)steps.$plus$plus((IterableOnce)countStep), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).allowDiskUse(true));
    }

    public Observable<Document> executeQuery(Json json, RichMongoCollection cltn, MongoDBQuery query) {
        if (json.isArray()) {
            Vector vector;
            Vector steps = (Vector)json.asArray().map((Function1 & Serializable)v -> (Vector)v.map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces()))).getOrElse(CollectionManagementHelper$::$anonfun$8);
            Option option = query.limit();
            if (option instanceof Some) {
                int lim = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                Object[] objectArray = new BsonDocument[2];
                Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$skip");
                objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(query.skip())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
                Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$limit");
                objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(lim)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                objectArray[1] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
                vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else if (None$.MODULE$.equals(option)) {
                Object[] objectArray = new BsonDocument[1];
                Object[] objectArray4 = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$skip");
                objectArray4[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(query.skip())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
                vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            } else {
                throw new MatchError((Object)option);
            }
            Vector limits = vector;
            return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.cltn().aggregate((Seq)steps.$plus$plus((IterableOnce)limits), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).allowDiskUse(true));
        }
        Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)query.skip()));
        Option option = FindOptions$.MODULE$.$lessinit$greater$default$1();
        Option option2 = FindOptions$.MODULE$.$lessinit$greater$default$2();
        return cltn.findO((Bson)BsonDocument$.MODULE$.apply(json.noSpaces()), FindOptions$.MODULE$.apply(option, option2, (Option)some, query.limit()));
    }

    public Observable<Document> executeQuerySorted(Json json, MongoCollection<Document> cltn, MongoDBQuerySorted query) {
        Vector vector;
        Vector<BsonDocument> steps = this.returnSteps(json, query);
        Option option = query.limit();
        if (option instanceof Some) {
            int lim = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            Object[] objectArray = new BsonDocument[2];
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$skip");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(query.skip())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$limit");
            objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(lim)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[1] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3));
            vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else if (None$.MODULE$.equals(option)) {
            Object[] objectArray = new BsonDocument[1];
            Object[] objectArray4 = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$skip");
            objectArray4[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(query.skip())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
            vector = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        } else {
            throw new MatchError((Object)option);
        }
        Vector limits = vector;
        return Observable$.MODULE$.fromReactivePublisher((Publisher)cltn.aggregate((Seq)steps.$plus$plus((IterableOnce)limits), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).allowDiskUse(true));
    }

    public Vector<BsonDocument> returnSteps(Json json, MongoDBQuerySorted query) {
        if (json.isArray()) {
            Option steps = json.asArray().map((Function1 & Serializable)v -> (Vector)v.map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces()))).map((Function1 & Serializable)v -> {
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(query.columnName()))) {
                    if (query.ascending()) {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$sort");
                        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(query.columnName()));
                        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        return (Vector)v.$colon$plus((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    }
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$sort");
                    Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(query.columnName()));
                    objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(-1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    return (Vector)v.$colon$plus((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                }
                return v;
            });
            Option option = steps;
            if (option instanceof Some) {
                Vector steps2 = (Vector)((Some)option).value();
                return steps2;
            }
            if (None$.MODULE$.equals(option)) {
                return (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonDocument[]{BsonDocument$.MODULE$.apply()}));
            }
            throw new MatchError((Object)option);
        }
        Object[] objectArray = new BsonDocument[1];
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply(json.noSpaces())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        Vector steps = (Vector)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(query.columnName()))) {
            if (query.ascending()) {
                Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$sort");
                Object[] objectArray4 = new BsonMagnets.CanBeBsonElement[2];
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(query.columnName()));
                objectArray4[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                objectArray4[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonInt32$.MODULE$.apply(1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                return (Vector)steps.$colon$plus((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3)));
            }
            Object[] objectArray5 = new BsonMagnets.CanBeBsonElement[1];
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$sort");
            Object[] objectArray6 = new BsonMagnets.CanBeBsonElement[2];
            String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(query.columnName()));
            objectArray6[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BsonInt32$.MODULE$.apply(-1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray6[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonInt32$.MODULE$.apply(1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray5[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray6))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return (Vector)steps.$colon$plus((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5)));
        }
        return steps;
    }

    public Task<List<String>> findDocs(RichMongoCollection cltn, List<DocId> docIDs) {
        List<DocId> list = docIDs;
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<DocId> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Nil());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            DocId head = (DocId)colon2.head();
            List tail = list3;
            return this.findDoc(cltn, head).flatMap((Function1 & Serializable)s -> MODULE$.findDocs(cltn, (List<DocId>)tail).map((Function1 & Serializable)s2 -> (List)s.map((Function1 & Serializable)s1 -> s2.$colon$colon(s1)).getOrElse(() -> CollectionManagementHelper$.findDocs$$anonfun$1$$anonfun$1$$anonfun$2(s2))));
        }
        throw new MatchError(list);
    }

    public Task<Option<String>> findDoc(RichMongoCollection cltn, DocId docID) {
        return cltn.findO(Filters$.MODULE$.eq("_id", (Object)this.buildBson(docID))).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return Some$.MODULE$.apply((Object)doc.toJson(MODULE$.extendedJsonSettings()));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    public Observable<String> getCollectionNames(MongoDatabase mdb) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)mdb.listCollectionNames());
    }

    public Observable<String> getDatabaseNames(MongoDB mongoDB) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)mongoDB.mongoClient().listDatabaseNames()).filter((Function1 & Serializable)dbName -> DBAccess$.MODULE$.isAllowed((String)dbName));
    }

    public Task<String> getFieldNames(MongoCollection<Document> cltn) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$project");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"arrayOfKeyValue");
        Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$objectToArray");
        objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)"$$ROOT"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument step1 = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray4 = new BsonMagnets.CanBeBsonElement[1];
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$unwind");
        objectArray4[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)"$arrayOfKeyValue"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        BsonDocument step2 = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray4));
        Object[] objectArray5 = new BsonMagnets.CanBeBsonElement[1];
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$group");
        Object[] objectArray6 = new BsonMagnets.CanBeBsonElement[2];
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray6[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BsonNull$.MODULE$.apply()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"allKeys");
        Object[] objectArray7 = new BsonMagnets.CanBeBsonElement[1];
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$addToSet");
        objectArray7[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)"$arrayOfKeyValue.k"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        objectArray6[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray7))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray5[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray6))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument step3 = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray5));
        return this.aggregate(cltn, (List<BsonDocument>)((List)new .colon.colon((Object)step1, (List)new .colon.colon((Object)step2, (List)new .colon.colon((Object)step3, (List)Nil$.MODULE$))))).toListL().map((Function1 & Serializable)docs -> docs.map((Function1 & Serializable)_$4 -> _$4.toJson()).mkString("[", ",", "]"));
    }

    public String getQuery(MongoDBQuery mongoDBQuery) {
        String query = mongoDBQuery.query().trim();
        if (query.isEmpty()) {
            return "{}";
        }
        return query;
    }

    public String getQuerySorted(MongoDBQuerySorted mongoDBQuery) {
        String query = mongoDBQuery.query().trim();
        if (query.isEmpty()) {
            return "{}";
        }
        return query;
    }

    public Task<Object> getRowCount(MongoDatabase mdb, String cltnName) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)mdb.getCollection(cltnName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).estimatedDocumentCount()).firstL();
    }

    public Task<Document> validate(MongoDatabase mdb, String cltnName, boolean full) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"validate");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)cltnName), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"full");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BoxesRunTime.boxToBoolean((boolean)full)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBoolean());
        return Observable$.MODULE$.fromReactivePublisher((Publisher)mdb.runCommand((Bson)org.mongodb.scala.bson.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).firstL();
    }

    public Task<Object> replaceDocument(MongoCollection<Document> cltn, Json doc) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.replaceDocument$$anonfun$1(cltn, doc), Line$.MODULE$.apply(286), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.replaceDocument"));
        BsonDocument bsonDoc = BsonDocument$.MODULE$.apply(doc.noSpaces());
        Option option = Option$.MODULE$.apply((Object)bsonDoc.get((Object)"_id"));
        if (option instanceof Some) {
            BsonValue id = (BsonValue)((Some)option).value();
            return this.testDocExist(cltn, id).flatMap((Function1 & Serializable)ok -> CollectionManagementHelper$.replaceDocument$$anonfun$2(id, cltn, doc, bsonDoc, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                CollectionManagementHelper$.replaceDocument$$anonfun$3();
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)_$6 -> false);
        }
        throw new MatchError((Object)option);
    }

    public Task<Object> testCltnExist(CollectionManagement.CollectionCopy cltnCopy) {
        MongoDatabase targetDB = DBAccess$.MODULE$.getDatabase(cltnCopy.newDBName());
        return this.getCollectionNames(targetDB).toListL().flatMap((Function1 & Serializable)list -> {
            if (list.contains((Object)cltnCopy.newCltnName())) {
                return MODULE$.getRowCount(targetDB, cltnCopy.newCltnName()).map((Function1)(JFunction1.mcZJ.sp & Serializable)_$7 -> _$7 != 0L);
            }
            return Task$.MODULE$.now((Object)BoxesRunTime.boxToBoolean((boolean)false));
        });
    }

    public Task<Object> testDocExist(MongoCollection<Document> cltn, BsonValue docID) {
        return com.elixirtech.mongodb.package$.MODULE$.enrichCollection(cltn).findO(Filters$.MODULE$.eq("_id", (Object)docID)).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return true;
            }
            if (None$.MODULE$.equals(option)) {
                return false;
            }
            throw new MatchError((Object)option);
        });
    }

    private static final int buildBson$$anonfun$1(DocId docId$1) {
        throw new RuntimeException("Can't process BsonValue int32 " + docId$1.value());
    }

    private static final long buildBson$$anonfun$2(DocId docId$2) {
        throw new RuntimeException("Can't process BsonValue int64 " + docId$2.value());
    }

    private static final long buildBson$$anonfun$3(DocId docId$3) {
        throw new RuntimeException("Can't process BsonValue dateTime " + docId$3.value());
    }

    private static final double buildBson$$anonfun$4(DocId docId$4) {
        throw new RuntimeException("Can't process BsonValue double " + docId$4.value());
    }

    private static final String $anonfun$2() {
        return "<missing name>";
    }

    private static final Object copyAllIndexes$$anonfun$1$$anonfun$1(MongoCollection fromCltn$2, String name$1, MongoCollection toCltn$2) {
        return "Copying index from " + fromCltn$2.namespace() + ":" + name$1 + " to " + toCltn$2.namespace();
    }

    private static final Object createDocument$$anonfun$1$$anonfun$1(MongoCollection cltn$2, Json json$2) {
        return "Creating document " + cltn$2.namespace() + ": " + json$2;
    }

    private static final void createDocument$$anonfun$1(MongoCollection cltn$1, Json json$1) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.createDocument$$anonfun$1$$anonfun$1(cltn$1, json$1), Line$.MODULE$.apply(69), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.createDocument"));
    }

    private static final Object createDocument$$anonfun$3(ParsingFailure err$1) {
        return "createDocument: cannot parse Json string error: " + err$1;
    }

    private static final Object doCopyCltn$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Copy collection error: " + ex$1.getMessage();
    }

    private static final Object copyWithinDatabase$$anonfun$1$$anonfun$1(MongoCollection oldCltn$2, MongoCollection newCltn$2) {
        return "Copying collection from " + oldCltn$2.namespace() + " to " + newCltn$2.namespace() + " (same database)";
    }

    private static final void copyWithinDatabase$$anonfun$1(MongoCollection oldCltn$1, MongoCollection newCltn$1) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.copyWithinDatabase$$anonfun$1$$anonfun$1(oldCltn$1, newCltn$1), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.copyWithinDatabase"));
    }

    private static final Object copyAcrossDatabasesMongoDB$$anonfun$1$$anonfun$1(MongoCollection oldCltn$6, MongoCollection newCltn$6) {
        return "Copying MongoDB collection from " + oldCltn$6.namespace() + " to " + newCltn$6.namespace();
    }

    private static final void copyAcrossDatabasesMongoDB$$anonfun$1(MongoCollection oldCltn$5, MongoCollection newCltn$5) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.copyAcrossDatabasesMongoDB$$anonfun$1$$anonfun$1(oldCltn$5, newCltn$5), Line$.MODULE$.apply(116), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.copyAcrossDatabasesMongoDB"));
    }

    private static final Object copyAcrossDatabasesDocumentDB$$anonfun$1$$anonfun$1(RichMongoCollection oldCltn$10, RichMongoCollection newCltn$10) {
        return "Copying DocumentDB collection from " + oldCltn$10.cltn().namespace() + " to " + newCltn$10.cltn().namespace();
    }

    private static final void copyAcrossDatabasesDocumentDB$$anonfun$1(RichMongoCollection oldCltn$9, RichMongoCollection newCltn$9) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.copyAcrossDatabasesDocumentDB$$anonfun$1$$anonfun$1(oldCltn$9, newCltn$9), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.copyAcrossDatabasesDocumentDB"));
    }

    private static final Object dropDocs$$anonfun$1(Bson filter$1) {
        return "Filters = " + filter$1.toString();
    }

    private static final Object dropDocs$$anonfun$2$$anonfun$1(MongoCollection cltn$5, List ids$2) {
        return "Dropping documents " + cltn$5.namespace() + ":" + ids$2.mkString(", ");
    }

    private static final void dropDocs$$anonfun$2(MongoCollection cltn$4, List ids$1) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.dropDocs$$anonfun$2$$anonfun$1(cltn$4, ids$1), Line$.MODULE$.apply(166), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.dropDocs"));
    }

    private static final Object dropDocs$$anonfun$3$$anonfun$1$$anonfun$1(DeleteResult reply$1) {
        return reply$1.getDeletedCount() + " deleted";
    }

    private static final Vector $anonfun$6() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private static final Vector $anonfun$8() {
        return scala.package$.MODULE$.Vector().empty();
    }

    private static final List findDocs$$anonfun$1$$anonfun$1$$anonfun$2(List s2$2) {
        return s2$2;
    }

    private static final Object replaceDocument$$anonfun$1(MongoCollection cltn$8, Json doc$1) {
        return "Converting document to BsonDocument " + cltn$8.namespace() + ": " + doc$1.noSpaces();
    }

    private static final Object replaceDocument$$anonfun$2$$anonfun$1$$anonfun$1(MongoCollection cltn$11, Json doc$4) {
        return "Editing document " + cltn$11.namespace() + ": " + doc$4;
    }

    private static final void replaceDocument$$anonfun$2$$anonfun$1(MongoCollection cltn$10, Json doc$3) {
        CollectionManagement$.MODULE$.log().info(() -> CollectionManagementHelper$.replaceDocument$$anonfun$2$$anonfun$1$$anonfun$1(cltn$10, doc$3), Line$.MODULE$.apply(294), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.replaceDocument"));
    }

    private static final Object replaceDocument$$anonfun$2$$anonfun$3$$anonfun$1() {
        return "Editing document failed, no _id found";
    }

    private static final void replaceDocument$$anonfun$2$$anonfun$3() {
        CollectionManagement$.MODULE$.log().info(CollectionManagementHelper$::replaceDocument$$anonfun$2$$anonfun$3$$anonfun$1, Line$.MODULE$.apply(301), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.replaceDocument"));
    }

    private static final /* synthetic */ Task replaceDocument$$anonfun$2(BsonValue id$1, MongoCollection cltn$9, Json doc$2, BsonDocument bsonDoc$1, boolean ok) {
        if (ok) {
            Bson filter = Filters$.MODULE$.eq("_id", (Object)id$1);
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                CollectionManagementHelper$.replaceDocument$$anonfun$2$$anonfun$1(cltn$9, doc$2);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return com.elixirtech.mongodb.package$.MODULE$.enrichCollection(cltn$9).replaceOneT(filter, org.mongodb.scala.bson.package$.MODULE$.Document().apply(bsonDoc$1)).map((Function1 & Serializable)result -> result.wasAcknowledged()).map((Function1 & Serializable)reply -> BoxesRunTime.unboxToBoolean((Object)reply));
            });
        }
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CollectionManagementHelper$.replaceDocument$$anonfun$2$$anonfun$3();
            return BoxedUnit.UNIT;
        }).map((Function1 & Serializable)_$5 -> false);
    }

    private static final Object replaceDocument$$anonfun$3$$anonfun$1() {
        return "Editing document failed, no _id found";
    }

    private static final void replaceDocument$$anonfun$3() {
        CollectionManagement$.MODULE$.log().info(CollectionManagementHelper$::replaceDocument$$anonfun$3$$anonfun$1, Line$.MODULE$.apply(304), FullName$.MODULE$.apply("ambience.developer.CollectionManagementHelper.replaceDocument"));
    }
}

