/*
 * Decompiled with CFR 0.152.
 */
package ambience.developer;

import ambience.developer.DatasetFieldAnalysis$;
import ambience.developer.DatasetFieldAnalysis$BooleanChoices$;
import ambience.developer.DatasetFieldAnalysis$HMSChoices$;
import ambience.developer.DatasetFieldAnalysis$HMSLots$;
import ambience.developer.DatasetFieldAnalysis$Int32Choices$;
import ambience.developer.DatasetFieldAnalysis$Int64Choices$;
import ambience.developer.DatasetFieldAnalysis$Lots$;
import ambience.developer.DatasetFieldAnalysis$StringChoices$;
import ambience.developer.DatasetFieldAnalysis$YMDChoices$;
import ambience.developer.DatasetFieldAnalysis$YMDLots$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.coredata.Data$;
import io.circe.Json;
import java.io.Serializable;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashMap;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.matching.Regex;

public class DatasetFieldAnalysis
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatasetFieldAnalysis.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final int maxUnique;
    private final Set<String> ignore;
    private final HashMap<String, Measure> measures;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DatasetFieldAnalysis$.class.getDeclaredField("MaxEnumerableStringLength$lzy1"));

    public static Regex HHMMSS() {
        return DatasetFieldAnalysis$.MODULE$.HHMMSS();
    }

    public static Lots LotsInt32() {
        return DatasetFieldAnalysis$.MODULE$.LotsInt32();
    }

    public static Lots LotsInt64() {
        return DatasetFieldAnalysis$.MODULE$.LotsInt64();
    }

    public static Lots LotsString() {
        return DatasetFieldAnalysis$.MODULE$.LotsString();
    }

    public static Lots LotsUnknown() {
        return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
    }

    public static int MaxEnumerableStringLength() {
        return DatasetFieldAnalysis$.MODULE$.MaxEnumerableStringLength();
    }

    public static Regex YYYYMMDD() {
        return DatasetFieldAnalysis$.MODULE$.YYYYMMDD();
    }

    public static boolean isHMS(String string) {
        return DatasetFieldAnalysis$.MODULE$.isHMS(string);
    }

    public static boolean isYMD(String string) {
        return DatasetFieldAnalysis$.MODULE$.isYMD(string);
    }

    public static Set<String> $lessinit$greater$default$2() {
        return DatasetFieldAnalysis$.MODULE$.$lessinit$greater$default$2();
    }

    public DatasetFieldAnalysis(int maxUnique, Set<String> ignore) {
        this.maxUnique = maxUnique;
        this.ignore = ignore;
        this.measures = new HashMap();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DatasetFieldAnalysis add(BsonDocument doc) {
        this.add("", doc);
        return this;
    }

    public Data.Schema results() {
        List fields = ((List)this.measures.toList().sortBy((Function1 & Serializable)_$1 -> (String)_$1._1(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Measure v = (Measure)tuple2._2();
                Option choices = v.choices().map((Function1 & Serializable)values -> Data.Choices$.MODULE$.apply(values));
                return Data.Field$.MODULE$.apply(k, v.dataType(), Data.FieldProperties$.MODULE$.apply(choices, Data.FieldProperties$.MODULE$.$lessinit$greater$default$2()));
            }
            throw new MatchError((Object)tuple2);
        });
        return Data.Schema$.MODULE$.apply(fields);
    }

    private void add(String prefix, BsonDocument doc) {
        CollectionConverters$.MODULE$.SetHasAsScala(doc.entrySet()).asScala().foreach((Function1)(JProcedure1 & Serializable)entry -> {
            String key = prefix + entry.getKey();
            if (!this.ignore.contains((Object)key)) {
                BsonValue value = (BsonValue)entry.getValue();
                if (!value.isNull()) {
                    if (value.isDocument()) {
                        this.add(key + ".", value.asDocument());
                        return;
                    }
                    Option option = this.measures.get((Object)key);
                    if (option instanceof Some) {
                        Measure measure = (Measure)((Some)option).value();
                        v0 = this.measures.put((Object)key, (Object)measure.add(this.maxUnique, value));
                    } else if (None$.MODULE$.equals(option)) {
                        v0 = this.measures.put((Object)key, (Object)this.newMeasure(value));
                    } else {
                        throw new MatchError((Object)option);
                    }
                    return;
                }
                return;
            }
        });
    }

    private Measure newMeasure(BsonValue value) {
        Measure measure;
        Data.Type type = Data$.MODULE$.fromBsonName(value.getBsonType().name());
        if (Data.StringType$.MODULE$.equals(type)) {
            String s = value.asString().getValue();
            measure = DatasetFieldAnalysis$.MODULE$.isYMD(s) ? DatasetFieldAnalysis$YMDChoices$.MODULE$.apply((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s})))) : (DatasetFieldAnalysis$.MODULE$.isHMS(s) ? DatasetFieldAnalysis$HMSChoices$.MODULE$.apply((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s})))) : DatasetFieldAnalysis$StringChoices$.MODULE$.apply((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{s})))));
        } else if (Data.Int32Type$.MODULE$.equals(type)) {
            measure = DatasetFieldAnalysis$Int32Choices$.MODULE$.apply((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{value.asInt32().getValue()}))));
        } else if (Data.Int64Type$.MODULE$.equals(type)) {
            measure = DatasetFieldAnalysis$Int64Choices$.MODULE$.apply((Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{value.asInt64().getValue()}))));
        } else if (Data.BooleanType$.MODULE$.equals(type)) {
            measure = DatasetFieldAnalysis$BooleanChoices$.MODULE$;
        } else {
            Data.Type x = type;
            measure = DatasetFieldAnalysis$Lots$.MODULE$.apply(x);
        }
        return measure;
    }

    public static final class HMSChoices
    implements Measure,
    Product,
    Serializable {
        private final Set set;
        private final Data.Type dataType;

        public static HMSChoices apply(Set<String> set) {
            return DatasetFieldAnalysis$HMSChoices$.MODULE$.apply(set);
        }

        public static HMSChoices fromProduct(Product product) {
            return DatasetFieldAnalysis$HMSChoices$.MODULE$.fromProduct(product);
        }

        public static HMSChoices unapply(HMSChoices hMSChoices) {
            return DatasetFieldAnalysis$HMSChoices$.MODULE$.unapply(hMSChoices);
        }

        public HMSChoices(Set<String> set) {
            this.set = set;
            this.dataType = Data.IsoLocalTimeType$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof HMSChoices)) return false;
            HMSChoices hMSChoices = (HMSChoices)object;
            Set<String> set = this.set();
            Set<String> set2 = hMSChoices.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof HMSChoices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "HMSChoices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "set";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> set() {
            return this.set;
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            if (bv.isNull()) {
                return this;
            }
            if (bv.isString()) {
                String s = bv.asString().getValue();
                Set newSet = (Set)this.set().$plus((Object)bv.asString().getValue());
                int newSetSize = newSet.size();
                if (DatasetFieldAnalysis$.MODULE$.isHMS(s)) {
                    return newSetSize > unique ? DatasetFieldAnalysis$HMSLots$.MODULE$ : DatasetFieldAnalysis$HMSChoices$.MODULE$.apply((Set<String>)newSet);
                }
                return newSetSize > unique ? DatasetFieldAnalysis$.MODULE$.LotsString() : DatasetFieldAnalysis$StringChoices$.MODULE$.apply((Set<String>)newSet);
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return Some$.MODULE$.apply((Object)((List)this.set().toList().sorted((Ordering)Ordering.String$.MODULE$)).map(DatasetFieldAnalysis$::ambience$developer$DatasetFieldAnalysis$HMSChoices$$_$choices$$anonfun$3));
        }

        public HMSChoices copy(Set<String> set) {
            return new HMSChoices(set);
        }

        public Set<String> copy$default$1() {
            return this.set();
        }

        public Set<String> _1() {
            return this.set();
        }
    }

    public static final class Int32Choices
    implements Measure,
    Product,
    Serializable {
        private final Set set;
        private final Data.Type dataType;

        public static Int32Choices apply(Set<Object> set) {
            return DatasetFieldAnalysis$Int32Choices$.MODULE$.apply(set);
        }

        public static Int32Choices fromProduct(Product product) {
            return DatasetFieldAnalysis$Int32Choices$.MODULE$.fromProduct(product);
        }

        public static Int32Choices unapply(Int32Choices int32Choices) {
            return DatasetFieldAnalysis$Int32Choices$.MODULE$.unapply(int32Choices);
        }

        public Int32Choices(Set<Object> set) {
            this.set = set;
            this.dataType = Data.Int32Type$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Int32Choices)) return false;
            Int32Choices int32Choices = (Int32Choices)object;
            Set<Object> set = this.set();
            Set<Object> set2 = int32Choices.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Int32Choices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Int32Choices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "set";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Object> set() {
            return this.set;
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            if (bv.isNull()) {
                return this;
            }
            if (bv.isInt32()) {
                Set newSet = (Set)this.set().$plus((Object)BoxesRunTime.boxToInteger((int)bv.asInt32().getValue()));
                int newSetSize = newSet.size();
                return newSetSize > unique ? DatasetFieldAnalysis$.MODULE$.LotsInt32() : DatasetFieldAnalysis$Int32Choices$.MODULE$.apply((Set<Object>)newSet);
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return Some$.MODULE$.apply((Object)((List)this.set().toList().sorted((Ordering)Ordering.Int$.MODULE$)).map(DatasetFieldAnalysis$::ambience$developer$DatasetFieldAnalysis$Int32Choices$$_$choices$$anonfun$adapted$1));
        }

        public Int32Choices copy(Set<Object> set) {
            return new Int32Choices(set);
        }

        public Set<Object> copy$default$1() {
            return this.set();
        }

        public Set<Object> _1() {
            return this.set();
        }
    }

    public static final class Int64Choices
    implements Measure,
    Product,
    Serializable {
        private final Set set;
        private final Data.Type dataType;

        public static Int64Choices apply(Set<Object> set) {
            return DatasetFieldAnalysis$Int64Choices$.MODULE$.apply(set);
        }

        public static Int64Choices fromProduct(Product product) {
            return DatasetFieldAnalysis$Int64Choices$.MODULE$.fromProduct(product);
        }

        public static Int64Choices unapply(Int64Choices int64Choices) {
            return DatasetFieldAnalysis$Int64Choices$.MODULE$.unapply(int64Choices);
        }

        public Int64Choices(Set<Object> set) {
            this.set = set;
            this.dataType = Data.Int64Type$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Int64Choices)) return false;
            Int64Choices int64Choices = (Int64Choices)object;
            Set<Object> set = this.set();
            Set<Object> set2 = int64Choices.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Int64Choices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Int64Choices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "set";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<Object> set() {
            return this.set;
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            if (bv.isNull()) {
                return this;
            }
            if (bv.isInt64()) {
                Set newSet = (Set)this.set().$plus((Object)BoxesRunTime.boxToLong((long)bv.asInt64().getValue()));
                int newSetSize = newSet.size();
                return newSetSize > unique ? DatasetFieldAnalysis$.MODULE$.LotsInt64() : DatasetFieldAnalysis$Int64Choices$.MODULE$.apply((Set<Object>)newSet);
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return Some$.MODULE$.apply((Object)((List)this.set().toList().sorted((Ordering)Ordering.Long$.MODULE$)).map(DatasetFieldAnalysis$::ambience$developer$DatasetFieldAnalysis$Int64Choices$$_$choices$$anonfun$adapted$2));
        }

        public Int64Choices copy(Set<Object> set) {
            return new Int64Choices(set);
        }

        public Set<Object> copy$default$1() {
            return this.set();
        }

        public Set<Object> _1() {
            return this.set();
        }
    }

    public static final class Lots
    implements Measure,
    Product,
    Serializable {
        private final Data.Type dataType;

        public static Lots apply(Data.Type type) {
            return DatasetFieldAnalysis$Lots$.MODULE$.apply(type);
        }

        public static Lots fromProduct(Product product) {
            return DatasetFieldAnalysis$Lots$.MODULE$.fromProduct(product);
        }

        public static Lots unapply(Lots lots) {
            return DatasetFieldAnalysis$Lots$.MODULE$.unapply(lots);
        }

        public Lots(Data.Type dataType) {
            this.dataType = dataType;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Lots)) return false;
            Lots lots = (Lots)object;
            Data.Type type = this.dataType();
            Data.Type type2 = lots.dataType();
            if (type != null) {
                if (!type.equals(type2)) return false;
                return true;
            }
            if (type2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Lots;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Lots";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "dataType";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            Data.Type newType;
            if (bv.isNull()) {
                return this;
            }
            Data.Type type = newType = Data$.MODULE$.fromBsonName(bv.getBsonType().name());
            Data.Type type2 = this.dataType();
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                return this;
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return None$.MODULE$;
        }

        public Lots copy(Data.Type dataType) {
            return new Lots(dataType);
        }

        public Data.Type copy$default$1() {
            return this.dataType();
        }

        public Data.Type _1() {
            return this.dataType();
        }
    }

    public static interface Measure {
        public Data.Type dataType();

        public Measure add(int var1, BsonValue var2);

        public Option<List<Json>> choices();
    }

    public static final class StringChoices
    implements Measure,
    Product,
    Serializable {
        private final Set set;
        private final Data.Type dataType;

        public static StringChoices apply(Set<String> set) {
            return DatasetFieldAnalysis$StringChoices$.MODULE$.apply(set);
        }

        public static StringChoices fromProduct(Product product) {
            return DatasetFieldAnalysis$StringChoices$.MODULE$.fromProduct(product);
        }

        public static StringChoices unapply(StringChoices stringChoices) {
            return DatasetFieldAnalysis$StringChoices$.MODULE$.unapply(stringChoices);
        }

        public StringChoices(Set<String> set) {
            this.set = set;
            this.dataType = Data.StringType$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof StringChoices)) return false;
            StringChoices stringChoices = (StringChoices)object;
            Set<String> set = this.set();
            Set<String> set2 = stringChoices.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof StringChoices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "StringChoices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "set";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> set() {
            return this.set;
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            if (bv.isNull()) {
                return this;
            }
            if (bv.isString()) {
                String newString = bv.asString().getValue();
                if (newString.length() > DatasetFieldAnalysis$.MODULE$.MaxEnumerableStringLength()) {
                    return DatasetFieldAnalysis$.MODULE$.LotsString();
                }
                Set newSet = (Set)this.set().$plus((Object)newString);
                int newSetSize = newSet.size();
                return newSetSize > unique ? DatasetFieldAnalysis$.MODULE$.LotsString() : DatasetFieldAnalysis$StringChoices$.MODULE$.apply((Set<String>)newSet);
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return Some$.MODULE$.apply((Object)((List)this.set().toList().sorted((Ordering)Ordering.String$.MODULE$)).map(DatasetFieldAnalysis$::ambience$developer$DatasetFieldAnalysis$StringChoices$$_$choices$$anonfun$1));
        }

        public StringChoices copy(Set<String> set) {
            return new StringChoices(set);
        }

        public Set<String> copy$default$1() {
            return this.set();
        }

        public Set<String> _1() {
            return this.set();
        }
    }

    public static final class YMDChoices
    implements Measure,
    Product,
    Serializable {
        private final Set set;
        private final Data.Type dataType;

        public static YMDChoices apply(Set<String> set) {
            return DatasetFieldAnalysis$YMDChoices$.MODULE$.apply(set);
        }

        public static YMDChoices fromProduct(Product product) {
            return DatasetFieldAnalysis$YMDChoices$.MODULE$.fromProduct(product);
        }

        public static YMDChoices unapply(YMDChoices yMDChoices) {
            return DatasetFieldAnalysis$YMDChoices$.MODULE$.unapply(yMDChoices);
        }

        public YMDChoices(Set<String> set) {
            this.set = set;
            this.dataType = Data.IsoLocalDateType$.MODULE$;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof YMDChoices)) return false;
            YMDChoices yMDChoices = (YMDChoices)object;
            Set<String> set = this.set();
            Set<String> set2 = yMDChoices.set();
            if (set != null) {
                if (!set.equals(set2)) return false;
                return true;
            }
            if (set2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof YMDChoices;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "YMDChoices";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "set";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Set<String> set() {
            return this.set;
        }

        @Override
        public Data.Type dataType() {
            return this.dataType;
        }

        @Override
        public Measure add(int unique, BsonValue bv) {
            if (bv.isNull()) {
                return this;
            }
            if (bv.isString()) {
                String s = bv.asString().getValue();
                Set newSet = (Set)this.set().$plus((Object)bv.asString().getValue());
                int newSetSize = newSet.size();
                if (DatasetFieldAnalysis$.MODULE$.isYMD(s)) {
                    return newSetSize > unique ? DatasetFieldAnalysis$YMDLots$.MODULE$ : DatasetFieldAnalysis$YMDChoices$.MODULE$.apply((Set<String>)newSet);
                }
                return newSetSize > unique ? DatasetFieldAnalysis$.MODULE$.LotsString() : DatasetFieldAnalysis$StringChoices$.MODULE$.apply((Set<String>)newSet);
            }
            return DatasetFieldAnalysis$.MODULE$.LotsUnknown();
        }

        @Override
        public Option<List<Json>> choices() {
            return Some$.MODULE$.apply((Object)((List)this.set().toList().sorted((Ordering)Ordering.String$.MODULE$)).map(DatasetFieldAnalysis$::ambience$developer$DatasetFieldAnalysis$YMDChoices$$_$choices$$anonfun$2));
        }

        public YMDChoices copy(Set<String> set) {
            return new YMDChoices(set);
        }

        public Set<String> copy$default$1() {
            return this.set();
        }

        public Set<String> _1() {
            return this.set();
        }
    }
}

