/*
 * Decompiled with CFR 0.152.
 */
package ambience.developer;

import ambience.developer.DBUtils$;
import ambience.developer.ExportDashboard$;
import ambience.developer.ExportDashboard$Dashboard$;
import ambience.developer.ExportDashboard$DashboardPage$;
import ambience.developer.ExportDashboard$DashboardView$;
import ambience.developer.ExportDashboard$DashboardViewJson$;
import ambience.developer.ExportDashboard$ETLDataset$;
import ambience.developer.ExportDashboard$MongoDBDataset$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LogMessage$;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.KeyDecoder$;
import io.circe.ParsingFailure;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import monix.eval.Task;
import org.bson.BsonString;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.Observable;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple1$;
import scala.Tuple2$;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.HashSet;
import scala.concurrent.Await$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ExportDashboard {
    private final String dashboardId;
    private final File tmpFile;
    private final ZipOutputStream zipFile;
    private final HashSet<Dataset> seen;
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(ExportDashboard$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ExportDashboard$.class.getDeclaredField("mongoDB$lzy1"));

    public static Task<Map<String, String>> getDashboards() {
        return ExportDashboard$.MODULE$.getDashboards();
    }

    public static LoggingInterface log() {
        return ExportDashboard$.MODULE$.log();
    }

    public static MongoDB mongoDB() {
        return ExportDashboard$.MODULE$.mongoDB();
    }

    public ExportDashboard(String dashboardId) {
        this.dashboardId = dashboardId;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.tmpFile = new File(tmpDir, "dashboard-" + dashboardId + ".zip");
        this.zipFile = new ZipOutputStream(new FileOutputStream(this.tmpFile));
        this.seen = new HashSet();
    }

    public Task<Either<LogMessage, File>> run() {
        RichMongoCollection dashboards = new RichMongoCollection(ExportDashboard$.MODULE$.mongoDB().database().getCollection("Dashboards", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return dashboards.findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(this.dashboardId))).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document dash = (Document)((Some)option).value();
                Comparable name = (Comparable)dash.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).getOrElse(ExportDashboard::$anonfun$1);
                this.zipFile.putNextEntry(new ZipEntry("Dashboards/" + this.dashboardId));
                this.zipFile.write(this.getBytes(dash));
                this.zipFile.closeEntry();
                LogMessage logMessage = this.run(dash);
                if (LogMessage.None$.MODULE$.equals(logMessage)) {
                    this.zipFile.close();
                    ExportDashboard$.MODULE$.log().info(() -> this.run$$anonfun$1$$anonfun$1(name), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.run"));
                    return package$.MODULE$.Right().apply((Object)this.tmpFile);
                }
                LogMessage msg = logMessage;
                this.zipFile.close();
                ExportDashboard$.MODULE$.log().info(() -> this.run$$anonfun$1$$anonfun$2(name), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.run"));
                ExportDashboard$.MODULE$.log().apply(msg, Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.run"));
                return package$.MODULE$.Left().apply((Object)msg);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Dashboard " + this.dashboardId + " not found"));
            }
            throw new MatchError((Object)option);
        });
    }

    public LogMessage run(Document dashboard) {
        String string = "pages";
        boolean size = true;
        Either either = io.circe.parser.package$.MODULE$.decode(dashboard.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Dashboard", ExportDashboard::run$$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string), ExportDashboard::run$$anonfun$3, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::run$$anonfun$4)))));
        if (either instanceof Right) {
            Dashboard dash = (Dashboard)((Right)either).value();
            Set allViews = ((IterableOnceOps)dash.pages().values().flatMap((Function1 & Serializable)_$3 -> _$3.views().map((Function1 & Serializable)_$4 -> _$4.view()))).toSet();
            this.runViews((Set<DashboardViewJson>)allViews);
            return this.runViewDS((Set<DashboardViewJson>)allViews);
        }
        if (either instanceof Left) {
            Error err = (Error)((Left)either).value();
            return LogMessage.Error$.MODULE$.apply(err.getMessage());
        }
        throw new MatchError((Object)either);
    }

    public LogMessage runViews(Set<DashboardViewJson> views) {
        ExportDashboard$.MODULE$.log().info(() -> ExportDashboard.runViews$$anonfun$1(views), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.runViews"));
        MongoCollection datasets = ExportDashboard$.MODULE$.mongoDB().database().getCollection("Datasets", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        Set msgs = (Set)views.map((Function1 & Serializable)view -> {
            String string = view.subsetName();
            String string2 = "";
            Object name = (string == null ? string2 != null : !string.equals(string2)) ? view.datasetName() + ":" + view.subsetName() : view.datasetName();
            Seq reply = (Seq)this.await(org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> ExportDashboard.$anonfun$13(datasets, (String)name)).toFuture());
            Option option = reply.headOption();
            if (option instanceof Some) {
                Document ds = (Document)((Some)option).value();
                String string3 = view.subsetName();
                String string4 = "";
                String zipName = (string3 == null ? string4 != null : !string3.equals(string4)) ? view.datasetName() + "~" + view.subsetName() : view.datasetName();
                this.zipFile.putNextEntry(new ZipEntry("Datasets/" + zipName));
                this.zipFile.write(this.getBytes(ds));
                this.zipFile.closeEntry();
                return LogMessage.None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                return LogMessage.Error$.MODULE$.apply("Dataset " + (String)name + " not found");
            }
            throw new MatchError((Object)option);
        });
        return LogMessage$.MODULE$.merge((Seq)msgs.toList());
    }

    public LogMessage runViewDS(Set<DashboardViewJson> views) {
        ExportDashboard$.MODULE$.log().info(() -> ExportDashboard.runViewDS$$anonfun$1(views), Line$.MODULE$.apply(111), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.runViewDS"));
        MongoCollection datasets = ExportDashboard$.MODULE$.mongoDB().database().getCollection("Datasets", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        Set msgs = (Set)views.map((Function1 & Serializable)view -> {
            String name;
            String string = view.subsetName();
            String string2 = "";
            Object object = (string == null ? string2 != null : !string.equals(string2)) ? view.datasetName() + ":" + view.subsetName() : (name = view.datasetName());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(name))) {
                Seq reply = (Seq)this.await(org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> ExportDashboard.$anonfun$15(datasets, name)).toFuture());
                Option option = reply.headOption();
                if (option instanceof Some) {
                    Document ds = (Document)((Some)option).value();
                    return this.runDS(ds);
                }
                if (None$.MODULE$.equals(option)) {
                    return LogMessage.Error$.MODULE$.apply("Dataset " + name + " not found");
                }
                throw new MatchError((Object)option);
            }
            return LogMessage.None$.MODULE$;
        });
        return LogMessage$.MODULE$.merge((Seq)msgs.toList());
    }

    public LogMessage runDS(Document ds) {
        String datasetType;
        String string = datasetType = (String)ds.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$5 -> _$5.getValue()).getOrElse(ExportDashboard::$anonfun$17);
        String string2 = "MongoDB";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String string3 = "datasetType";
            String string4 = "database";
            String string5 = "collection";
            int size = 3;
            Either either = io.circe.parser.package$.MODULE$.decode(ds.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("MongoDBDataset", ExportDashboard::runDS$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3), ExportDashboard::runDS$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::runDS$$anonfun$3)))));
            if (either instanceof Right) {
                MongoDBDataset mdb = (MongoDBDataset)((Right)either).value();
                return this.load(mdb);
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                return LogMessage.Error$.MODULE$.apply("Can't decode MongoDB dataset from " + ds.toJson() + ": " + err);
            }
            throw new MatchError((Object)either);
        }
        String string6 = datasetType;
        String string7 = "ETL";
        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
            String string8 = "datasetType";
            String string9 = "chainset";
            String string10 = "chain";
            int size = 3;
            Either either = io.circe.parser.package$.MODULE$.decode(ds.toJson(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("ETLDataset", ExportDashboard::runDS$$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string10).$colon$colon((Object)string9).$colon$colon((Object)string8), ExportDashboard::runDS$$anonfun$5, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::runDS$$anonfun$6)))));
            if (either instanceof Right) {
                ETLDataset etl = (ETLDataset)((Right)either).value();
                return this.load(etl);
            }
            if (either instanceof Left) {
                Error err = (Error)((Left)either).value();
                return LogMessage.Error$.MODULE$.apply("Can't decode ETL dataset from " + ds.toJson() + ": " + err);
            }
            throw new MatchError((Object)either);
        }
        return LogMessage.Error$.MODULE$.apply("Unexpected datasetType: " + datasetType);
    }

    public LogMessage load(MongoDBDataset mdb) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mdb.database())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(mdb.collection())) && !this.seen.contains((Object)mdb)) {
            ExportDashboard$.MODULE$.log().info(() -> ExportDashboard.load$$anonfun$1(mdb), Line$.MODULE$.apply(146), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.load"));
            this.seen.$plus$eq((Object)mdb);
            MongoCollection<Document> cltn = DBUtils$.MODULE$.getCollection(mdb.database(), mdb.collection());
            Seq records = (Seq)this.await(org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> ExportDashboard.$anonfun$18(cltn)).toFuture());
            String zipName = "MongoDB/" + mdb.database() + "/" + mdb.collection();
            this.zipFile.putNextEntry(new ZipEntry(zipName));
            this.zipFile.write(BsonUtils$.MODULE$.toByteArray(records));
            this.zipFile.closeEntry();
        }
        return LogMessage.None$.MODULE$;
    }

    public LogMessage load(ETLDataset etl) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(etl.chainset())) && !this.seen.contains((Object)etl)) {
            this.seen.$plus$eq((Object)etl);
            ExportDashboard$.MODULE$.log().info(() -> ExportDashboard.load$$anonfun$2(etl), Line$.MODULE$.apply(161), FullName$.MODULE$.apply("ambience.developer.ExportDashboard.load"));
            MongoCollection cltn = ExportDashboard$.MODULE$.mongoDB().database().getCollection("ChainSets", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
            Seq reply = (Seq)this.await(org.mongodb.scala.package$.MODULE$.ObservableFuture(() -> ExportDashboard.$anonfun$19(cltn, etl)).toFuture());
            Option option = reply.headOption();
            if (option instanceof Some) {
                Document cs = (Document)((Some)option).value();
                this.zipFile.putNextEntry(new ZipEntry("ChainSets/" + etl.chainset()));
                this.zipFile.write(this.getBytes(cs));
                this.zipFile.closeEntry();
                return LogMessage.None$.MODULE$;
            }
            if (None$.MODULE$.equals(option)) {
                return LogMessage.Error$.MODULE$.apply("Chainset " + etl.chainset() + " not found");
            }
            throw new MatchError((Object)option);
        }
        return LogMessage.None$.MODULE$;
    }

    public byte[] getBytes(Document doc) {
        Either either = io.circe.parser.package$.MODULE$.parse(doc.toJson());
        if (either instanceof Right) {
            Json json = (Json)((Right)either).value();
            return json.spaces2().getBytes("UTF-8");
        }
        if (either instanceof Left) {
            ParsingFailure err = (ParsingFailure)((Left)either).value();
            throw new RuntimeException("Can't parse json from doc: " + doc.toJson() + ": " + err);
        }
        throw new MatchError((Object)either);
    }

    public <T> T await(Future<T> f) {
        return (T)Await$.MODULE$.result(f, (Duration)FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
    }

    private static final Comparable $anonfun$1() {
        return "<Missing Name>";
    }

    private final Object run$$anonfun$1$$anonfun$1(Comparable name$1) {
        return "Finished building " + name$1 + " " + this.tmpFile.getAbsolutePath();
    }

    private final Object run$$anonfun$1$$anonfun$2(Comparable name$2) {
        return "Failed building " + name$2 + " " + this.tmpFile.getAbsolutePath();
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$4() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$5() {
        ExportDashboard$DashboardViewJson$ exportDashboard$DashboardViewJson$ = ExportDashboard$DashboardViewJson$.MODULE$;
        return (Function1 & Serializable)p -> (DashboardViewJson)exportDashboard$DashboardViewJson$.fromProduct((Product)p);
    }

    private static final Product $anonfun$6() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        void var1_3;
        String string = "datasetName";
        String string2 = "subsetName";
        int size = 2;
        Decoder decodeA = Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("DashboardViewJson", ExportDashboard::$anonfun$4, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), ExportDashboard::$anonfun$5, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::$anonfun$6))));
        void var0_4 = var1_3;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_4);
    }

    private static final Function1 $anonfun$7() {
        ExportDashboard$DashboardView$ exportDashboard$DashboardView$ = ExportDashboard$DashboardView$.MODULE$;
        return (Function1 & Serializable)p -> (DashboardView)exportDashboard$DashboardView$.fromProduct((Product)p);
    }

    private static final Product $anonfun$8() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        void var3_4;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        String string = "view";
        boolean size = true;
        Decoder decodeA2 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("DashboardView", ExportDashboard::$anonfun$3, package$.MODULE$.Nil().$colon$colon((Object)string), ExportDashboard::$anonfun$7, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::$anonfun$8)))));
        void var2_5 = var3_4;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_5).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$9() {
        ExportDashboard$DashboardPage$ exportDashboard$DashboardPage$ = ExportDashboard$DashboardPage$.MODULE$;
        return (Function1 & Serializable)p -> (DashboardPage)exportDashboard$DashboardPage$.fromProduct((Product)p);
    }

    private static final Product $anonfun$10() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List run$$anonfun$2() {
        void var1_3;
        String string = "name";
        String string2 = "views";
        int size = 2;
        Decoder decodeA = Decoder$.MODULE$.decodeMap(KeyDecoder$.MODULE$.decodeKeyString(), Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("DashboardPage", ExportDashboard::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), ExportDashboard::$anonfun$9, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(ExportDashboard::$anonfun$10)))));
        void var0_4 = var1_3;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_4);
    }

    private static final Function1 run$$anonfun$3() {
        ExportDashboard$Dashboard$ exportDashboard$Dashboard$ = ExportDashboard$Dashboard$.MODULE$;
        return (Function1 & Serializable)p -> (Dashboard)exportDashboard$Dashboard$.fromProduct((Product)p);
    }

    private static final Product run$$anonfun$4() {
        return Tuple1$.MODULE$.apply((Object)None$.MODULE$);
    }

    private static final Object runViews$$anonfun$1(Set views$1) {
        return "runViews with " + views$1.size() + " views";
    }

    private static final Observable $anonfun$13(MongoCollection datasets$2, String name$3) {
        return datasets$2.find(Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name$3)), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final Object runViewDS$$anonfun$1(Set views$2) {
        return "runViewDS with " + views$2.size() + " views";
    }

    private static final Observable $anonfun$15(MongoCollection datasets$4, String name$4) {
        return datasets$4.find(Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name$4)), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final String $anonfun$17() {
        return "MongoDB";
    }

    /*
     * WARNING - void declaration
     */
    private static final List runDS$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 runDS$$anonfun$2() {
        ExportDashboard$MongoDBDataset$ exportDashboard$MongoDBDataset$ = ExportDashboard$MongoDBDataset$.MODULE$;
        return (Function1 & Serializable)p -> (MongoDBDataset)exportDashboard$MongoDBDataset$.fromProduct((Product)p);
    }

    private static final Product runDS$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List runDS$$anonfun$4() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 runDS$$anonfun$5() {
        ExportDashboard$ETLDataset$ exportDashboard$ETLDataset$ = ExportDashboard$ETLDataset$.MODULE$;
        return (Function1 & Serializable)p -> (ETLDataset)exportDashboard$ETLDataset$.fromProduct((Product)p);
    }

    private static final Product runDS$$anonfun$6() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object load$$anonfun$1(MongoDBDataset mdb$1) {
        return "Loading Collection " + mdb$1.database() + " " + mdb$1.collection();
    }

    private static final Observable $anonfun$18(MongoCollection cltn$1) {
        return cltn$1.find(DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final Object load$$anonfun$2(ETLDataset etl$1) {
        return "Loading Chainset " + etl$1.chainset();
    }

    private static final Observable $anonfun$19(MongoCollection cltn$2, ETLDataset etl$2) {
        return cltn$2.find(Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(etl$2.chainset())), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    public static final class Dashboard
    implements Product,
    Serializable {
        private final Map pages;

        public static Dashboard apply(Map<String, DashboardPage> map) {
            return ExportDashboard$Dashboard$.MODULE$.apply(map);
        }

        public static Dashboard fromProduct(Product product) {
            return ExportDashboard$Dashboard$.MODULE$.fromProduct(product);
        }

        public static Dashboard unapply(Dashboard dashboard) {
            return ExportDashboard$Dashboard$.MODULE$.unapply(dashboard);
        }

        public Dashboard(Map<String, DashboardPage> pages) {
            this.pages = pages;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Dashboard)) return false;
            Dashboard dashboard = (Dashboard)object;
            Map<String, DashboardPage> map = this.pages();
            Map<String, DashboardPage> map2 = dashboard.pages();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Dashboard;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Dashboard";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pages";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<String, DashboardPage> pages() {
            return this.pages;
        }

        public Dashboard copy(Map<String, DashboardPage> pages) {
            return new Dashboard(pages);
        }

        public Map<String, DashboardPage> copy$default$1() {
            return this.pages();
        }

        public Map<String, DashboardPage> _1() {
            return this.pages();
        }
    }

    public static final class DashboardPage
    implements Product,
    Serializable {
        private final String name;
        private final List views;

        public static DashboardPage apply(String string, List<DashboardView> list) {
            return ExportDashboard$DashboardPage$.MODULE$.apply(string, list);
        }

        public static DashboardPage fromProduct(Product product) {
            return ExportDashboard$DashboardPage$.MODULE$.fromProduct(product);
        }

        public static DashboardPage unapply(DashboardPage dashboardPage) {
            return ExportDashboard$DashboardPage$.MODULE$.unapply(dashboardPage);
        }

        public DashboardPage(String name, List<DashboardView> views) {
            this.name = name;
            this.views = views;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DashboardPage)) return false;
            DashboardPage dashboardPage = (DashboardPage)object;
            String string = this.name();
            String string2 = dashboardPage.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            List<DashboardView> list = this.views();
            List<DashboardView> list2 = dashboardPage.views();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DashboardPage;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DashboardPage";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "name";
            }
            if (1 == n2) {
                return "views";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String name() {
            return this.name;
        }

        public List<DashboardView> views() {
            return this.views;
        }

        public DashboardPage copy(String name, List<DashboardView> views) {
            return new DashboardPage(name, views);
        }

        public String copy$default$1() {
            return this.name();
        }

        public List<DashboardView> copy$default$2() {
            return this.views();
        }

        public String _1() {
            return this.name();
        }

        public List<DashboardView> _2() {
            return this.views();
        }
    }

    public static final class DashboardView
    implements Product,
    Serializable {
        private final DashboardViewJson view;

        public static DashboardView apply(DashboardViewJson dashboardViewJson) {
            return ExportDashboard$DashboardView$.MODULE$.apply(dashboardViewJson);
        }

        public static DashboardView fromProduct(Product product) {
            return ExportDashboard$DashboardView$.MODULE$.fromProduct(product);
        }

        public static DashboardView unapply(DashboardView dashboardView) {
            return ExportDashboard$DashboardView$.MODULE$.unapply(dashboardView);
        }

        public DashboardView(DashboardViewJson view) {
            this.view = view;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DashboardView)) return false;
            DashboardView dashboardView = (DashboardView)object;
            DashboardViewJson dashboardViewJson = this.view();
            DashboardViewJson dashboardViewJson2 = dashboardView.view();
            if (dashboardViewJson != null) {
                if (!((Object)dashboardViewJson).equals(dashboardViewJson2)) return false;
                return true;
            }
            if (dashboardViewJson2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DashboardView;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "DashboardView";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "view";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public DashboardViewJson view() {
            return this.view;
        }

        public DashboardView copy(DashboardViewJson view) {
            return new DashboardView(view);
        }

        public DashboardViewJson copy$default$1() {
            return this.view();
        }

        public DashboardViewJson _1() {
            return this.view();
        }
    }

    public static final class DashboardViewJson
    implements Product,
    Serializable {
        private final String datasetName;
        private final String subsetName;

        public static DashboardViewJson apply(String string, String string2) {
            return ExportDashboard$DashboardViewJson$.MODULE$.apply(string, string2);
        }

        public static DashboardViewJson fromProduct(Product product) {
            return ExportDashboard$DashboardViewJson$.MODULE$.fromProduct(product);
        }

        public static DashboardViewJson unapply(DashboardViewJson dashboardViewJson) {
            return ExportDashboard$DashboardViewJson$.MODULE$.unapply(dashboardViewJson);
        }

        public DashboardViewJson(String datasetName, String subsetName) {
            this.datasetName = datasetName;
            this.subsetName = subsetName;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof DashboardViewJson)) return false;
            DashboardViewJson dashboardViewJson = (DashboardViewJson)object;
            String string = this.datasetName();
            String string2 = dashboardViewJson.datasetName();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.subsetName();
            String string4 = dashboardViewJson.subsetName();
            if (string3 == null) {
                if (string4 == null) return true;
                return false;
            } else {
                if (!string3.equals(string4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof DashboardViewJson;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "DashboardViewJson";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "datasetName";
            }
            if (1 == n2) {
                return "subsetName";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String datasetName() {
            return this.datasetName;
        }

        public String subsetName() {
            return this.subsetName;
        }

        public DashboardViewJson copy(String datasetName, String subsetName) {
            return new DashboardViewJson(datasetName, subsetName);
        }

        public String copy$default$1() {
            return this.datasetName();
        }

        public String copy$default$2() {
            return this.subsetName();
        }

        public String _1() {
            return this.datasetName();
        }

        public String _2() {
            return this.subsetName();
        }
    }

    public static interface Dataset {
    }

    public static final class ETLDataset
    implements Dataset,
    Product,
    Serializable {
        private final String datasetType;
        private final String chainset;
        private final String chain;

        public static ETLDataset apply(String string, String string2, String string3) {
            return ExportDashboard$ETLDataset$.MODULE$.apply(string, string2, string3);
        }

        public static ETLDataset fromProduct(Product product) {
            return ExportDashboard$ETLDataset$.MODULE$.fromProduct(product);
        }

        public static ETLDataset unapply(ETLDataset eTLDataset) {
            return ExportDashboard$ETLDataset$.MODULE$.unapply(eTLDataset);
        }

        public ETLDataset(String datasetType, String chainset, String chain) {
            this.datasetType = datasetType;
            this.chainset = chainset;
            this.chain = chain;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ETLDataset)) return false;
            ETLDataset eTLDataset = (ETLDataset)object;
            String string = this.datasetType();
            String string2 = eTLDataset.datasetType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.chainset();
            String string4 = eTLDataset.chainset();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.chain();
            String string6 = eTLDataset.chain();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ETLDataset;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "ETLDataset";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "datasetType";
                }
                case 1: {
                    return "chainset";
                }
                case 2: {
                    return "chain";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String datasetType() {
            return this.datasetType;
        }

        public String chainset() {
            return this.chainset;
        }

        public String chain() {
            return this.chain;
        }

        public ETLDataset copy(String datasetType, String chainset, String chain) {
            return new ETLDataset(datasetType, chainset, chain);
        }

        public String copy$default$1() {
            return this.datasetType();
        }

        public String copy$default$2() {
            return this.chainset();
        }

        public String copy$default$3() {
            return this.chain();
        }

        public String _1() {
            return this.datasetType();
        }

        public String _2() {
            return this.chainset();
        }

        public String _3() {
            return this.chain();
        }
    }

    public static final class MongoDBDataset
    implements Dataset,
    Product,
    Serializable {
        private final String datasetType;
        private final String database;
        private final String collection;

        public static MongoDBDataset apply(String string, String string2, String string3) {
            return ExportDashboard$MongoDBDataset$.MODULE$.apply(string, string2, string3);
        }

        public static MongoDBDataset fromProduct(Product product) {
            return ExportDashboard$MongoDBDataset$.MODULE$.fromProduct(product);
        }

        public static MongoDBDataset unapply(MongoDBDataset mongoDBDataset) {
            return ExportDashboard$MongoDBDataset$.MODULE$.unapply(mongoDBDataset);
        }

        public MongoDBDataset(String datasetType, String database, String collection) {
            this.datasetType = datasetType;
            this.database = database;
            this.collection = collection;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MongoDBDataset)) return false;
            MongoDBDataset mongoDBDataset = (MongoDBDataset)object;
            String string = this.datasetType();
            String string2 = mongoDBDataset.datasetType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.database();
            String string4 = mongoDBDataset.database();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.collection();
            String string6 = mongoDBDataset.collection();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MongoDBDataset;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "MongoDBDataset";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "datasetType";
                }
                case 1: {
                    return "database";
                }
                case 2: {
                    return "collection";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String datasetType() {
            return this.datasetType;
        }

        public String database() {
            return this.database;
        }

        public String collection() {
            return this.collection;
        }

        public MongoDBDataset copy(String datasetType, String database, String collection) {
            return new MongoDBDataset(datasetType, database, collection);
        }

        public String copy$default$1() {
            return this.datasetType();
        }

        public String copy$default$2() {
            return this.database();
        }

        public String copy$default$3() {
            return this.collection();
        }

        public String _1() {
            return this.datasetType();
        }

        public String _2() {
            return this.database();
        }

        public String _3() {
            return this.collection();
        }
    }
}

