/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch;

import com.elixirtech.arch.util.StringStepper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StringUtil {
    public static final String[] EMPTY_ARRAY = new String[0];
    public static final String EMPTY_STRING = "";
    public static final int TEXT_INSET = 0;
    public static final int TAB = 4;

    public static String[] keyAndValue(String string) {
        int n = string.indexOf(61);
        if (n < 0) {
            return new String[]{string, EMPTY_STRING};
        }
        String string2 = string.substring(0, n).trim();
        String string3 = string.substring(n + 1).trim();
        return new String[]{string2, string3};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String load(InputStream inputStream) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return stringWriter.toString();
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final boolean isPositiveIntegerString(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        try {
            return Integer.parseInt(string) > 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static final boolean notEmpty(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static final boolean equal(String string, String string2) {
        if (string != null) {
            return string.equals(string2);
        }
        return string2 == null;
    }

    public static final boolean notEqual(String string, String string2) {
        if (string != null) {
            return !string.equals(string2);
        }
        return string2 != null;
    }

    public static String concat(String[] stringArray, char c) {
        if (stringArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= stringArray.length - 1) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String concat(Collection<String> collection, char c) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String concat(Collection<String> collection, String string) {
        if (collection == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static int count(String string, char c) {
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            ++n;
            n2 = string.indexOf(c, n2 + 1);
        }
        return n;
    }

    public static String normalize(String string) {
        return StringUtil.findAndReplace(string, "\r\n", "\n");
    }

    public static String[] arrayOfSubstrings(String string, char c) {
        List<String> list = StringUtil.listOfSubstrings(string, c);
        String[] stringArray = new String[list.size()];
        list.toArray(stringArray);
        return stringArray;
    }

    public static List<String> listOfSubstrings(String string, char c) {
        int n = 0;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf(c, n)) != -1) {
            String string2 = string.substring(n2, n);
            arrayList.add(string2);
            n2 = ++n;
        }
        if (n2 < string.length()) {
            arrayList.add(string.substring(n2, string.length()));
        }
        return arrayList;
    }

    public static String toString(Map<String, String> map) {
        StringBuilder stringBuilder = new StringBuilder();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
        }
        return stringBuilder.toString();
    }

    public static String toXML(String string) {
        return StringUtil.toXML(string, new char[]{'&', '\'', '>', '<', '\"'}, new String[]{"&amp;", "&apos;", "&gt;", "&lt;", "&quot;"});
    }

    public static String toXML(String string, char[] cArray, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            boolean bl = false;
            for (int j = 0; j < cArray.length; ++j) {
                if (c != cArray[j]) continue;
                stringBuilder.append(stringArray[j]);
                bl = true;
                break;
            }
            if (bl) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String findAndReplace(String string, char c, String string2) {
        return StringUtil.findAndReplace(string, String.valueOf(c), string2);
    }

    public static String findAndReplace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        int n2 = 0;
        while (n2 > -1) {
            n2 = string.indexOf(string2, n);
            if (n2 > -1) {
                stringBuilder.append(string.substring(n, n2)).append(string3);
                n = n2 + string2.length();
                continue;
            }
            stringBuilder.append(string.substring(n, string.length()));
        }
        return stringBuilder.toString();
    }

    public static String findAndReplace(String string, String[] stringArray, String[] stringArray2) {
        String string2 = string;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = StringUtil.findAndReplace(string2, stringArray[i], stringArray2[i]);
        }
        return string2;
    }

    public static String nullTrim(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string;
    }

    public static String unescape(String string) {
        StringReader stringReader = new StringReader(string);
        StringWriter stringWriter = new StringWriter();
        try {
            int n;
            while ((n = stringReader.read()) >= 0) {
                if (n == 92) {
                    n = stringReader.read();
                    if (n == -1) {
                        n = 92;
                    } else if (n == 110) {
                        n = 10;
                    } else if (n == 116) {
                        n = 9;
                    } else if (n == 114) {
                        n = 13;
                    }
                }
                stringWriter.write(n);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("unescape failed on \"" + string + "\"");
        }
        return stringWriter.toString();
    }

    public static final String stripHTMLTags(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringStepper stringStepper = new StringStepper(string);
        while (!stringStepper.atEnd()) {
            char c = stringStepper.getChar().charValue();
            if (c == '<') {
                stringStepper.skipTo(Character.valueOf('>'));
            } else {
                stringBuilder.append(c);
            }
            stringStepper.advance();
        }
        Object object = stringBuilder.toString().trim();
        object = ((String)object).replaceAll("&lt;", "<");
        object = ((String)object).replaceAll("&gt;", ">");
        object = ((String)object).replaceAll("&amp;", "&");
        object = ((String)object).replaceAll("&nbsp;", " ");
        object = ((String)object).replaceAll("Error 403", " ");
        object = ((String)object).replaceAll("HTTP ERROR: 403", EMPTY_STRING);
        if (((String)(object = ((String)object).replaceAll("Powered by Jetty://", EMPTY_STRING))).length() > 400) {
            object = ((String)object).substring(0, 400) + "\n...";
        }
        return ((String)object).trim();
    }
}

