/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.util;

import java.io.CharArrayWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.BitSet;

public class URLUtil {
    static final BitSet DONT_NEED_ENCODING;
    static final int CASE_DIFF = 32;

    public static boolean isURL(String string) {
        return string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:") || string.startsWith("file:") || string.startsWith("repository:") || string.startsWith("resource:") || string.startsWith("data:");
    }

    public static String encodeExcept(String string, String string2) throws UnsupportedEncodingException {
        int n = string2.length();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            if (string.indexOf(c) >= 0) {
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append(URLUtil.doEncode(stringBuilder2.toString()));
                    stringBuilder2.setLength(0);
                }
                stringBuilder.append(c);
                continue;
            }
            stringBuilder2.append(c);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(URLUtil.doEncode(stringBuilder2.toString()));
        }
        return stringBuilder.toString();
    }

    public static String encodePath(String string) {
        if (string == null) {
            return "";
        }
        int n = string.indexOf(63);
        String string2 = n >= 0 ? string.substring(0, n) : string;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            String[] stringArray = string2.split("/");
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuilder.append(URLUtil.doEncode(stringArray[i]));
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append("/");
            }
            if (n >= 0) {
                stringBuilder.append(string.substring(n));
            }
            if (string.endsWith("/")) {
                stringBuilder.append("/");
            }
            return stringBuilder.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    public static String decodePath(String string) {
        if (string == null) {
            return "";
        }
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string;
        }
    }

    private static String doEncode(String string) throws UnsupportedEncodingException {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (DONT_NEED_ENCODING.get(c)) {
                stringBuffer.append(c);
                ++n;
                continue;
            }
            do {
                char c2;
                charArrayWriter.write(c);
                if (c < '\ud800' || c > '\udbff' || n + 1 >= string.length() || (c2 = string.charAt(n + 1)) < '\udc00' || c2 > '\udfff') continue;
                charArrayWriter.write(c2);
                ++n;
            } while (++n < string.length() && !DONT_NEED_ENCODING.get(c = string.charAt(n)));
            charArrayWriter.flush();
            String string2 = new String(charArrayWriter.toCharArray());
            byte[] byArray = string2.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                stringBuffer.append('%');
                char c3 = Character.forDigit(byArray[i] >> 4 & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
                c3 = Character.forDigit(byArray[i] & 0xF, 16);
                if (Character.isLetter(c3)) {
                    c3 = (char)(c3 - 32);
                }
                stringBuffer.append(c3);
            }
            charArrayWriter.reset();
            bl = true;
        }
        return bl ? stringBuffer.toString() : string;
    }

    static {
        int n;
        DONT_NEED_ENCODING = new BitSet(256);
        for (n = 97; n <= 122; ++n) {
            DONT_NEED_ENCODING.set(n);
        }
        for (n = 65; n <= 90; ++n) {
            DONT_NEED_ENCODING.set(n);
        }
        for (n = 48; n <= 57; ++n) {
            DONT_NEED_ENCODING.set(n);
        }
        DONT_NEED_ENCODING.set(45);
        DONT_NEED_ENCODING.set(95);
        DONT_NEED_ENCODING.set(46);
        DONT_NEED_ENCODING.set(42);
    }
}

