/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.awt;

import com.elixirtech.awt.Text;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;

public class TextBlock {
    Font m_Font;
    LineMetrics m_Metrics;
    List<Text> m_TextLines = new ArrayList<Text>();
    int m_Width;
    int m_Height;
    boolean m_WordWrap;
    int m_WrapWidth;
    public static final int CENTERALIGN = 1;
    public static final int TOPALIGN = 2;
    public static final int TOPLEFTALIGN = 3;
    private static final Font STANDARD_FONT = new Font("Serif", 0, 12);
    private static final FontRenderContext FRC = new FontRenderContext(null, false, false);

    public static TextBlock buildTextBlock(String string) {
        TextBlock textBlock = new TextBlock(STANDARD_FONT);
        textBlock.update(string);
        return textBlock;
    }

    public TextBlock() {
        this(STANDARD_FONT);
    }

    public TextBlock(Font font) {
        this.m_Font = font;
        this.m_Metrics = this.m_Font.getLineMetrics("Sample chars", FRC);
    }

    public int stringWidth(String string) {
        return (int)Math.ceil(this.m_Font.getStringBounds(string, FRC).getWidth());
    }

    public int fontHeight() {
        return (int)Math.ceil(this.m_Metrics.getHeight());
    }

    public int fontAscent() {
        return (int)Math.ceil(this.m_Metrics.getAscent());
    }

    public void setWordWrap(boolean bl) {
        this.m_WordWrap = bl;
    }

    public void setWrapWidth(int n) {
        this.m_WrapWidth = n;
    }

    public void update(String string) {
        if (!this.m_WordWrap) {
            this.updatePlain(string);
        } else {
            this.updateWrap(string);
        }
    }

    private void updatePlain(String string) {
        this.m_TextLines = new ArrayList<Text>();
        this.m_Width = 0;
        this.m_Height = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c == '\n') {
                    this.addText(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        this.addText(stringBuffer.toString());
        this.pack();
    }

    private void updateWrap(String string) {
        this.m_TextLines = new ArrayList<Text>();
        this.m_Width = 0;
        this.m_Height = 0;
        int n = 0;
        int n2 = string.length();
        if (n2 > 0) {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, this.m_Font);
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedString.getIterator(), FRC);
            while (lineBreakMeasurer.getPosition() < n2) {
                lineBreakMeasurer.nextLayout(this.m_WrapWidth);
                int n3 = lineBreakMeasurer.getPosition();
                this.addText(string.substring(n, n3));
                n = n3;
            }
        }
        this.pack();
    }

    public void addText(String string) {
        int n = (int)Math.ceil(this.m_Font.getStringBounds(string, FRC).getWidth());
        Text text = new Text(string, n);
        this.m_TextLines.add(text);
        if (n > this.m_Width) {
            this.m_Width = n;
        }
        this.m_Height += (int)Math.ceil(this.m_Metrics.getHeight());
    }

    public void pack() {
        int n = this.m_TextLines.size();
        float f = this.m_Metrics.getAscent();
        for (int i = 0; i < n; ++i) {
            Text text = this.m_TextLines.get(i);
            text.m_StartPoint = new Point((this.m_Width - text.m_Width) / 2, (int)Math.ceil(f));
            f += this.m_Metrics.getHeight();
        }
    }

    public void draw(Graphics graphics, Point point, int n) {
        if (n == 2) {
            this.drawTop(graphics, point);
        } else if (n == 1) {
            this.drawCenter(graphics, point);
        } else if (n == 3) {
            this.drawTopLeft(graphics, point);
        }
    }

    public void drawCenter(Graphics graphics, Point point) {
        graphics.setFont(this.m_Font);
        int n = point.x - this.m_Width / 2;
        int n2 = point.y - this.m_Height / 2;
        int n3 = this.m_TextLines.size();
        for (int i = 0; i < n3; ++i) {
            Text text = this.m_TextLines.get(i);
            if (text.m_Text.length() <= 0) continue;
            graphics.drawString(text.m_Text, n + text.m_StartPoint.x, n2 + text.m_StartPoint.y);
        }
    }

    public void drawTop(Graphics graphics, Point point) {
        graphics.setFont(this.m_Font);
        int n = point.x - this.m_Width / 2;
        int n2 = point.y;
        int n3 = this.m_TextLines.size();
        for (int i = 0; i < n3; ++i) {
            Text text = this.m_TextLines.get(i);
            if (text.m_Text.length() <= 0) continue;
            graphics.drawString(text.m_Text, n + text.m_StartPoint.x, n2 + text.m_StartPoint.y);
        }
    }

    public void drawTopLeft(Graphics graphics, Point point) {
        graphics.setFont(this.m_Font);
        int n = point.x;
        int n2 = point.y;
        int n3 = this.m_TextLines.size();
        for (int i = 0; i < n3; ++i) {
            Text text = this.m_TextLines.get(i);
            if (text.m_Text.length() <= 0) continue;
            graphics.drawString(text.m_Text, n + text.m_StartPoint.x, n2 + text.m_StartPoint.y);
        }
    }

    public RectangleEx getPaintRect(Point point, int n) {
        if (n == 2) {
            return this.getPaintRectTop(point);
        }
        if (n == 1) {
            return this.getPaintRectCenter(point);
        }
        if (n == 3) {
            return this.getPaintRectTopLeft(point);
        }
        return null;
    }

    public RectangleEx getPaintRectCenter(Point point) {
        int n = this.m_Width / 2;
        int n2 = this.m_Height / 2;
        return new RectangleEx(point.x - n, point.y - n2, point.x + n, point.y + n2);
    }

    public RectangleEx getPaintRectTop(Point point) {
        int n = this.m_Width / 2;
        return new RectangleEx(point.x - n, point.y, point.x + n, point.y + this.m_Height);
    }

    public RectangleEx getPaintRectTopLeft(Point point) {
        return new RectangleEx(point.x, point.y, point.x + this.m_Width, point.y + this.m_Height);
    }

    public RectangleEx getOutlineRect(Point point, int n) {
        if (n == 2) {
            return this.getOutlineRectTop(point);
        }
        if (n == 1) {
            return this.getOutlineRectCenter(point);
        }
        if (n == 3) {
            return this.getOutlineRectTopLeft(point);
        }
        return null;
    }

    public RectangleEx getOutlineRectCenter(Point point) {
        int n = this.m_Width / 2;
        int n2 = this.m_Height / 2;
        RectangleEx rectangleEx = new RectangleEx(point.x - n, point.y - n2, point.x + n, point.y + n2);
        rectangleEx.left -= 2;
        rectangleEx.top -= 2;
        rectangleEx.right += 6;
        rectangleEx.bottom += 4;
        return rectangleEx;
    }

    public RectangleEx getOutlineRectTop(Point point) {
        int n = this.m_Width / 2;
        RectangleEx rectangleEx = new RectangleEx(point.x - n, point.y, point.x + n, point.y + this.m_Height);
        rectangleEx.left -= 2;
        rectangleEx.top -= 2;
        rectangleEx.right += 6;
        rectangleEx.bottom += 4;
        return rectangleEx;
    }

    public RectangleEx getOutlineRectTopLeft(Point point) {
        RectangleEx rectangleEx = new RectangleEx(point.x, point.y, point.x + this.m_Width, point.y + this.m_Height);
        rectangleEx.left -= 2;
        rectangleEx.top -= 2;
        rectangleEx.right += 6;
        rectangleEx.bottom += 4;
        return rectangleEx;
    }

    public Dimension getSize() {
        return new Dimension(this.m_Width + 8, this.m_Height + 6);
    }

    public Point getPos(int n) {
        int n2;
        assert (n >= 0);
        int n3 = this.m_TextLines.size();
        int n4 = n;
        for (n2 = 0; n2 < n3; ++n2) {
            int n5 = this.getLine((int)n2).m_Text.length();
            if (n4 <= n5) {
                return new Point(n4, n2);
            }
            n4 -= n5 + 1;
        }
        n2 = this.getLine((int)(n3 - 1)).m_Text.length();
        return new Point(n2, n3 - 1);
    }

    public Text getLine(int n) {
        return this.m_TextLines.get(n);
    }

    public int getNoLines() {
        return this.m_TextLines.size();
    }

    public Dimension getDimension() {
        return new Dimension(this.m_Width, this.m_Height);
    }
}

