/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode.fourstate;

import com.elixirtech.barcode.fourstate.CodeElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RM4SCC {
    private static Map<Character, List<CodeElement>> m_Map;
    private static String CHECKSUM;
    private static CodeElement START;
    private static CodeElement STOP;

    public static List<CodeElement> getCode(String string) {
        String string2 = string.trim();
        ArrayList<CodeElement> arrayList = new ArrayList<CodeElement>();
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            List<CodeElement> list = RM4SCC.getCode(string.charAt(i));
            if (list == null) {
                throw new IllegalArgumentException("Invalid character: " + string.charAt(i) + " in barcode string");
            }
            arrayList.addAll(list);
        }
        arrayList.addAll(RM4SCC.getCode(RM4SCC.calcChecksum(string2)));
        arrayList.add(0, START);
        arrayList.add(STOP);
        return arrayList;
    }

    public static List<CodeElement> getCode(char c) {
        char c2 = Character.toUpperCase(c);
        return m_Map.get(Character.valueOf(c2));
    }

    public static char calcChecksum(String string) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        for (n = 0; n < n4; ++n) {
            int n5 = CHECKSUM.indexOf(string.charAt(n));
            if (n5 < 0) {
                throw new IllegalArgumentException("Invalid character: " + string.charAt(n) + " in barcode string");
            }
            n2 += n5 / 6;
            n3 += n5 % 6;
        }
        n = n2 % 6 * 6 + n3 % 6;
        return CHECKSUM.charAt(n);
    }

    private static List<CodeElement> build(CodeElement ... codeElementArray) {
        return Arrays.asList(codeElementArray);
    }

    static {
        CHECKSUM = "ZUVWXY501234B6789AHCDEFGNIJKLMTOPQRS";
        START = CodeElement.ASC;
        STOP = CodeElement.BAR;
        m_Map = new HashMap<Character, List<CodeElement>>();
        m_Map.put(Character.valueOf('0'), RM4SCC.build(CodeElement.NONE, CodeElement.NONE, CodeElement.BAR, CodeElement.BAR));
        m_Map.put(Character.valueOf('1'), RM4SCC.build(CodeElement.NONE, CodeElement.DESC, CodeElement.ASC, CodeElement.BAR));
        m_Map.put(Character.valueOf('2'), RM4SCC.build(CodeElement.NONE, CodeElement.DESC, CodeElement.BAR, CodeElement.ASC));
        m_Map.put(Character.valueOf('3'), RM4SCC.build(CodeElement.DESC, CodeElement.NONE, CodeElement.ASC, CodeElement.BAR));
        m_Map.put(Character.valueOf('4'), RM4SCC.build(CodeElement.DESC, CodeElement.NONE, CodeElement.BAR, CodeElement.ASC));
        m_Map.put(Character.valueOf('5'), RM4SCC.build(CodeElement.DESC, CodeElement.DESC, CodeElement.ASC, CodeElement.ASC));
        m_Map.put(Character.valueOf('6'), RM4SCC.build(CodeElement.NONE, CodeElement.ASC, CodeElement.DESC, CodeElement.BAR));
        m_Map.put(Character.valueOf('7'), RM4SCC.build(CodeElement.NONE, CodeElement.BAR, CodeElement.NONE, CodeElement.BAR));
        m_Map.put(Character.valueOf('8'), RM4SCC.build(CodeElement.NONE, CodeElement.BAR, CodeElement.DESC, CodeElement.ASC));
        m_Map.put(Character.valueOf('9'), RM4SCC.build(CodeElement.DESC, CodeElement.ASC, CodeElement.NONE, CodeElement.BAR));
        m_Map.put(Character.valueOf('A'), RM4SCC.build(CodeElement.DESC, CodeElement.ASC, CodeElement.DESC, CodeElement.ASC));
        m_Map.put(Character.valueOf('B'), RM4SCC.build(CodeElement.DESC, CodeElement.BAR, CodeElement.NONE, CodeElement.ASC));
        m_Map.put(Character.valueOf('C'), RM4SCC.build(CodeElement.NONE, CodeElement.ASC, CodeElement.BAR, CodeElement.DESC));
        m_Map.put(Character.valueOf('D'), RM4SCC.build(CodeElement.NONE, CodeElement.BAR, CodeElement.ASC, CodeElement.DESC));
        m_Map.put(Character.valueOf('E'), RM4SCC.build(CodeElement.NONE, CodeElement.BAR, CodeElement.BAR, CodeElement.NONE));
        m_Map.put(Character.valueOf('F'), RM4SCC.build(CodeElement.DESC, CodeElement.ASC, CodeElement.ASC, CodeElement.DESC));
        m_Map.put(Character.valueOf('G'), RM4SCC.build(CodeElement.DESC, CodeElement.ASC, CodeElement.BAR, CodeElement.NONE));
        m_Map.put(Character.valueOf('H'), RM4SCC.build(CodeElement.DESC, CodeElement.BAR, CodeElement.ASC, CodeElement.NONE));
        m_Map.put(Character.valueOf('I'), RM4SCC.build(CodeElement.ASC, CodeElement.NONE, CodeElement.DESC, CodeElement.BAR));
        m_Map.put(Character.valueOf('J'), RM4SCC.build(CodeElement.ASC, CodeElement.DESC, CodeElement.NONE, CodeElement.BAR));
        m_Map.put(Character.valueOf('K'), RM4SCC.build(CodeElement.ASC, CodeElement.DESC, CodeElement.DESC, CodeElement.ASC));
        m_Map.put(Character.valueOf('L'), RM4SCC.build(CodeElement.BAR, CodeElement.NONE, CodeElement.NONE, CodeElement.BAR));
        m_Map.put(Character.valueOf('M'), RM4SCC.build(CodeElement.BAR, CodeElement.NONE, CodeElement.DESC, CodeElement.ASC));
        m_Map.put(Character.valueOf('N'), RM4SCC.build(CodeElement.BAR, CodeElement.DESC, CodeElement.NONE, CodeElement.ASC));
        m_Map.put(Character.valueOf('O'), RM4SCC.build(CodeElement.ASC, CodeElement.NONE, CodeElement.BAR, CodeElement.DESC));
        m_Map.put(Character.valueOf('P'), RM4SCC.build(CodeElement.ASC, CodeElement.DESC, CodeElement.ASC, CodeElement.DESC));
        m_Map.put(Character.valueOf('Q'), RM4SCC.build(CodeElement.ASC, CodeElement.DESC, CodeElement.BAR, CodeElement.NONE));
        m_Map.put(Character.valueOf('R'), RM4SCC.build(CodeElement.BAR, CodeElement.NONE, CodeElement.ASC, CodeElement.DESC));
        m_Map.put(Character.valueOf('S'), RM4SCC.build(CodeElement.BAR, CodeElement.NONE, CodeElement.BAR, CodeElement.NONE));
        m_Map.put(Character.valueOf('T'), RM4SCC.build(CodeElement.BAR, CodeElement.DESC, CodeElement.ASC, CodeElement.NONE));
        m_Map.put(Character.valueOf('U'), RM4SCC.build(CodeElement.ASC, CodeElement.ASC, CodeElement.DESC, CodeElement.DESC));
        m_Map.put(Character.valueOf('V'), RM4SCC.build(CodeElement.ASC, CodeElement.BAR, CodeElement.NONE, CodeElement.DESC));
        m_Map.put(Character.valueOf('W'), RM4SCC.build(CodeElement.ASC, CodeElement.BAR, CodeElement.DESC, CodeElement.NONE));
        m_Map.put(Character.valueOf('X'), RM4SCC.build(CodeElement.BAR, CodeElement.ASC, CodeElement.NONE, CodeElement.DESC));
        m_Map.put(Character.valueOf('Y'), RM4SCC.build(CodeElement.BAR, CodeElement.ASC, CodeElement.DESC, CodeElement.NONE));
        m_Map.put(Character.valueOf('Z'), RM4SCC.build(CodeElement.BAR, CodeElement.BAR, CodeElement.NONE, CodeElement.NONE));
    }
}

