/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.graph;

import com.elixirtech.awt.PropertyPanel;
import com.elixirtech.canvas.graph.GraphVisitor;
import com.elixirtech.canvas.graph.ObjectEx;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import com.elixirtech.canvas.graph.Relationship;
import com.elixirtech.canvas.graph.TempRelCol;
import com.elixirtech.jdom.Element;
import com.elixirtech.storage.StorageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Node
extends ObjectEx {
    private List<Relationship> m_In;
    private List<Relationship> m_Out;
    private boolean m_IsConnected = true;
    private static final long serialVersionUID = 1L;

    public void writeXMLAnnotations(Element element) {
    }

    public void readXMLAnnotations(Element element) {
    }

    public Node getParent() {
        Relationship relationship = this.getInRelationship(RelType.Owns);
        if (relationship == null) {
            return null;
        }
        return relationship.getOrigin();
    }

    public void fireStructureChanged() {
    }

    public void initProperties() {
    }

    public String getId() {
        return "Node.getId: Not yet implemented";
    }

    public void buildPropertyPages(List<PropertyPanel> list) {
    }

    public final Node[] getChildArray() {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        Node[] nodeArray = new Node[relCol.getCount()];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = relCol.getItem(i).getDestination();
        }
        return nodeArray;
    }

    public void addInwardEdge(Relationship relationship) {
        assert (relationship.getDestination() == this);
        if (this.m_In == null) {
            this.buildIn();
        }
        if (!this.m_In.contains(relationship)) {
            this.m_In.add(relationship);
        }
    }

    public void addOutwardEdge(Relationship relationship) {
        assert (relationship.getOrigin() == this);
        if (this.m_Out == null) {
            this.buildOut();
        }
        if (!this.m_Out.contains(relationship)) {
            this.m_Out.add(relationship);
        }
        if (relationship.getRelType() == RelType.Owns) {
            this.fireStructureChanged();
        }
    }

    public void removeInwardEdge(Relationship relationship) {
        assert (this.m_In != null);
        this.m_In.remove(relationship);
    }

    public void removeOutwardEdge(Relationship relationship) {
        assert (this.m_Out != null);
        this.m_Out.remove(relationship);
        if (relationship.getRelType() == RelType.Owns) {
            this.fireStructureChanged();
        }
    }

    public Relationship connectTo(Node node, RelType relType) {
        Relationship relationship = new Relationship(relType, this, node);
        relationship.assertRel();
        return relationship;
    }

    public void disconnect() {
        this.m_IsConnected = false;
        StorageManager.current().unbind(this);
        for (Relationship relationship : this.getInRelationships()) {
            relationship.disconnectSource();
        }
        for (Relationship relationship : this.getOutRelationships()) {
            relationship.disconnectDestination();
        }
    }

    public void reconnect() {
        assert (!this.m_IsConnected);
        this.m_IsConnected = true;
        StorageManager.current().bind(this);
        for (Relationship relationship : this.getInRelationships()) {
            relationship.connectSource();
        }
        for (Relationship relationship : this.getOutRelationships()) {
            relationship.connectDestination();
        }
    }

    public boolean isConnected() {
        return this.m_IsConnected;
    }

    public void delete() {
        HashSet<Node> hashSet = new HashSet<Node>();
        this.delete(hashSet);
        StorageManager.current().unbind(Collections.enumeration(hashSet));
    }

    public void buildDeleteSet(Set<Node> set) {
        if (set.contains(this)) {
            return;
        }
        set.add(this);
        for (Relationship relationship : this.getOutRelationships()) {
            if (!relationship.getRelType().cascadesDelete()) continue;
            relationship.getDestination().buildDeleteSet(set);
        }
    }

    public void delete(Collection<Node> collection) {
        if (!collection.contains(this)) {
            collection.add(this);
            for (Relationship relationship : this.getInRelationships()) {
                relationship.destinationDeleted(collection);
            }
            for (Relationship relationship : this.getOutRelationships()) {
                relationship.originDeleted(collection);
            }
            if (this.m_In != null) {
                this.m_In.clear();
            }
            if (this.m_Out != null) {
                this.m_Out.clear();
            }
            this.m_IsConnected = false;
        }
    }

    public boolean hasReferences() {
        if (this.m_In != null && this.m_In.size() > 0) {
            return true;
        }
        return this.m_Out != null && this.m_Out.size() > 0;
    }

    public RelCol getInRelCol(RelType relType) {
        return new TempRelCol(relType, this.m_In, false);
    }

    public RelCol getOutRelCol(RelType relType) {
        return new TempRelCol(relType, this.m_Out, true);
    }

    public List<Relationship> getInRelationships() {
        if (this.m_In == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_In);
    }

    public List<Relationship> getOutRelationships() {
        if (this.m_Out == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_Out);
    }

    public void removeInRelationships(RelType relType) {
        for (Relationship relationship : this.getInRelCol(relType).elements()) {
            relationship.remove();
        }
    }

    public void removeOutRelationships(RelType relType) {
        for (Relationship relationship : this.getOutRelCol(relType).elements()) {
            relationship.remove();
        }
        if (relType == RelType.Owns) {
            this.fireStructureChanged();
        }
    }

    public boolean references(Node node) {
        for (Relationship relationship : this.getInRelationships()) {
            if (relationship.getOrigin() != node) continue;
            return true;
        }
        for (Relationship relationship : this.getOutRelationships()) {
            if (relationship.getDestination() != node) continue;
            return true;
        }
        return false;
    }

    public void setParent(Node node) {
        Relationship relationship = this.getInRelationship(RelType.Owns);
        if (relationship != null) {
            relationship.remove();
        }
        if (node != null) {
            node.connectTo(this, RelType.Owns);
        }
        this.changed("Parent");
    }

    @Override
    protected void update(String string) {
        RelCol relCol = this.getOutRelCol(RelType.IsViewedBy);
        for (Node node : relCol.getTargetElements()) {
            node.update(string);
        }
    }

    public void accept(GraphVisitor graphVisitor) {
        boolean bl;
        if (!graphVisitor.visitedNode(this) && (bl = graphVisitor.visitNode(this))) {
            for (Relationship relationship : this.getInRelationships()) {
                relationship.accept(graphVisitor);
            }
            for (Relationship relationship : this.getOutRelationships()) {
                relationship.accept(graphVisitor);
            }
        }
    }

    public boolean canBeParentOf(Node node) {
        for (Node node2 = this; node2 != null; node2 = node2.getParent()) {
            if (node2 != node) continue;
            return false;
        }
        return true;
    }

    public Relationship getInRelationship(RelType relType) {
        for (Relationship relationship : this.getInRelationships()) {
            if (!relationship.getRelType().equals(relType)) continue;
            return relationship;
        }
        return null;
    }

    public Relationship getOutRelationship(RelType relType) {
        for (Relationship relationship : this.getOutRelationships()) {
            if (!relationship.getRelType().equals(relType)) continue;
            return relationship;
        }
        return null;
    }

    public void showProperties() {
    }

    private void buildIn() {
        this.m_In = new ArrayList<Relationship>();
    }

    private void buildOut() {
        this.m_Out = new ArrayList<Relationship>();
    }
}

