/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;

public class LimnColumnValues {
    private LimnPlot m_Plot;
    private ChartWorld m_World;
    private DatasetHolder m_DatasetHolder;
    private CategoryDataset m_Dataset;
    private ShadedColor[] m_Paints;

    public LimnColumnValues(LimnPlot limnPlot, ChartWorld chartWorld, DatasetHolder datasetHolder) {
        this.m_Plot = limnPlot;
        this.m_World = chartWorld;
        this.m_DatasetHolder = datasetHolder;
        this.m_Dataset = (CategoryDataset)this.m_DatasetHolder.getDataset();
        int n = this.m_Dataset.getRowCount();
        this.m_Paints = this.m_Plot.getPaints(n);
        for (int i = 0; i < n; ++i) {
            this.buildRow(i);
        }
    }

    private void buildRow(int n) {
        Comparable comparable = this.m_Dataset.getRowKey(n);
        List list = this.m_Dataset.getColumnKeys();
        Iterator iterator = list.iterator();
        int n2 = 0;
        IAxisValues iAxisValues = this.m_World.getBottomLeftAxisValues();
        IAxisValues iAxisValues2 = this.m_World.getLeftAxisValues();
        IAxisValues iAxisValues3 = this.m_World.getBottomRightAxisValues();
        double d = iAxisValues3.getLocation(comparable);
        int n3 = (int)(d * 200.0);
        int n4 = (int)(iAxisValues3.getStepSize() * 200.0);
        int n5 = (int)(iAxisValues.getStepSize() * 200.0);
        String string = "v." + n + ".";
        while (iterator.hasNext()) {
            Comparable comparable2 = (Comparable)iterator.next();
            int n6 = (int)(iAxisValues.getLocation(comparable2) * 200.0);
            try {
                Number number = this.m_Dataset.getValue(comparable, comparable2);
                double d2 = number == null ? 0.0 : iAxisValues2.getLocation(number) * 200.0;
                this.buildColumnValues(string + n2, d2, n6, n5, n3, n4, this.m_Paints[n]);
            }
            catch (UnknownKeyException unknownKeyException) {}
        }
    }

    public void buildColumnValues(String string, double d, int n, int n2, int n3, int n4, ShadedColor shadedColor) {
        Polyhedron polyhedron = LimnColumnValues.buildValue(d, n4, n4 / 5, n, n2, n2 / 5, shadedColor);
        Value value = new Value(this.m_World, new Point3d(0.0, 0.0, n3), new Angle3d(), polyhedron);
        value.setId(string);
    }

    public static Polyhedron buildValue(double d, int n, int n2, int n3, int n4, int n5, ShadedColor shadedColor) {
        int n6 = 8;
        double d2 = (double)n / 2.0;
        double[] dArray = new double[n6];
        double[] dArray2 = new double[n6];
        double[] dArray3 = new double[n6];
        dArray[2] = dArray[3] = (double)(n3 - n4 / 2 + n5);
        dArray[1] = dArray[3];
        dArray[0] = dArray[3];
        dArray[6] = dArray[7] = (double)(n3 + n4 / 2 - n5);
        dArray[5] = dArray[7];
        dArray[4] = dArray[7];
        dArray2[0] = 0.0;
        dArray2[1] = d;
        dArray2[2] = d;
        dArray2[3] = 0.0;
        dArray2[4] = 0.0;
        dArray2[5] = d;
        dArray2[6] = d;
        dArray2[7] = 0.0;
        double d3 = d2 - (double)n2;
        double d4 = -d2 + (double)n2;
        dArray3[0] = d3;
        dArray3[1] = d3;
        dArray3[2] = d4;
        dArray3[3] = d4;
        dArray3[4] = d3;
        dArray3[5] = d3;
        dArray3[6] = d4;
        dArray3[7] = d4;
        ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, n6);
        int n7 = 6;
        IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[n7];
        indexingPolygonArray[0] = new RenderedPolygon(new int[]{0, 1, 5, 4}, shadedColor);
        indexingPolygonArray[1] = new RenderedPolygon(new int[]{1, 2, 6, 5}, shadedColor);
        indexingPolygonArray[2] = new RenderedPolygon(new int[]{2, 3, 7, 6}, shadedColor);
        indexingPolygonArray[3] = new RenderedPolygon(new int[]{3, 0, 4, 7}, shadedColor);
        indexingPolygonArray[4] = new RenderedPolygon(new int[]{2, 1, 0, 3}, shadedColor);
        indexingPolygonArray[5] = new RenderedPolygon(new int[]{4, 5, 6, 7}, shadedColor);
        Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
        return polyhedron;
    }

    private static class Value
    extends Object3d {
        public Value(World world, Point3d point3d, Angle3d angle3d, Polyhedron polyhedron) {
            super(world, point3d, angle3d);
            this.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
        }
    }
}

