/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.chart2.LimnDrawingSupplier;
import com.elixirtech.chart2.data.ScatterDataset;
import com.elixirtech.chart2.data.ScatterSeries;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.Scatter3dType;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.Camera;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.chart.BaseAxisOverlay;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import com.elixirtech.limn.chart.LeftAxisOverlay;
import com.elixirtech.limn.chart.NumberAxisValues;
import com.elixirtech.limn.chart.RightAxisOverlay;
import com.elixirtech.limn.chart.StringAxisValues;
import com.elixirtech.ui.StandardColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;

public class LimnPlotJ
extends Plot {
    public static final Angle3d DEFAULT_CAMERA_ANGLE = new Angle3d(0.3490658503988659, 0.5235987755982988, 0.0);
    private Chart m_Chart;
    private DatasetHolder m_DatasetHolder;
    private Category3dUi m_UI;
    private ShadedColor[] m_Paints;
    private boolean m_XIsNumeric = true;
    private boolean m_ZIsNumeric = true;
    private Point m_FirstYTickLabelOffset = new Point(-3, -3);
    private Angle3d m_CameraAngle = DEFAULT_CAMERA_ANGLE;
    private static Color[] DEFAULT_PAINT_COLORS = new Color[]{new Color(150, 150, 220, 128), new Color(150, 220, 150, 128), new Color(220, 150, 150, 128), new Color(150, 220, 220, 128), new Color(220, 220, 150, 128), new Color(220, 150, 220, 128)};

    public LimnPlotJ(Chart chart, DatasetHolder datasetHolder) {
        this.m_Chart = chart;
        this.m_DatasetHolder = datasetHolder;
        ChartType chartType = this.m_Chart.getChartType();
        this.m_UI = chartType instanceof Scatter3dType ? ((Scatter3dType)chartType).getCategory3dUi() : ((Category3dType)chartType).getCategory3dUi();
        this.setDrawingSupplier(new LimnDrawingSupplier(DEFAULT_PAINT_COLORS));
    }

    public void setCameraAngle(Angle3d angle3d) {
        this.m_CameraAngle = angle3d.makeClone();
    }

    public Angle3d getCameraAngle() {
        return this.m_CameraAngle.makeClone();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        ChartWorld chartWorld = this.createWorld();
        this.createValues(chartWorld);
        int n = 100;
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getHeight();
        Point3d point3d = new Point3d(0.0, 0.0, n);
        Camera camera = new Camera(chartWorld, 1.0471975511965976, point3d, this.m_CameraAngle);
        camera.setScreenSize((int)d, (int)d2);
        camera.updateMatrix();
        Rectangle2D rectangle2D2 = camera.getBoundingBox();
        while (rectangle2D2.getWidth() > d) {
            point3d.z = n += 20;
            camera.setOrientation(point3d, this.m_CameraAngle);
            camera.updateMatrix();
            rectangle2D2 = camera.getBoundingBox();
        }
        while (rectangle2D2.getHeight() > d2) {
            point3d.z = n += 20;
            camera.setOrientation(point3d, this.m_CameraAngle);
            camera.updateMatrix();
            rectangle2D2 = camera.getBoundingBox();
        }
        double d3 = rectangle2D.getX() - rectangle2D2.getX() + (d - rectangle2D2.getWidth()) / 2.0;
        double d4 = rectangle2D.getY() - rectangle2D2.getY() + (d2 - rectangle2D2.getHeight()) / 2.0;
        graphics2D.translate(d3, d4);
        camera.paint(graphics2D);
    }

    public ShadedColor[] getPaints(int n) {
        if (this.m_Paints != null && this.m_Paints.length == n) {
            return this.m_Paints;
        }
        this.m_Paints = new ShadedColor[n];
        for (int i = 0; i < n; ++i) {
            Paint paint = this.getDrawingSupplier().getNextPaint();
            if (paint instanceof Color) {
                Color color = (Color)paint;
                this.m_Paints[i] = new ShadedColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
                continue;
            }
            this.m_Paints[i] = new ShadedColor(Color.white);
        }
        return this.m_Paints;
    }

    public Point getFirstYTickLabelOffset() {
        return new Point(this.m_FirstYTickLabelOffset.x, this.m_FirstYTickLabelOffset.y);
    }

    public void setFirstYTickLabelOffset(int n, int n2) {
        this.m_FirstYTickLabelOffset = new Point(n, n2);
    }

    public LegendItemCollection getLegendItems() {
        if ("3D-Surface".equals(this.m_Chart.getType())) {
            return this.getYLegendItems();
        }
        if ("3D-Scatter".equals(this.m_Chart.getType())) {
            return this.getScatterLegendItems();
        }
        return this.getZLegendItems();
    }

    public LegendItemCollection getScatterLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        ScatterDataset scatterDataset = (ScatterDataset)this.m_DatasetHolder.getDataset();
        int n = scatterDataset.getKeyCount();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        ShadedColor[] shadedColorArray = this.getPaints(n);
        for (int i = n - 1; i >= 0; --i) {
            ScatterSeries scatterSeries = scatterDataset.getKey(i);
            String string = String.valueOf(scatterSeries.key());
            Color color = shadedColorArray[i].getColor();
            if (color.getAlpha() != 255) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            legendItemCollection.add(new LegendItem(string, null, null, null, AbstractRenderer.DEFAULT_SHAPE, (Paint)color, (Stroke)basicStroke, (Paint)Color.black));
        }
        return legendItemCollection;
    }

    public LegendItemCollection getYLegendItems() {
        String string;
        int n;
        CategoryDataset categoryDataset = (CategoryDataset)this.m_DatasetHolder.getDataset();
        int n2 = categoryDataset.getColumnCount();
        int n3 = categoryDataset.getRowCount();
        Comparable[] comparableArray = new Comparable[n2];
        Comparable[] comparableArray2 = new Comparable[n3];
        Object[] objectArray = new Object[n2 * n3];
        for (int i = 0; i < n2; ++i) {
            comparableArray[i] = categoryDataset.getColumnKey(i);
            for (n = 0; n < n3; ++n) {
                comparableArray2[n] = categoryDataset.getRowKey(n);
                objectArray[i * n3 + n] = categoryDataset.getValue(n, i);
            }
        }
        NumberAxisValues numberAxisValues = this.buildNumberAxisValues(objectArray, this.m_UI.getYAxis(), true, true, this.isPadY());
        n = numberAxisValues.getPositionCount();
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        ShadedColor[] shadedColorArray = this.getPaints(n);
        ArrayList<LegendItem> arrayList = new ArrayList<LegendItem>();
        for (int i = 0; i < n - 2; ++i) {
            string = numberAxisValues.getPosition((int)i).label;
            String string2 = numberAxisValues.getPosition((int)(i + 1)).label;
            String string3 = string + "-" + (String)string2;
            Color color = shadedColorArray[i].getColor();
            if (color.getAlpha() != 255) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            arrayList.add(new LegendItem(string3, null, null, null, AbstractRenderer.DEFAULT_SHAPE, (Paint)color, (Stroke)basicStroke, (Paint)Color.black));
        }
        Legend legend = this.m_Chart.getChartType().getLegend();
        string = legend.getAnchor();
        if (string.equals("East") || string.equals("West")) {
            Collections.reverse(arrayList);
        }
        for (LegendItem legendItem : arrayList) {
            legendItemCollection.add(legendItem);
        }
        return legendItemCollection;
    }

    public LegendItemCollection getZLegendItems() {
        Format format;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        Tick tick = this.m_UI.getZAxis().getTick();
        NumberFormat numberFormat = null;
        if (this.m_ZIsNumeric) {
            format = (Format)tick.getFormat();
            numberFormat = Formatter.buildNumberFormatter(format, this.getLocale(format));
        }
        format = (CategoryDataset)this.m_DatasetHolder.getDataset();
        int n = format.getRowCount();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        ShadedColor[] shadedColorArray = this.getPaints(n);
        for (int i = n - 1; i >= 0; --i) {
            Comparable comparable = format.getRowKey(i);
            String string = numberFormat != null ? numberFormat.format(comparable) : String.valueOf(comparable);
            Color color = shadedColorArray[i].getColor();
            if (color.getAlpha() != 255) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue());
            }
            legendItemCollection.add(new LegendItem(string, null, null, null, AbstractRenderer.DEFAULT_SHAPE, (Paint)color, (Stroke)basicStroke, (Paint)Color.black));
        }
        return legendItemCollection;
    }

    private ChartWorld createWorld() {
        Object object;
        Object[] objectArray = new Object[]{};
        Object[] objectArray2 = new Comparable[]{};
        Object[] objectArray3 = new Comparable[]{};
        Dataset dataset = this.m_DatasetHolder.getDataset();
        if (dataset instanceof CategoryDataset) {
            object = (CategoryDataset)dataset;
            int n = object.getColumnCount();
            int n2 = object.getRowCount();
            this.m_XIsNumeric = true;
            this.m_ZIsNumeric = true;
            objectArray2 = new Comparable[n];
            objectArray3 = new Comparable[n2];
            objectArray = new Object[n * n2];
            for (int i = 0; i < n; ++i) {
                objectArray2[i] = object.getColumnKey(i);
                if (this.m_XIsNumeric && !(objectArray2[i] instanceof Number)) {
                    this.m_XIsNumeric = false;
                }
                for (int j = 0; j < n2; ++j) {
                    objectArray3[j] = object.getRowKey(j);
                    if (this.m_ZIsNumeric && !(objectArray3[j] instanceof Number)) {
                        this.m_ZIsNumeric = false;
                    }
                    objectArray[i * n2 + j] = object.getValue(j, i);
                }
            }
        } else if (dataset instanceof ScatterDataset) {
            object = (ScatterDataset)dataset;
            this.m_XIsNumeric = true;
            this.m_ZIsNumeric = true;
            objectArray2 = ((ScatterDataset)object).getXValues();
            objectArray3 = ((ScatterDataset)object).getZValues();
            objectArray = ((ScatterDataset)object).getYValues();
        }
        object = this.buildNumberAxisValues(objectArray, this.m_UI.getYAxis(), true, true, this.isPadY());
        NumberAxisValues numberAxisValues = ((NumberAxisValues)object).makeClone();
        if (this.m_CameraAngle.y > 0.0) {
            numberAxisValues.setShowAxis(false);
        } else {
            ((NumberAxisValues)object).setShowAxis(false);
        }
        StringAxisValues stringAxisValues = this.m_XIsNumeric ? this.buildNumberAxisValues(objectArray2, this.m_UI.getXAxis(), false, true, this.isPadX()) : this.buildStringAxisValues(objectArray2, this.m_UI.getXAxis(), true);
        StringAxisValues stringAxisValues2 = this.m_ZIsNumeric ? this.buildNumberAxisValues(objectArray3, this.m_UI.getZAxis(), false, true, this.isPadZ()) : this.buildStringAxisValues(objectArray3, this.m_UI.getZAxis(), true);
        ChartWorld chartWorld = new ChartWorld((IAxisValues)object, numberAxisValues, stringAxisValues, stringAxisValues2);
        Paint paint = this.getBackgroundPaint();
        if (paint instanceof Color) {
            chartWorld.setAxesColor((Color)paint);
        }
        chartWorld.build();
        Color color = Color.GRAY;
        Tick tick = this.m_UI.getYAxis().getTick();
        Font font = tick.getFont();
        Label label = this.m_UI.getYAxis().getLabel();
        Font font2 = label.getFont();
        LeftAxisOverlay leftAxisOverlay = chartWorld.getLeftAxisOverlay();
        leftAxisOverlay.setTickUi(color, StandardColor.lookup(font.getFontColor()), font.getAWTFont());
        leftAxisOverlay.setLabelUi(label.getText(), StandardColor.lookup(font2.getFontColor()), font2.getAWTFont());
        if (this.m_XIsNumeric) {
            leftAxisOverlay.setFirstTickLabelOffset(this.m_FirstYTickLabelOffset);
        }
        RightAxisOverlay rightAxisOverlay = chartWorld.getRightAxisOverlay();
        rightAxisOverlay.setTickUi(color, StandardColor.lookup(font.getFontColor()), font.getAWTFont());
        rightAxisOverlay.setLabelUi(label.getText(), StandardColor.lookup(font2.getFontColor()), font2.getAWTFont());
        Tick tick2 = this.m_UI.getXAxis().getTick();
        Font font3 = tick2.getFont();
        Label label2 = this.m_UI.getXAxis().getLabel();
        Font font4 = label2.getFont();
        Tick tick3 = this.m_UI.getZAxis().getTick();
        Font font5 = tick3.getFont();
        Label label3 = this.m_UI.getZAxis().getLabel();
        Font font6 = label3.getFont();
        BaseAxisOverlay baseAxisOverlay = chartWorld.getBaseAxisOverlay();
        baseAxisOverlay.setLeftTickUi(color, StandardColor.lookup(font3.getFontColor()), font3.getAWTFont());
        baseAxisOverlay.setLeftLabelUi(label2.getText(), StandardColor.lookup(font4.getFontColor()), font4.getAWTFont());
        baseAxisOverlay.setRightTickUi(color, StandardColor.lookup(font5.getFontColor()), font5.getAWTFont());
        baseAxisOverlay.setRightLabelUi(label3.getText(), StandardColor.lookup(font6.getFontColor()), font6.getAWTFont());
        return chartWorld;
    }

    private NumberAxisValues buildNumberAxisValues(Object[] objectArray, Axis axis, boolean bl, boolean bl2, boolean bl3) {
        bl2 = axis.getTick().isTickMarkVisible() && bl2;
        NumberAxisValues numberAxisValues = new NumberAxisValues(objectArray, bl, bl2);
        Format format = (Format)axis.getTick().getFormat();
        NumberFormat numberFormat = Formatter.buildNumberFormatter(format, this.getLocale(format));
        numberAxisValues.setFormat(numberFormat);
        if (bl3) {
            numberAxisValues.setPaddingPercent(8);
        }
        return numberAxisValues;
    }

    private StringAxisValues buildStringAxisValues(Object[] objectArray, Axis axis, boolean bl) {
        bl = axis.getTick().isTickMarkVisible() && bl;
        StringAxisValues stringAxisValues = new StringAxisValues(objectArray, false, bl);
        return stringAxisValues;
    }

    private boolean isPadX() {
        String string = this.m_Chart.getType();
        return "3D-Column".equals(string);
    }

    private boolean isPadY() {
        String string = this.m_Chart.getType();
        return "3D-Line".equals(string);
    }

    private boolean isPadZ() {
        return true;
    }

    private void createValues(ChartWorld chartWorld) {
        throw new RuntimeException("Code commented out");
    }

    private Locale getLocale(Format format) {
        Locale locale;
        Locale locale2 = locale = format != null ? format.getLocale() : null;
        if (locale == null) {
            locale = this.m_Chart.getLocale();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public String getPlotType() {
        return "LimnPlot";
    }
}

