/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.custom;

import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.StandardPaint;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;

public class CustomDrawingSupplier
implements DrawingSupplier {
    private DefaultDrawingSupplier m_Default = new DefaultDrawingSupplier();
    private Paint[] m_Paints;
    private int m_PaintIdx;
    private Paint[] m_OutlinePaints;
    private int m_OutlinePaintIdx;
    private Stroke[] m_Strokes;
    private int m_StrokeIdx;
    private Stroke[] m_OutlineStrokes;
    private int m_OutlineStrokeIdx;
    private Shape[] m_Shapes;
    private int m_ShapeIdx;

    public void setPaints(String[] stringArray, String[] stringArray2) {
        this.m_OutlinePaints = new Paint[stringArray.length];
        this.m_Paints = new Paint[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Paint paint = StandardPaint.lookup(string);
            String string2 = stringArray2[i];
            if (string2 == null || "None".equals(string2)) {
                Color color = StandardColor.lookup(stringArray[i]);
                this.m_Paints[i] = color;
                this.m_OutlinePaints[i] = color;
                continue;
            }
            this.m_Paints[i] = StandardPaint.lookup(stringArray2[i]);
            this.m_OutlinePaints[i] = paint;
        }
    }

    public void setPaintNames(String[] stringArray) {
        this.m_Paints = new Paint[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_Paints[i] = StandardPaint.lookup(stringArray[i]);
        }
    }

    public void setPaints(Paint[] paintArray) {
        this.m_Paints = paintArray;
    }

    public void setOutlinePaintNames(String[] stringArray) {
        this.m_OutlinePaints = new Paint[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.m_OutlinePaints[i] = StandardColor.lookup(stringArray[i]);
        }
    }

    public void setOutlinePaints(Paint[] paintArray) {
        this.m_OutlinePaints = paintArray;
    }

    public void setStrokes(Stroke[] strokeArray) {
        this.m_Strokes = strokeArray;
    }

    public void setOutlineStrokes(Stroke[] strokeArray) {
        this.m_OutlineStrokes = strokeArray;
    }

    public void setShapes(Shape[] shapeArray) {
        this.m_Shapes = shapeArray;
    }

    public Paint getNextPaint() {
        if (this.m_Paints == null) {
            return this.m_Default.getNextPaint();
        }
        if (this.m_Paints.length <= 0) {
            return Color.BLACK;
        }
        return this.m_Paints[this.m_PaintIdx++ % this.m_Paints.length];
    }

    public Paint getNextFillPaint() {
        if (this.m_Paints == null) {
            return this.m_Default.getNextPaint();
        }
        return this.m_Paints[this.m_PaintIdx++ % this.m_Paints.length];
    }

    public Paint getNextOutlinePaint() {
        if (this.m_OutlinePaints == null) {
            return this.m_Default.getNextOutlinePaint();
        }
        return this.m_OutlinePaints[this.m_OutlinePaintIdx++ % this.m_OutlinePaints.length];
    }

    public Stroke getNextStroke() {
        if (this.m_Strokes == null) {
            return this.m_Default.getNextStroke();
        }
        return this.m_Strokes[this.m_StrokeIdx++ % this.m_Strokes.length];
    }

    public Stroke getNextOutlineStroke() {
        if (this.m_OutlineStrokes == null) {
            return this.m_Default.getNextOutlineStroke();
        }
        return this.m_OutlineStrokes[this.m_OutlineStrokeIdx++ % this.m_OutlineStrokes.length];
    }

    public Shape getNextShape() {
        if (this.m_Shapes == null) {
            return this.m_Default.getNextShape();
        }
        return this.m_Shapes[this.m_ShapeIdx++ % this.m_Shapes.length];
    }
}

