/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.custom;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;

public class XYBubbleRenderer
extends org.jfree.chart.renderer.xy.XYBubbleRenderer {
    private double m_DiameterRatio = 1.0;

    public XYBubbleRenderer(int n) {
        super(n);
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        XYZDataset xYZDataset;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = Double.NaN;
        if (xYDataset instanceof XYZDataset) {
            xYZDataset = (XYZDataset)xYDataset;
            d3 = xYZDataset.getZValue(n, n2);
        }
        if (!Double.isNaN(d3)) {
            xYZDataset = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, (RectangleEdge)xYZDataset);
            double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d6 = 0.0;
            double d7 = 0.0;
            switch (this.getScaleType()) {
                case 1: {
                    double d8 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)xYZDataset);
                    d6 = valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)xYZDataset) - d8;
                    d7 = d6 *= this.m_DiameterRatio;
                    break;
                }
                case 2: {
                    double d9 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d7 = d9 - valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge);
                    d6 = d7 *= this.m_DiameterRatio;
                    break;
                }
                default: {
                    double d10 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)xYZDataset);
                    double d11 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d6 = valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)xYZDataset) - d10;
                    d7 = d11 - valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge);
                    d6 *= this.m_DiameterRatio;
                    d7 *= this.m_DiameterRatio;
                }
            }
            d6 = Math.abs(d6);
            d7 = Math.abs(d7);
            Ellipse2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Ellipse2D.Double(d5 - d7 / 2.0, d4 - d6 / 2.0, d7, d6);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(double_);
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
            if (this.isItemLabelVisible(n, n2)) {
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d4, d5, false);
                } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, d5, d4, false);
                }
            }
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null && double_.intersects(rectangle2D)) {
                this.addEntity(entityCollection, double_, xYDataset, n, n2, double_.getCenterX(), double_.getCenterY());
            }
            int n4 = xYPlot.getDomainAxisIndex(valueAxis);
            int n5 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d, d2, n4, n5, d4, d5, plotOrientation);
        }
    }

    public void setDiameterRatio(double d) {
        this.m_DiameterRatio = d;
    }

    public double getDiamterRatio() {
        return this.m_DiameterRatio;
    }
}

