/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.chart2.I18N;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.GanttTaskType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.report2.raw.model.ControlSource;
import java.io.Serializable;
import java.util.Date;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.slf4j.Logger;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GanttTaskDatasetAdaptor$
implements SLF4J,
LoggingHelper,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GanttTaskDatasetAdaptor$.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    public static final GanttTaskDatasetAdaptor$ MODULE$ = new GanttTaskDatasetAdaptor$();

    private GanttTaskDatasetAdaptor$() {
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GanttTaskDatasetAdaptor$.class);
    }

    public DatasetHolder getTaskData(DataTable table, GanttTaskType taskType) {
        DataSchema schema = table.getSchema();
        int groupIdx = this.getIndex(schema, taskType.getGroup(), false);
        int taskIdx = this.getIndex(schema, taskType.getTask(), true);
        int startIdx = this.getIndex(schema, taskType.getStart(), true);
        int endIdx = this.getIndex(schema, taskType.getEnd(), true);
        int percentIdx = this.getIndex(schema, taskType.getPercent(), false);
        JavaScriptEngine e = JavaScriptEngine.getInstance();
        TaskSeriesCollection tsc = new TaskSeriesCollection();
        if (groupIdx >= 0 && taskIdx >= 0 && startIdx >= 0 && endIdx >= 0) {
            Object object = Predef$.MODULE$.refArrayOps(table.getUniqueValuesInOriginalOrder(groupIdx));
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)group -> {
                DataTable subTable = table.select(table.getGroups(), groupIdx, group);
                TaskSeries ts = new TaskSeries(group.toString());
                Object object = Predef$.MODULE$.refArrayOps((Object[])subTable.getRecords());
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)rec -> this.buildTask$1(taskIdx, startIdx, endIdx, percentIdx, (DataRecord)rec), ClassTag$.MODULE$.apply(Task.class)));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$0 -> ts.add(x$0));
                tsc.add(ts);
            });
        } else if (taskIdx >= 0 && startIdx >= 0 && endIdx >= 0) {
            String groupName = I18N.CHART.getString("Gantt.DefaultGroupName");
            TaskSeries ts = new TaskSeries(groupName);
            Object object = Predef$.MODULE$.refArrayOps((Object[])table.getRecords());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)rec -> this.buildTask$1(taskIdx, startIdx, endIdx, percentIdx, (DataRecord)rec), ClassTag$.MODULE$.apply(Task.class)));
            ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)x$0 -> ts.add(x$0));
            tsc.add(ts);
        }
        DatasetHolder dsh = new DatasetHolder((Dataset)tsc);
        dsh.setTitle(DataUtil.buildChartText(e, table, taskType.getTitle()));
        dsh.setLegend(DataUtil.buildChartText(e, table, taskType.getLegend()));
        dsh.setSchema(table.getSchema());
        dsh.setKeyIndex(taskIdx);
        return dsh;
    }

    private int getIndex(DataSchema schema, ControlSource src, boolean mandatory) {
        if (src == null) {
            return -1;
        }
        if (!src.getType().equals("Field")) {
            return -1;
        }
        int idx = schema.getColumnIndex(src.getField());
        if (idx < 0 && mandatory) {
            this.error(() -> GanttTaskDatasetAdaptor$.getIndex$$anonfun$1(src), Line$.MODULE$.apply(80), FullName$.MODULE$.apply("com.elixirtech.chart2.data.GanttTaskDatasetAdaptor.getIndex"));
        }
        return idx;
    }

    private static final Object $anonfun$1() {
        return "";
    }

    private static final Object buildTask$1$$anonfun$2(Exception ex$1) {
        return "Unable to create task: " + ex$1;
    }

    private final Option buildTask$1(int taskIdx$1, int startIdx$1, int endIdx$1, int percentIdx$1, DataRecord rec) {
        None$ none$;
        try {
            Object name = Option$.MODULE$.apply(rec.getData(taskIdx$1)).getOrElse(GanttTaskDatasetAdaptor$::$anonfun$1);
            Option optTask = Option$.MODULE$.apply(rec.getData(startIdx$1)).flatMap((Function1 & Serializable)start -> Option$.MODULE$.apply(rec.getData(endIdx$1)).map((Function1 & Serializable)end -> new Task(String.valueOf(name), (TimePeriod)new SimpleTimePeriod((Date)start, (Date)end))));
            if (percentIdx$1 >= 0 && optTask.isDefined()) {
                Option$.MODULE$.apply(rec.getData(percentIdx$1)).foreach((Function1)(JProcedure1 & Serializable)pc -> {
                    double percentComplete = ((Number)pc).doubleValue();
                    optTask.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.setPercentComplete(percentComplete));
                });
            }
            none$ = optTask;
        }
        catch (Exception ex) {
            this.warn(() -> GanttTaskDatasetAdaptor$.buildTask$1$$anonfun$2(ex), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("com.elixirtech.chart2.data.GanttTaskDatasetAdaptor.buildTask"));
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static final Object getIndex$$anonfun$1(ControlSource src$1) {
        return "Column not found for " + src$1.getField();
    }
}

