/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartDataFactory;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.ControlSource;
import java.text.ParseException;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultValueDataset;

public class MeterDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getMeterData(DataTable dataTable, MeterType meterType) {
        Object object;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        DataSchema dataSchema = dataTable.getSchema();
        ControlSource controlSource = meterType.getControlSource();
        Object object2 = null;
        String string = controlSource.getType();
        if ("Field".equals(string)) {
            int n = dataSchema.getColumnIndex(controlSource.getField());
            if (n >= 0 && dataRecordArray.length > 0) {
                object2 = dataRecordArray[0].getData(n);
            }
        } else if ("Operation".equals(string)) {
            int n = dataSchema.getColumnIndex(controlSource.getField());
            if (n >= 0) {
                DataType dataType;
                object = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
                Function function = object.getFunction(dataType = dataSchema.getColumnType(n), controlSource.getOperation());
                if (function instanceof RangedFunction && dataRecordArray.length > 0) {
                    RangedFunction rangedFunction = (RangedFunction)function;
                    dataTable.setRange(rangedFunction, dataTable.getGroups(), n);
                    GroupNode groupNode = new GroupNode(0, 0);
                    object2 = dataTable.apply(function, groupNode, n);
                } else {
                    object2 = dataTable.apply(function, dataTable.getGroups(), n);
                }
            }
        } else if ("Script".equals(string)) {
            String string2 = controlSource.getText();
            if (string2.startsWith("=")) {
                string2 = string2.substring(1);
            }
            javaScriptEngine.declareBean("Data", dataTable);
            try {
                object2 = javaScriptEngine.evaluate("meter script", string2);
            }
            catch (ScriptException scriptException) {
                m_JSLog.warn((Object)("Script exception: " + scriptException));
            }
        } else if ("Literal".equals(string)) {
            object2 = controlSource.getText();
        }
        DefaultValueDataset defaultValueDataset = new DefaultValueDataset();
        if (object2 instanceof Number) {
            defaultValueDataset.setValue((Number)object2);
        } else if (object2 instanceof String) {
            try {
                defaultValueDataset.setValue(ChartDataFactory.FORMAT.parse((String)object2));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        object = new DatasetHolder((Dataset)defaultValueDataset);
        ((DatasetHolder)object).setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, meterType.getTitle()));
        ((DatasetHolder)object).setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, meterType.getLegend()));
        return object;
    }
}

