/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.CategoryDatasetAdapter;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.data.ElxCategoryDataset;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.ICategoryType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.ControlSource;
import org.jfree.data.general.Dataset;
import org.mozilla.javascript.Scriptable;

public class WaterfallDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getCategoryData(DataTable dataTable, ICategoryType iCategoryType) {
        Object object;
        Object object2;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        DataSchema dataSchema = dataTable.getSchema();
        ControlSource controlSource = iCategoryType.getKeySource();
        ControlSourceList controlSourceList = iCategoryType.getValueSource();
        Value value = new Value();
        Value[] valueArray = new Value[controlSourceList.getControlSourceCount()];
        if (valueArray.length != 2) {
            return CategoryDatasetAdapter.getCategoryData(dataTable, iCategoryType);
        }
        if ("Field".equals(controlSource.getType())) {
            value.valueIdx = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            value.valueScript = javaScriptEngine.compile("key script", string);
        }
        for (int i = 0; i < valueArray.length; ++i) {
            valueArray[i] = new Value();
            object2 = controlSourceList.getControlSource(i);
            if ("Field".equals(((ControlSource)object2).getType())) {
                valueArray[i].valueIdx = dataSchema.getColumnIndex(((ControlSource)object2).getField());
                continue;
            }
            if (!"Script".equals(((ControlSource)object2).getType())) continue;
            object = ((ControlSource)object2).getText();
            if (((String)object).startsWith("=")) {
                object = ((String)object).substring(1);
            }
            valueArray[i].valueScript = javaScriptEngine.compile("value script", (String)object);
        }
        DataItem[] dataItemArray = new DataItem[dataRecordArray.length];
        object2 = new ChartData(dataTable);
        object = DataUtil.createRecordScope((ChartData)object2);
        for (int i = 0; i < dataRecordArray.length; ++i) {
            dataItemArray[i] = new DataItem();
            ((ChartData)object2).setRecordIndex(i);
            Object[] objectArray = dataRecordArray[i].getData();
            ((RecordScope)((Object)object)).setData(objectArray);
            dataItemArray[i].key = value.getValue((RecordScope)((Object)object), objectArray);
            dataItemArray[i].vkey = valueArray[0].getValue((RecordScope)((Object)object), objectArray);
            dataItemArray[i].value = valueArray[1].getValue((RecordScope)((Object)object), objectArray);
        }
        ElxCategoryDataset elxCategoryDataset = new ElxCategoryDataset(false);
        for (int i = 0; i < dataItemArray.length; ++i) {
            if (!(dataItemArray[i].key instanceof Comparable) || !(dataItemArray[i].vkey instanceof Comparable) || !(dataItemArray[i].value instanceof Number)) continue;
            System.out.println("setValue(" + dataItemArray[i].value + "," + dataItemArray[i].key + "," + dataItemArray[i].vkey + ")");
            elxCategoryDataset.setValue((Number)dataItemArray[i].value, (Comparable)dataItemArray[i].key, (Comparable)dataItemArray[i].vkey);
        }
        DatasetHolder datasetHolder = new DatasetHolder((Dataset)elxCategoryDataset);
        datasetHolder.setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getTitle()));
        datasetHolder.setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, iCategoryType.getLegend()));
        datasetHolder.setSchema(dataTable.getSchema());
        datasetHolder.setKeyIndex(value.valueIdx);
        return datasetHolder;
    }

    private static class Value {
        public int valueIdx = -1;
        public CompiledScript valueScript;
        private boolean m_WarnedOfException;

        private Value() {
        }

        public Object getValue(RecordScope recordScope, Object[] objectArray) {
            block4: {
                if (this.valueIdx >= 0) {
                    return objectArray[this.valueIdx];
                }
                if (this.valueScript != null) {
                    try {
                        return this.valueScript.eval((Scriptable)recordScope);
                    }
                    catch (ScriptException scriptException) {
                        if (this.m_WarnedOfException) break block4;
                        m_JSLog.warn((Object)("Script error: " + scriptException));
                        this.m_WarnedOfException = true;
                    }
                }
            }
            return null;
        }
    }

    private static class DataItem {
        public Object value;
        public Object key;
        public Object vkey;

        private DataItem() {
        }
    }
}

