/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.Chart;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.IBeanSAXOut;
import com.elixirtech.sax.ISAXOut;
import com.elixirtech.ui.StandardColor;
import java.util.Locale;
import org.xml.sax.helpers.AttributesImpl;

public class ChartSAXOut
implements IBeanSAXOut {
    @Override
    public String getTagName() {
        return "chart";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        Chart chart = (Chart)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(chart, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, chart);
        this.outputChildren(iSAXOut, chart);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        Chart chart = (Chart)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(chart, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, chart);
        this.outputChildren(iSAXOut, chart);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(Chart chart, AttributesImpl attributesImpl) {
        Object object;
        String string = chart.getCategory();
        if (string != null) {
            object = "category";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        if ((string = chart.getType()) != null) {
            object = "type";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        string = "locale";
        object = chart.getLocale();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Locale)object).toString());
        }
        string = "background-color";
        object = StandardColor.getColorName(chart.getBackgroundColor());
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", (String)object);
        }
    }

    public void outputChild(ISAXOut iSAXOut, Chart chart) {
        iSAXOut.output(chart.getChartType());
        iSAXOut.output(chart.getGroup(), "group");
        iSAXOut.output(chart.getOnConfigure(), "on-configure");
    }

    public void outputChildren(ISAXOut iSAXOut, Chart chart) {
    }
}

