/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.CompositeChart;
import com.elixirtech.chart2.model.CompositeChartTypeSAX;
import com.elixirtech.chart2.model.SubPlot;
import com.elixirtech.chart2.model.SubPlotSAX;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.ScriptSAX;
import com.elixirtech.sax.BasicSAXDelegate;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.ui.StandardColor;
import java.util.Locale;
import org.xml.sax.Attributes;

public class CompositeChartSAX
extends BasicSAXDelegate {
    protected CompositeChart m_CompositeChart;
    private String m_Tag;

    public CompositeChartSAX() {
        this("composite-chart");
    }

    public CompositeChartSAX(String string) {
        this.m_Tag = string;
        this.setCompositeChart(new CompositeChart());
    }

    public String getTag() {
        return this.m_Tag;
    }

    protected void setCompositeChart(CompositeChart compositeChart) {
        this.m_CompositeChart = compositeChart;
    }

    @Override
    public Object getObject() {
        return this.m_CompositeChart;
    }

    @Override
    protected void doStart(String string, Attributes attributes) {
        if (!this.m_AttributesInitialized && string.equals(this.m_Tag)) {
            this.initAttributes(attributes);
        } else if (string.equals("composite-chart-type")) {
            this.m_Delegate = new CompositeChartTypeSAX("composite-chart-type");
        } else if (string.equals("on-configure")) {
            this.m_Delegate = new ScriptSAX("on-configure");
        } else if (string.equals("sub-plot")) {
            this.m_Delegate = new SubPlotSAX("sub-plot");
        } else {
            super.doStart(string, attributes);
        }
    }

    @Override
    protected void initAttributes(Attributes attributes) {
        String string;
        String string2;
        this.m_CompositeChart.setCategory(attributes.getValue("category"));
        this.m_CompositeChart.setType(attributes.getValue("type"));
        Locale locale = BeanUtil.buildLocale(attributes.getValue("locale"));
        if (locale != null) {
            this.m_CompositeChart.setLocale(locale);
        }
        if ((string2 = attributes.getValue("background-color")) != null) {
            this.m_CompositeChart.setBackgroundColor(StandardColor.lookup(string2));
        }
        if ((string = attributes.getValue("subplot-gap")) != null) {
            this.m_CompositeChart.setSubPlotGap(Double.valueOf(string));
        }
        this.m_CompositeChart.setDomainRangeType(attributes.getValue("domain-range-type"));
        super.initAttributes(attributes);
    }

    @Override
    protected void doEnd(String string) {
        if (string.equals("composite-chart-type")) {
            this.m_CompositeChart.setChartType((ChartType)this.m_Delegate.getObject());
        } else if (string.equals("on-configure")) {
            this.m_CompositeChart.setOnConfigure((Script)this.m_Delegate.getObject());
        } else if (string.equals("sub-plot")) {
            SubPlot subPlot = (SubPlot)this.m_Delegate.getObject();
            this.m_CompositeChart.addSubPlot(subPlot);
        } else {
            super.doEnd(string);
        }
    }
}

