/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;
import java.awt.font.TextAttribute;
import java.util.HashMap;

public class Font
implements IBean {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Font.class);
    protected boolean m_IsLoaded;
    public static final java.awt.Font TICK_FONT = new java.awt.Font("SansSerif", 0, 10);
    public static final java.awt.Font LABEL_FONT = new java.awt.Font("SansSerif", 0, 12);
    public static final java.awt.Font LEGEND_FONT = new java.awt.Font("SansSerif", 0, 10);
    public static final java.awt.Font TITLE_FONT = new java.awt.Font("SansSerif", 0, 12);
    public static final java.awt.Font VALUE_FONT = new java.awt.Font("SansSerif", 0, 10);
    protected String m_FontFamily;
    protected String m_FontWeight;
    protected String m_FontStyle;
    protected String m_FontColor;
    protected int m_FontSize;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public Font() {
    }

    @Override
    public String getTagName() {
        return "font";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_FontSize < 60) {
            this.m_FontSize *= 20;
        }
    }

    @Override
    public void dispose() {
    }

    public void copyAttrs(Element element) {
        if (this.m_FontFamily != null) {
            element.setAttribute("font-family", this.m_FontFamily);
        }
        if (this.m_FontWeight != null) {
            element.setAttribute("font-weight", this.m_FontWeight);
        }
        if (this.m_FontStyle != null) {
            element.setAttribute("font-style", this.m_FontStyle);
        }
        if (this.m_FontColor != null) {
            element.setAttribute("font-color", this.m_FontColor);
        }
        element.setAttribute("font-size", Integer.toString(this.m_FontSize));
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Font font = (Font)this.getClass().newInstance();
        font.m_FontFamily = this.m_FontFamily;
        font.m_FontWeight = this.m_FontWeight;
        font.m_FontStyle = this.m_FontStyle;
        font.m_FontColor = this.m_FontColor;
        font.m_FontSize = this.m_FontSize;
        return font;
    }

    public Font(java.awt.Font font) {
        this.m_FontFamily = font.getName();
        this.m_FontWeight = font.isBold() ? "bold" : null;
        this.m_FontStyle = font.isItalic() ? "italic" : null;
        this.m_FontSize = font.getSize() * 20;
        this.m_FontColor = "Black";
    }

    public java.awt.Font getAWTFont() {
        boolean bl = "bold".equals(this.m_FontWeight);
        boolean bl2 = "italic".equals(this.m_FontStyle);
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.m_FontFamily);
        hashMap.put(TextAttribute.SIZE, new Float((float)this.m_FontSize / 20.0f));
        hashMap.put(TextAttribute.WEIGHT, bl ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, bl2 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        return new java.awt.Font(hashMap);
    }

    public String getFontFamily() {
        return this.m_FontFamily;
    }

    public void setFontFamily(String string) {
        this.m_FontFamily = string;
    }

    public String getFontWeight() {
        return this.m_FontWeight;
    }

    public void setFontWeight(String string) {
        this.m_FontWeight = string;
    }

    public String getFontStyle() {
        return this.m_FontStyle;
    }

    public void setFontStyle(String string) {
        this.m_FontStyle = string;
    }

    public String getFontColor() {
        return this.m_FontColor;
    }

    public void setFontColor(String string) {
        this.m_FontColor = string;
    }

    public int getFontSize() {
        return this.m_FontSize;
    }

    public void setFontSize(int n) {
        this.m_FontSize = n;
    }

    public Font deepCopy() {
        Font font = new Font();
        this.copyInto(font);
        return font;
    }

    protected void copyInto(Font font) {
        font.m_FontFamily = this.m_FontFamily;
        font.m_FontWeight = this.m_FontWeight;
        font.m_FontStyle = this.m_FontStyle;
        font.m_FontColor = this.m_FontColor;
        font.m_FontSize = this.m_FontSize;
    }
}

