/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.model;

import com.elixirtech.chart2.model.AbstractFormatSAXOut;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import java.util.Locale;
import org.xml.sax.helpers.AttributesImpl;

public class FormatSAXOut
extends AbstractFormatSAXOut {
    @Override
    public String getTagName() {
        return "format";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        Format format = (Format)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(format, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, format);
        this.outputChildren(iSAXOut, format);
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        Format format = (Format)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(format, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, format);
        this.outputChildren(iSAXOut, format);
        iSAXOut.endElement(string);
    }

    public void buildAttributes(Format format, AttributesImpl attributesImpl) {
        String string = "locale";
        Object object = format.getLocale();
        if (object != null) {
            attributesImpl.addAttribute("", string, string, "CDATA", ((Locale)object).toString());
        }
        string = "min-integer-digits";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(format.getMinIntegerDigits()));
        string = "max-integer-digits";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(format.getMaxIntegerDigits()));
        string = "min-fraction-digits";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(format.getMinFractionDigits()));
        string = "max-fraction-digits";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(format.getMaxFractionDigits()));
        string = "grouping-used";
        attributesImpl.addAttribute("", string, string, "CDATA", format.isGroupingUsed() ? "Yes" : "No");
        string = "grouping-size";
        attributesImpl.addAttribute("", string, string, "CDATA", Integer.toString(format.getGroupingSize()));
        string = "decimal-separator-always-shown";
        attributesImpl.addAttribute("", string, string, "CDATA", format.isDecimalSeparatorAlwaysShown() ? "Yes" : "No");
        string = format.getCustomPattern();
        if (string != null) {
            object = "custom-pattern";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        if ((string = format.getDateFormat()) != null) {
            object = "date-format";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        if ((string = format.getTimeFormat()) != null) {
            object = "time-format";
            attributesImpl.addAttribute("", (String)object, (String)object, "CDATA", string);
        }
        super.buildAttributes(format, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, Format format) {
        super.outputChild(iSAXOut, format);
    }

    public void outputChildren(ISAXOut iSAXOut, Format format) {
        super.outputChildren(iSAXOut, format);
    }
}

