/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.HighLowType;
import com.elixirtech.chart2.model.HighLowUi;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;

public class HighLowRenderer
extends Abstract2DChartRenderer {
    private HighLowType m_HighLowType;

    public HighLowRenderer(IChart iChart) {
        super(iChart);
        this.m_HighLowType = (HighLowType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        HighLowUi highLowUi = this.m_HighLowType.getHighLowUi();
        DateAxis dateAxis = new DateAxis();
        NumberAxis numberAxis = new NumberAxis();
        org.jfree.chart.renderer.xy.HighLowRenderer highLowRenderer = new org.jfree.chart.renderer.xy.HighLowRenderer();
        highLowRenderer.setToolTipGenerator((XYToolTipGenerator)new HighLowItemLabelGenerator());
        XYPlot xYPlot = new XYPlot((XYDataset)datasetHolder.getDataset(), (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)highLowRenderer);
        xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(highLowUi.getPlotBackground(), (Color)null));
        this.setRangeAxis(xYPlot, highLowUi.getKeyAxis());
        this.setDomainAxis(xYPlot, highLowUi.getValueAxis());
        JFreeChart jFreeChart = new JFreeChart((Plot)xYPlot);
        HighLowRenderer.setLegend(jFreeChart, this.m_HighLowType.getLegend(), datasetHolder.getLegend());
        HighLowRenderer.setTitle(jFreeChart, this.m_HighLowType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        HighLowRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }
}

