/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.MeterInterval;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.model.MeterUi;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.data.general.ValueDataset;

public class ThermometerRenderer
extends AbstractChartRenderer {
    private MeterType m_ThermometerType;
    public static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ThermometerRenderer.class);

    public ThermometerRenderer(IChart iChart) {
        super(iChart);
        this.m_ThermometerType = (MeterType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        MeterUi meterUi = this.m_ThermometerType.getMeterUi();
        ThermometerPlot thermometerPlot = new ThermometerPlot((ValueDataset)datasetHolder.getDataset());
        String string = meterUi.getUnit();
        if (string != null) {
            thermometerPlot.setUnits(string);
        }
        thermometerPlot.setBackgroundPaint((Paint)StandardColor.lookup(meterUi.getPlotBackground(), (Color)null));
        thermometerPlot.setRange(meterUi.getRangeMin(), meterUi.getRangeMax());
        int n = meterUi.getIntervalCount();
        if (n > 3) {
            n = 3;
        }
        for (int i = 0; i < n; ++i) {
            MeterInterval meterInterval = meterUi.getInterval(i);
            thermometerPlot.setSubrangeInfo(i, meterInterval.getMin(), meterInterval.getMax());
            thermometerPlot.setSubrangePaint(i, (Paint)meterInterval.getLineColor());
        }
        thermometerPlot.setOutlinePaint(null);
        thermometerPlot.setMercuryPaint((Paint)StandardColor.lookup(meterUi.getNeedleColor()));
        thermometerPlot.setValuePaint((Paint)StandardColor.lookup(meterUi.getValueColor()));
        JFreeChart jFreeChart = new JFreeChart(null, null, (Plot)thermometerPlot, false);
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        ThermometerRenderer.setLegend(jFreeChart, this.m_ThermometerType.getLegend(), datasetHolder.getLegend());
        ThermometerRenderer.setTitle(jFreeChart, this.m_ThermometerType.getTitle(), datasetHolder.getTitle());
        ThermometerRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }
}

