/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.windrose;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolarPosition {
    public static final double MARGIN = 20.0;
    private final double m_MaxRadius;
    private double m_Minx;
    private double m_Maxx;
    private double m_Miny;
    private double m_Maxy;
    private double m_HalfLength;
    private double m_MidX;
    private double m_MidY;

    public PolarPosition(Rectangle2D rectangle2D, double d) {
        this.m_MaxRadius = d;
        this.m_Minx = rectangle2D.getMinX() + 20.0;
        this.m_Maxx = rectangle2D.getMaxX() - 20.0;
        this.m_Miny = rectangle2D.getMinY() + 20.0;
        this.m_Maxy = rectangle2D.getMaxY() - 20.0;
        double d2 = this.m_Maxx - this.m_Minx;
        double d3 = this.m_Maxy - this.m_Miny;
        this.m_HalfLength = Math.min(d2, d3) / 2.0;
        this.m_MidX = this.m_Minx + d2 / 2.0;
        this.m_MidY = this.m_Miny + d3 / 2.0;
    }

    public Point2D translate(double d, double d2) {
        double d3 = Math.toRadians(d - 90.0);
        double d4 = this.m_HalfLength * Math.cos(d3);
        double d5 = this.m_HalfLength * Math.sin(d3);
        double d6 = d4 / 4.0;
        double d7 = d5 / 4.0;
        double d8 = 3.0 * d4 / 4.0;
        double d9 = 3.0 * d5 / 4.0;
        double d10 = this.m_MidX + d6 + d8 * d2 / this.m_MaxRadius;
        double d11 = this.m_MidY + d7 + d9 * d2 / this.m_MaxRadius;
        return new Point2D.Double(d10, d11);
    }
}

