/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.windrose;

import com.elixirtech.chart2.windrose.PolarPosition;
import com.elixirtech.chart2.windrose.WindRoseDataset;
import com.elixirtech.chart2.windrose.WindRosePlot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.NumberTick;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.text.TextUtilities;
import org.jfree.ui.TextAnchor;

public class WindRoseItemRenderer
extends DefaultPolarItemRenderer {
    public static final String[] ANGLE_NAMES = new String[]{"N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NNW"};
    private int m_TotalRecords;
    private int m_MaxSteps;
    private List<Steps> m_StepsData;
    private double m_MaxPercent;
    private double m_MaxRecords;
    private List<NumberTick> m_AngleTicks = new ArrayList<NumberTick>();
    private static final double ANGLE = 22.5;
    private static final double HALF_ANGLE = 11.25;
    private static double[] ANGLES = new double[ANGLE_NAMES.length];
    public static final Stroke SOLID;

    public WindRoseItemRenderer() {
        for (int i = 0; i < ANGLE_NAMES.length; ++i) {
            this.m_AngleTicks.add(new NumberTick((Number)ANGLES[i], ANGLE_NAMES[i], TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        }
    }

    public void setPlot(PolarPlot polarPlot) {
        super.setPlot(polarPlot);
        WindRoseDataset windRoseDataset = (WindRoseDataset)polarPlot.getDataset();
        this.m_TotalRecords = windRoseDataset.getItemCount(0);
        this.m_MaxSteps = 0;
        this.m_StepsData = new ArrayList<Steps>();
        for (int i = 0; i < ANGLES.length; ++i) {
            Steps steps = new Steps(windRoseDataset.getData(i));
            this.m_MaxSteps = Math.max(this.m_MaxSteps, steps.getSize());
            this.m_StepsData.add(steps);
        }
        this.m_MaxPercent = this.decideMaxPercent(this.m_MaxSteps, this.m_TotalRecords);
        this.m_MaxRecords = this.m_MaxPercent * (double)this.m_TotalRecords;
        polarPlot.getAxis().setRange(new Range(0.0, this.m_MaxPercent));
    }

    public void drawSeries(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, PolarPlot polarPlot, XYDataset xYDataset, int n) {
        for (int i = 0; i < ANGLES.length; ++i) {
            Steps steps = this.m_StepsData.get(i);
            int[] nArray = steps.getStepData();
            double d = 0.0;
            for (int j = 0; j < nArray.length; ++j) {
                if (nArray[j] <= 0) continue;
                double d2 = (double)nArray[j] / this.m_MaxRecords;
                Shape shape = WindRoseItemRenderer.getShape((WindRosePlot)polarPlot, rectangle2D, i, d, d + d2);
                this.drawShape(graphics2D, shape, j);
                d += d2;
            }
        }
    }

    private double decideMaxPercent(int n, int n2) {
        double d = (double)n / (double)n2;
        d = Math.ceil(d * 10.0) / 10.0;
        return d;
    }

    private void drawShape(Graphics2D graphics2D, Shape shape, int n) {
        graphics2D.setColor(WindRoseItemRenderer.getColor(n));
        graphics2D.fill(shape);
        graphics2D.setColor(Color.BLUE);
        graphics2D.setStroke(SOLID);
        graphics2D.draw(shape);
    }

    public void drawAngularGridLines(Graphics2D graphics2D, PolarPlot polarPlot, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(polarPlot.getAngleLabelFont());
        graphics2D.setStroke(polarPlot.getAngleGridlineStroke());
        graphics2D.setPaint(polarPlot.getAngleGridlinePaint());
        PolarPosition polarPosition = new PolarPosition(rectangle2D, 1.0);
        for (NumberTick numberTick : this.m_AngleTicks) {
            double d = numberTick.getNumber().doubleValue();
            Point2D point2D = polarPosition.translate(d, 0.0);
            Point2D point2D2 = polarPosition.translate(d, 1.0);
            Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
            graphics2D.draw(double_);
            if (!polarPlot.isAngleLabelsVisible()) continue;
            Point2D point2D3 = polarPosition.translate(d, 1.05);
            graphics2D.setPaint(polarPlot.getAngleLabelPaint());
            TextUtilities.drawAlignedString((String)numberTick.getText(), (Graphics2D)graphics2D, (float)((int)point2D3.getX()), (float)((int)point2D3.getY()), (TextAnchor)TextAnchor.CENTER);
        }
    }

    public void drawRadialGridLines(Graphics2D graphics2D, PolarPlot polarPlot, ValueAxis valueAxis, List list, Rectangle2D rectangle2D) {
        graphics2D.setFont(valueAxis.getTickLabelFont());
        graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
        graphics2D.setStroke(polarPlot.getRadiusGridlineStroke());
        Point point = new Point((int)rectangle2D.getCenterX(), (int)rectangle2D.getCenterY());
        PolarPosition polarPosition = new PolarPosition(rectangle2D, valueAxis.getUpperBound());
        for (NumberTick numberTick : list) {
            double d = numberTick.getNumber().doubleValue();
            Point2D point2D = polarPosition.translate(90.0, d);
            int n = (int)(point2D.getX() - (double)point.x);
            int n2 = point.x - n;
            int n3 = point.y - n;
            int n4 = 2 * n;
            Ellipse2D.Double double_ = new Ellipse2D.Double(n2, n3, n4, n4);
            graphics2D.setPaint(polarPlot.getRadiusGridlinePaint());
            graphics2D.draw(double_);
        }
    }

    public static Shape getShape(WindRosePlot windRosePlot, Rectangle2D rectangle2D, int n, double d, double d2) {
        Point2D point2D;
        int n2;
        double d3 = WindRoseItemRenderer.getAngle(n);
        double d4 = d3 - 11.25;
        double d5 = d3 + 11.25;
        GeneralPath generalPath = new GeneralPath();
        PolarPosition polarPosition = new PolarPosition(rectangle2D, 1.0);
        Point2D point2D2 = polarPosition.translate(d4, d);
        Point2D point2D3 = polarPosition.translate(d5, d);
        generalPath.moveTo((float)point2D2.getX(), (float)point2D2.getY());
        double[] dArray = WindRoseItemRenderer.step(d4, d5, 5);
        for (n2 = 0; n2 < dArray.length; ++n2) {
            point2D = polarPosition.translate(dArray[n2], d2);
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.lineTo((float)point2D3.getX(), (float)point2D3.getY());
        for (n2 = dArray.length - 1; n2 >= 0; --n2) {
            point2D = polarPosition.translate(dArray[n2], d);
            generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
        }
        generalPath.closePath();
        return generalPath;
    }

    public static double[] step(double d, double d2, int n) {
        double[] dArray = new double[n];
        double d3 = d;
        int n2 = n - 1;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d3;
            d3 += (d2 - d3) / (double)n2;
            --n2;
        }
        return dArray;
    }

    public static Color getColor(int n) {
        int n2 = 255 - n * 16;
        return new Color(n2, n2, n2, 196);
    }

    public static double getAngle(int n) {
        return ANGLES[n];
    }

    static {
        for (int i = 0; i < ANGLES.length; ++i) {
            WindRoseItemRenderer.ANGLES[i] = (double)i * 22.5;
        }
        SOLID = new BasicStroke(1.0f);
    }

    private static class Steps {
        private final int[] m_Steps;
        private final int m_Count;

        public Steps(List<WindRoseDataset.Datum> list) {
            this.m_Count = list.size();
            this.m_Steps = new int[13];
            for (WindRoseDataset.Datum datum : list) {
                int n = datum.bucket;
                this.m_Steps[n] = this.m_Steps[n] + 1;
            }
        }

        public int getSize() {
            return this.m_Count;
        }

        public int[] getStepData() {
            return this.m_Steps;
        }
    }
}

