/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.GroupAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DataGroup {
    protected final int m_Level;
    protected String m_Name;
    protected Map<String, GroupAttribute> m_Attributes;

    public DataGroup(int n, String string) {
        this.m_Level = n;
        this.m_Name = string;
    }

    public int getLevel() {
        return this.m_Level;
    }

    public String getName() {
        return this.m_Name;
    }

    public GroupAttribute getAttribute(String string) {
        if (this.m_Attributes == null) {
            return null;
        }
        return this.m_Attributes.get(string);
    }

    public void addAttribute(GroupAttribute groupAttribute) {
        if (this.m_Attributes == null) {
            this.m_Attributes = new HashMap<String, GroupAttribute>();
        }
        this.m_Attributes.put(groupAttribute.getName(), groupAttribute);
    }

    public Set<String> getAttributeNames() {
        if (this.m_Attributes == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.m_Attributes.keySet());
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.m_Level);
        dataOutputStream.writeUTF(this.m_Name);
        if (this.m_Attributes == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.m_Attributes.size());
            for (GroupAttribute groupAttribute : this.m_Attributes.values()) {
                groupAttribute.write(dataOutputStream);
            }
        }
    }

    public static DataGroup read(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        DataGroup dataGroup = new DataGroup(n, string);
        int n2 = dataInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            dataGroup.addAttribute(GroupAttribute.read(dataInputStream));
        }
        return dataGroup;
    }

    protected void setName(String string) {
        this.m_Name = string;
    }
}

