/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DecimalHelper;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.data2.function.RecordFunction;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public final class DataTable
extends AbstractDataSource {
    protected String m_Name;
    protected String m_Description;
    protected DataSchema m_Schema;
    protected DataRecord[] m_Records;
    protected GroupNode m_Root;

    public static DataTable build(IDataSource iDataSource) {
        return DataTable.build(new DefaultPushContext(), iDataSource);
    }

    public static DataTable build(IDataSource iDataSource, IDataSource iDataSource2) {
        return DataTable.build(new DefaultPushContext(), iDataSource, iDataSource2);
    }

    public static DataTable build(PushContext pushContext, IDataSource iDataSource) {
        if (iDataSource instanceof DataTable) {
            return (DataTable)iDataSource;
        }
        Builder builder = new Builder(pushContext);
        iDataSource.pushTo(pushContext, builder);
        return builder.getTable();
    }

    public static DataTable build(PushContext pushContext, IDataSource iDataSource, IDataSource iDataSource2) {
        if (iDataSource instanceof DataTable) {
            return (DataTable)iDataSource;
        }
        Builder builder = new Builder(pushContext, iDataSource2);
        iDataSource.pushTo(pushContext, builder);
        return builder.getTable();
    }

    protected DataTable() {
    }

    protected DataTable(String string, DataSchema dataSchema) {
        this.m_Name = string;
        this.m_Schema = dataSchema;
    }

    protected DataTable(DataTable dataTable) {
        this.m_Name = dataTable.m_Name;
        this.m_Schema = dataTable.m_Schema;
        this.m_Records = dataTable.m_Records;
        this.m_Root = dataTable.m_Root;
    }

    public DataTable(String string, DataSchema dataSchema, DataRecord[] dataRecordArray) {
        this.m_Name = string;
        this.setRecords(dataSchema, dataRecordArray);
    }

    public int hashCode() {
        int n = this.m_Records.length;
        for (int i = 0; i < this.m_Records.length; ++i) {
            n ^= this.m_Records[i].hashCode();
        }
        return n;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    @Override
    public String getType() {
        return "DataTable";
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public int getColumnIndex(String string) {
        return this.m_Schema.getColumnIndex(string);
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setRecords(DataSchema dataSchema, DataRecord[] dataRecordArray) {
        assert (dataSchema != null) : "Schema is null";
        assert (dataRecordArray != null) : "Records is null";
        this.m_Schema = dataSchema;
        this.m_Records = dataRecordArray;
        this.m_Root = new GroupNode(0, dataRecordArray.length - 1);
    }

    public int getRecordCount() {
        return this.m_Records.length;
    }

    public DataRecord getRecord(int n) {
        return this.m_Records[n];
    }

    public DataRecord[] getRecords() {
        return this.m_Records;
    }

    public DataTable subTable(int n, int n2) {
        DataRecord[] dataRecordArray = new DataRecord[n2];
        System.arraycopy(this.m_Records, n, dataRecordArray, 0, dataRecordArray.length);
        return new DataTable(this.m_Name, this.m_Schema, dataRecordArray);
    }

    public Object[] getUniqueValues(String string) {
        int n = this.getColumnIndex(string);
        return this.getUniqueValues(n);
    }

    public Object[] getUniqueValues(int n) {
        if (n >= 0) {
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (int i = 0; i < this.m_Records.length; ++i) {
                Object object = this.m_Records[i].getData(n);
                if (object == null) continue;
                treeSet.add(object);
            }
            Object[] objectArray = new Object[treeSet.size()];
            treeSet.toArray(objectArray);
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getUniqueValuesInOriginalOrder(int n) {
        if (n >= 0) {
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            for (int i = 0; i < this.m_Records.length; ++i) {
                Object object = this.m_Records[i].getData(n);
                if (object == null) continue;
                linkedHashSet.add(object);
            }
            Object[] objectArray = new Object[linkedHashSet.size()];
            linkedHashSet.toArray(objectArray);
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getUniqueValuesIncludingNull(int n) {
        if (n >= 0) {
            boolean bl = false;
            TreeSet<Object> treeSet = new TreeSet<Object>();
            for (int i = 0; i < this.m_Records.length; ++i) {
                Object object = this.m_Records[i].getData(n);
                if (object != null) {
                    treeSet.add(object);
                    continue;
                }
                bl = true;
            }
            if (bl) {
                Object[] objectArray = new Object[treeSet.size() + 1];
                System.arraycopy(treeSet.toArray(), 0, objectArray, 1, treeSet.size());
                return objectArray;
            }
            Object[] objectArray = new Object[treeSet.size()];
            treeSet.toArray(objectArray);
            return objectArray;
        }
        return new Object[0];
    }

    public Object[] getValues(String string) {
        int n = this.getColumnIndex(string);
        return this.getValues(n);
    }

    public Object[] getValues(int n) {
        if (n >= 0) {
            Object[] objectArray = new Object[this.m_Records.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.m_Records[i].getData(n);
            }
            return objectArray;
        }
        return new Object[0];
    }

    public Map<Object, Integer> getOccurrences(int n) {
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        if (n >= 0) {
            for (int i = 0; i < this.m_Records.length; ++i) {
                Object object = this.m_Records[i].getData(n);
                Integer n2 = (Integer)treeMap.get(object);
                if (n2 == null) {
                    treeMap.put(object, 1);
                    continue;
                }
                treeMap.put(object, n2 + 1);
            }
        }
        return treeMap;
    }

    public Object lookup(String string, Object object, String string2) throws DataException {
        int n = this.m_Schema.getColumnIndex(string);
        int n2 = this.m_Schema.getColumnIndex(string2);
        if (n < 0 || n2 < 0) {
            return null;
        }
        DataType dataType = this.m_Schema.getColumnType(n);
        Object object2 = this.m_Schema.narrow(dataType, object);
        for (int i = 0; i < this.m_Records.length; ++i) {
            Object object3 = this.m_Records[i].getData(n);
            if (!object2.equals(object3)) continue;
            return this.m_Records[i].getData(n2);
        }
        return null;
    }

    public DataRecord lookupRecord(String string, Object object) throws DataException {
        int n = this.m_Schema.getColumnIndex(string);
        if (n < 0) {
            return null;
        }
        DataType dataType = this.m_Schema.getColumnType(n);
        Object object2 = this.m_Schema.narrow(dataType, object);
        for (int i = 0; i < this.m_Records.length; ++i) {
            Object object3 = this.m_Records[i].getData(n);
            if (!object2.equals(object3)) continue;
            return this.m_Records[i];
        }
        return null;
    }

    public int seek(GroupNode groupNode, int n, Object object) {
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        for (int i = n2; i <= n3; ++i) {
            Object object2 = this.m_Records[i].getData(n);
            if (!object.equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public int seek(int n, int n2, Object object) {
        int n3 = this.m_Records.length - 1;
        for (int i = n; i <= n3; ++i) {
            Object object2 = this.m_Records[i].getData(n2);
            if (!object.equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public DataTable select(GroupNode groupNode, int n, Object object) {
        ArrayList<DataRecord> arrayList = new ArrayList<DataRecord>();
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        for (int i = n2; i <= n3; ++i) {
            double d;
            double d2;
            Object object2 = this.m_Records[i].getData(n);
            if (object == null) {
                if (object2 != null) continue;
                arrayList.add(this.m_Records[i]);
                continue;
            }
            if (object.equals(object2)) {
                arrayList.add(this.m_Records[i]);
                continue;
            }
            if (!(object instanceof Number) || !(object2 instanceof Number) || (d2 = ((Number)object).doubleValue()) != (d = ((Number)object2).doubleValue())) continue;
            arrayList.add(this.m_Records[i]);
        }
        DataTable dataTable = new DataTable(this.m_Name, this.m_Schema);
        dataTable.m_Records = new DataRecord[arrayList.size()];
        arrayList.toArray(dataTable.m_Records);
        dataTable.m_Root = new GroupNode(0, arrayList.size() - 1);
        return dataTable;
    }

    public Object apply(Function function, GroupNode groupNode, int n) {
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        if (function instanceof RecordFunction) {
            ((RecordFunction)function).setColumnIndex(n);
            for (int i = n2; i <= n3; ++i) {
                function.update(this.m_Records[i]);
            }
        } else {
            for (int i = n2; i <= n3; ++i) {
                function.update(this.m_Records[i].getData(n));
            }
        }
        return function.getResult();
    }

    public void setRange(RangedFunction rangedFunction, GroupNode groupNode, int n) {
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        Object[] objectArray = new Object[n3 - n2 + 1];
        for (int i = n2; i <= n3; ++i) {
            objectArray[i - n2] = this.m_Records[i].getData(n);
        }
        rangedFunction.setRange(objectArray);
    }

    public Object max(GroupNode groupNode, int n) {
        int n2;
        Object object = null;
        DataType dataType = this.m_Schema.getColumnType(n);
        int n3 = groupNode.getStart();
        if (n3 > (n2 = groupNode.getStop())) {
            return null;
        }
        for (int i = n3; i <= n2; ++i) {
            Object object2 = this.m_Records[i].getData(n);
            if (object == null) {
                object = object2;
                continue;
            }
            if (object2 == null || dataType.compare(object2, object) <= 0) continue;
            object = object2;
        }
        return object;
    }

    public Object min(GroupNode groupNode, int n) {
        Object object = null;
        DataType dataType = this.m_Schema.getColumnType(n);
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        for (int i = n2; i <= n3; ++i) {
            Object object2 = this.m_Records[i].getData(n);
            if (object == null) {
                object = object2;
                continue;
            }
            if (object2 == null || dataType.compare(object2, object) >= 0) continue;
            object = object2;
        }
        return object;
    }

    public Number sum(GroupNode groupNode, int n) {
        DataType dataType = this.m_Schema.getColumnType(n);
        if (dataType == DataType.DECIMAL) {
            BigDecimal bigDecimal = new BigDecimal(0);
            int n2 = groupNode.getStart();
            int n3 = groupNode.getStop();
            for (int i = n2; i <= n3; ++i) {
                BigDecimal bigDecimal2 = (BigDecimal)this.m_Records[i].getData(n);
                if (bigDecimal2 == null) continue;
                bigDecimal = bigDecimal.add(bigDecimal2);
            }
            return bigDecimal;
        }
        double d = 0.0;
        if (dataType.isNumeric()) {
            int n4 = groupNode.getStart();
            int n5 = groupNode.getStop();
            for (int i = n4; i <= n5; ++i) {
                Number number = (Number)this.m_Records[i].getData(n);
                if (number == null) continue;
                d += number.doubleValue();
            }
        } else {
            return null;
        }
        return d;
    }

    public Number sumDates(GroupNode groupNode, int n) {
        long l = 0L;
        int n2 = groupNode.getStart();
        int n3 = groupNode.getStop();
        for (int i = n2; i <= n3; ++i) {
            Date date = (Date)this.m_Records[i].getData(n);
            if (date == null) continue;
            l += date.getTime();
        }
        return l;
    }

    public Number average(GroupNode groupNode, int n) {
        DataType dataType = this.m_Schema.getColumnType(n);
        if (dataType == DataType.DATE) {
            double d = this.sumDates(groupNode, n).doubleValue();
            double d2 = this.count(groupNode, n).doubleValue();
            return d / d2;
        }
        if (dataType == DataType.DECIMAL) {
            BigDecimal bigDecimal = (BigDecimal)this.sum(groupNode, n);
            BigDecimal bigDecimal2 = new BigDecimal(this.count(groupNode, n));
            return bigDecimal.divide(bigDecimal2, DecimalHelper.MATH_CONTEXT);
        }
        if (dataType.isNumeric()) {
            double d = this.sum(groupNode, n).doubleValue();
            double d3 = this.count(groupNode, n).doubleValue();
            return d / d3;
        }
        return null;
    }

    public Long count(GroupNode groupNode, int n) {
        int n2 = 0;
        int n3 = groupNode.getStart();
        int n4 = groupNode.getStop();
        for (int i = n3; i <= n4; ++i) {
            Object object = this.m_Records[i].getData(n);
            if (object == null) continue;
            ++n2;
        }
        return n2;
    }

    public Number variance(GroupNode groupNode, int n) {
        DataType dataType = this.m_Schema.getColumnType(n);
        if (dataType == DataType.DECIMAL) {
            int n2 = this.count(groupNode, n).intValue();
            if (n2 < 2) {
                return new BigDecimal(Double.NaN);
            }
            BigDecimal bigDecimal = new BigDecimal(n2 - 1);
            BigDecimal bigDecimal2 = (BigDecimal)this.average(groupNode, n);
            BigDecimal bigDecimal3 = new BigDecimal(0.0);
            int n3 = groupNode.getStart();
            int n4 = groupNode.getStop();
            for (int i = n3; i <= n4; ++i) {
                Object object = this.m_Records[i].getData(n);
                if (object == null || !(object instanceof BigDecimal)) continue;
                BigDecimal bigDecimal4 = ((BigDecimal)object).subtract(bigDecimal2);
                bigDecimal3 = bigDecimal3.add(bigDecimal4.pow(2));
            }
            return bigDecimal3.divide(bigDecimal, DecimalHelper.MATH_CONTEXT);
        }
        if (dataType.isNumeric()) {
            int n5 = this.count(groupNode, n).intValue();
            if (n5 < 2) {
                return new Double(Double.NaN);
            }
            double d = this.average(groupNode, n).doubleValue();
            double d2 = 0.0;
            int n6 = groupNode.getStart();
            int n7 = groupNode.getStop();
            for (int i = n6; i <= n7; ++i) {
                Object object = this.m_Records[i].getData(n);
                if (object == null || !(object instanceof Number)) continue;
                d2 += Math.pow(((Number)object).doubleValue() - d, 2.0);
            }
            double d3 = d2 / (double)(n5 - 1);
            return d3;
        }
        return null;
    }

    public Number standardDeviation(GroupNode groupNode, int n) {
        Number number = this.variance(groupNode, n);
        if (number != null) {
            DataType dataType = this.m_Schema.getColumnType(n);
            number = dataType == DataType.DECIMAL ? new BigDecimal(Math.sqrt(number.doubleValue())) : Double.valueOf(Math.sqrt(number.doubleValue()));
        }
        return number;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        dataListener.startData(this);
        if (this.m_Root.hasChildren()) {
            Iterator<GroupNode> iterator = this.m_Root.getChildIterator();
            while (iterator.hasNext()) {
                GroupNode groupNode = iterator.next();
                this.processNode(groupNode, dataListener);
            }
        } else {
            for (int i = 0; i < this.m_Records.length && dataListener.processRecord(this.m_Records[i]); ++i) {
            }
        }
        dataListener.endData(this);
    }

    public void setGroups(GroupNode groupNode) {
        this.m_Root = groupNode;
    }

    public GroupNode getGroups() {
        return this.m_Root;
    }

    protected boolean processNode(GroupNode groupNode, DataListener dataListener) {
        boolean bl = true;
        dataListener.startGroup(groupNode);
        if (groupNode.hasChildren()) {
            Iterator<GroupNode> iterator = groupNode.getChildIterator();
            while (iterator.hasNext()) {
                if (this.processNode(iterator.next(), dataListener)) continue;
                bl = false;
                break;
            }
        } else {
            for (int i = groupNode.getStart(); i <= groupNode.getStop(); ++i) {
                if (dataListener.processRecord(this.m_Records[i])) continue;
                bl = false;
                break;
            }
        }
        dataListener.endGroup(groupNode);
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataTable(" + this.m_Records.length + "){");
        stringBuilder.append('\n');
        for (int i = 0; i < Math.min(10, this.m_Records.length); ++i) {
            stringBuilder.append(this.m_Records[i]);
            stringBuilder.append('\n');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class Builder
    implements DataListener2 {
        private final PushContext m_Context;
        private DataTable m_Table;
        private IDataSource m_Owner;
        private List<DataRecord> m_Records = new ArrayList<DataRecord>();
        private Stack<DataGroup> m_Groups = new Stack();

        public Builder(PushContext pushContext) {
            this.m_Context = pushContext;
        }

        public Builder(PushContext pushContext, IDataSource iDataSource) {
            this.m_Context = pushContext;
            this.m_Owner = iDataSource;
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                if (this.m_Owner != null) {
                    return clazz.cast(this.m_Owner);
                }
                return clazz.cast(this.m_Table);
            }
            return null;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            if (this.m_Table == null) {
                this.m_Table = new DataTable(iDataSource.getName(), iDataSource.getSchema());
            } else {
                this.m_Table.m_Name = iDataSource.getName();
                this.m_Table.m_Schema = iDataSource.getSchema();
            }
            this.m_Table.m_Root = new GroupNode();
            this.m_Groups.push(this.m_Table.m_Root);
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            GroupNode groupNode = (GroupNode)this.m_Groups.peek();
            GroupNode groupNode2 = new GroupNode(groupNode, dataGroup.getName());
            groupNode2.setStart(this.m_Records.size());
            this.m_Groups.push(groupNode2);
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            this.m_Records.add(dataRecord);
            return !this.m_Context.isAborted();
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            GroupNode groupNode = (GroupNode)this.m_Groups.pop();
            groupNode.setStop(this.m_Records.size() - 1);
        }

        @Override
        public void endData(IDataSource iDataSource) {
            this.m_Groups.clear();
            DataRecord[] dataRecordArray = new DataRecord[this.m_Records.size()];
            this.m_Records.toArray(dataRecordArray);
            this.m_Table.m_Records = dataRecordArray;
            this.m_Table.m_Root.setStart(0);
            this.m_Table.m_Root.setStop(dataRecordArray.length - 1);
        }

        public DataTable getTable() {
            assert (this.m_Table == null || this.m_Table.m_Records != null) : "Records is null";
            return this.m_Table;
        }
    }
}

