/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.BasicSecurity;
import com.elixirtech.arch.CachedFile;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.data2.AbstractDataSource;
import java.util.ArrayList;
import java.util.List;

public abstract class FileBasedDataSource
extends AbstractDataSource
implements IDirtyState {
    private ICachedFile m_CachedFile;
    private ISecurity m_Security = new BasicSecurity();
    private boolean m_IsDirty;
    private List<IDirtyState.Listener> m_DirtyListeners;

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDirtyState.class) {
            return clazz.cast(this);
        }
        if (clazz == ICachedFile.class) {
            if (this.m_CachedFile == null) {
                this.m_CachedFile = new CachedFile();
            }
            return clazz.cast(this.m_CachedFile);
        }
        if (clazz == ISecurity.class) {
            return clazz.cast(this.m_Security);
        }
        return super.getAdapter(clazz);
    }

    public ISecurity getSecurity() {
        return this.m_Security;
    }

    public void setSecurity(ISecurity iSecurity) {
        this.m_Security = iSecurity;
    }

    @Override
    public boolean isDirty() {
        return this.m_IsDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        if (bl != this.m_IsDirty) {
            this.m_IsDirty = bl;
            if (this.m_DirtyListeners != null) {
                for (IDirtyState.Listener listener : this.m_DirtyListeners) {
                    listener.dirtyStateChanged(this);
                }
            }
        }
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        if (this.m_DirtyListeners == null) {
            this.m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
        }
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.remove(listener);
    }

    public ICachedFile getCachedFile() {
        return this.m_CachedFile;
    }
}

