/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.xml.XMLContent$;
import com.elixirtech.data.RichSchema;
import com.elixirtech.data2.Data2Constants;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import com.elixirtech.data2.attributes.Nullable;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.Namespace;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.List;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.xml.Elem;

public final class SchemaHelper$
implements Serializable {
    public static final SchemaHelper$ MODULE$ = new SchemaHelper$();

    private SchemaHelper$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SchemaHelper$.class);
    }

    public String names(DataSchema s) {
        return new RichSchema(s).names().mkString("(", ",", ")");
    }

    public DataSchema fromJDOM(Element e) {
        block3: {
            block2: {
                if (!"schema".equals(e.getName())) break block2;
                Namespace namespace = e.getNamespace();
                Namespace namespace2 = Data2Constants.NS_DATASOURCE;
                if (!(namespace == null ? namespace2 != null : !((Object)namespace).equals(namespace2))) break block3;
            }
            throw new IllegalArgumentException("Element \"" + e.getName() + "\" is not a ds:schema");
        }
        boolean caseSensitive = "Yes".equals(e.getAttributeValue("case-sensitive"));
        List<Element> columns = e.getChildren("column", Data2Constants.NS_DATASOURCE);
        Buffer schemaItems = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(columns).asScala().map((Function1 & Serializable)column -> {
            String name = column.getAttributeValue("name").trim();
            DataType dataType = DataType.getInstance(column.getAttributeValue("type"));
            List<Element> attrList = column.getChildren("attribute", Data2Constants.NS_DATASOURCE);
            DataAttributes attrs = new DataAttributes();
            CollectionConverters$.MODULE$.ListHasAsScala(attrList).asScala().foreach((Function1)(JProcedure1 & Serializable)attr2 -> Option$.MODULE$.apply((Object)DataAttribute.newDataAttribute(attr2)).foreach((Function1)(JProcedure1 & Serializable)attr -> attrs.addAttribute((DataAttribute)attr)));
            return new SchemaItem(name, dataType, attrs);
        });
        DataSchema schema = new DataSchema(caseSensitive, (SchemaItem[])schemaItems.toArray(ClassTag$.MODULE$.apply(SchemaItem.class)));
        Option$.MODULE$.apply((Object)e.getAttributeValue("date-format")).foreach((Function1)(JProcedure1 & Serializable)format -> schema.setDateFormat((String)format));
        Option$.MODULE$.apply((Object)e.getAttributeValue("time-format")).foreach((Function1)(JProcedure1 & Serializable)format -> schema.setTimeFormat((String)format));
        Option$.MODULE$.apply((Object)e.getAttributeValue("timestamp-format")).foreach((Function1)(JProcedure1 & Serializable)format -> schema.setTimestampFormat((String)format));
        return schema;
    }

    public DataSchema fromXML(Elem e) {
        return this.fromJDOM(XMLContent$.MODULE$.apply(e).jdom());
    }

    public Elem toXML(DataSchema ds) {
        return XMLContent$.MODULE$.apply(this.toJDOM(ds)).xml();
    }

    public Element toJDOM(DataSchema ds) {
        String timestampFormat;
        String timeFormat;
        Element schema = new Element("schema", Data2Constants.NS_DATASOURCE);
        this.setAttribute(schema, "case-sensitive", ds.isCaseSensitive());
        String dateFormat = ds.getDateFormat();
        if (!"yyyy-MM-dd".equals(dateFormat)) {
            this.setAttribute(schema, "date-format", dateFormat);
        }
        if (!"HH:mm:ss".equals(timeFormat = ds.getTimeFormat())) {
            this.setAttribute(schema, "time-format", timeFormat);
        }
        if (!"yyyy-MM-dd HH:mm:ss".equals(timestampFormat = ds.getTimestampFormat())) {
            this.setAttribute(schema, "timestamp-format", timestampFormat);
        }
        CollectionConverters$.MODULE$.ListHasAsScala(ds.getColumns()).asScala().foreach((Function1 & Serializable)si -> {
            Element column = new Element("column", Data2Constants.NS_DATASOURCE);
            column.setAttribute("name", si.name.trim());
            column.setAttribute("type", si.type.getTypeName());
            CollectionConverters$.MODULE$.ListHasAsScala(si.attrs.getAttributes()).asScala().foreach((Function1 & Serializable)da -> column.addContent(da.getElement()));
            return schema.addContent(column);
        });
        return schema;
    }

    public DataSchema getSchemaFromMetaData(ResultSetMetaData md) {
        int count = md.getColumnCount();
        SchemaBuilder sb = new SchemaBuilder(true, true);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            String name = md.getColumnLabel(i);
            int sqlType = md.getColumnType(i);
            DataType dt = MODULE$.getDataTypeFromJDBC(sqlType);
            DataAttributes attrs = new DataAttributes();
            int nullable = md.isNullable(i);
            if (nullable == 0) {
                attrs.addAttribute(new Nullable(false));
            } else if (nullable == 1) {
                attrs.addAttribute(new Nullable(true));
            }
            sb.add(name, dt, attrs);
        });
        return sb.getSchema();
    }

    public DataType getDataTypeFromJDBC(int sqlType) {
        int n = sqlType;
        switch (n) {
            case -7: 
            case 16: {
                return DataType.BOOLEAN;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return DataType.BYTE_ARRAY;
            }
            case 91: {
                return DataType.DATE;
            }
            case 3: {
                return DataType.DECIMAL;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return DataType.DOUBLE;
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return DataType.LONG;
            }
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                return DataType.STRING;
            }
            case 92: {
                return DataType.TIME;
            }
            case 93: {
                return DataType.TIMESTAMP;
            }
        }
        return DataType.UNKNOWN;
    }

    public void setAttribute(Element parent, String name, String value) {
        if (value != null && value.length() > 0) {
            parent.setAttribute(name, value);
            return;
        }
    }

    public void setAttribute(Element parent, String name, boolean value) {
        parent.setAttribute(name, value ? "Yes" : "No");
    }
}

