/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataType;

public class SchemaItem {
    public final String name;
    public final DataType type;
    public final DataAttributes attrs;

    public SchemaItem(String string, DataType dataType) {
        this.name = this.tidy(string);
        this.type = dataType;
        this.attrs = new DataAttributes();
    }

    public SchemaItem(String string, DataType dataType, DataAttributes dataAttributes) {
        if (dataAttributes == null) {
            throw new IllegalStateException("attrs cannot be null");
        }
        this.name = this.tidy(string);
        this.type = dataType;
        this.attrs = dataAttributes;
    }

    public void addAttribute(DataAttribute dataAttribute) {
        this.attrs.addAttribute(dataAttribute);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof SchemaItem && this.name.equals(((SchemaItem)object).name);
    }

    public String toString() {
        return this.name + " : " + this.type.getTypeName();
    }

    private String tidy(String string) {
        return string.trim().replace("\r\n", " ").replace('\t', ' ').replace('\r', ' ').replace('\n', ' ');
    }
}

