/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache;

import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.DataSourceDefinition;
import com.elixirtech.data2.datasource.cache.CachedDataSource;
import com.elixirtech.data2.datasource.cache.Mode;
import com.elixirtech.jdom.Element;

public class CacheDefinition
extends DataSourceDefinition {
    @Override
    public IDataSource getDataSource(DataSourceManager dataSourceManager, Element element) throws DataException {
        if (!"datasource".equals(element.getName()) || element.getNamespace() != NS_DATASOURCE) {
            throw new IllegalArgumentException("Element " + element.getName() + " is not a ds:datasource");
        }
        String string = element.getAttributeValue("name");
        Element element2 = element.getChild("cache", NS_DATASOURCE);
        if (element2 == null) {
            throw new DataException("Can't load cache element");
        }
        IDataSource iDataSource = this.getParent(dataSourceManager, element2);
        String string2 = element2.getAttributeValue("filename");
        CachedDataSource cachedDataSource = new CachedDataSource(string, string2, iDataSource);
        long l = 0L;
        try {
            l = Long.parseLong(element2.getAttributeValue("expiry"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        cachedDataSource.setExpiry(l);
        cachedDataSource.setMode(Mode.getInstance(element2.getAttributeValue("mode")));
        return cachedDataSource;
    }

    @Override
    public Element setDataSource(IDataSource iDataSource) throws DataException {
        if (!(iDataSource instanceof CachedDataSource)) {
            throw new IllegalArgumentException("Not a CachedDataSource");
        }
        CachedDataSource cachedDataSource = (CachedDataSource)iDataSource;
        Element element = this.defineDataSource(cachedDataSource);
        Element element2 = new Element("cache", NS_DATASOURCE);
        element2.setAttribute("parent", cachedDataSource.getParent().getName());
        element2.setAttribute("expiry", Long.toString(cachedDataSource.getExpiry()));
        element2.setAttribute("filename", cachedDataSource.getFilename());
        element2.setAttribute("mode", cachedDataSource.getMode().toString());
        element.addContent(element2);
        return element;
    }
}

