/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.cache.CacheBuilder;
import com.elixirtech.data2.datasource.cache.CacheReader2;
import com.elixirtech.data2.datasource.cache.Mode;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class CachedDataSource
extends AbstractDataSource {
    private final String m_Name;
    private IDataSource m_DataSource;
    private Mode m_Mode;
    private long m_Expiry;
    private DataSchema m_Schema;
    private long m_Timestamp;
    private String m_Filename;
    private File m_File;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CachedDataSource.class);

    public CachedDataSource(String string, String string2, IDataSource iDataSource) throws DataException {
        this.m_Name = string;
        this.m_Filename = string2;
        this.m_DataSource = iDataSource;
    }

    public void setParent(IDataSource iDataSource) {
        if (this.m_DataSource != iDataSource) {
            this.m_DataSource = iDataSource;
            this.resetCache();
        }
    }

    public void setMode(Mode mode) {
        this.m_Mode = mode;
    }

    public Mode getMode() {
        return this.m_Mode;
    }

    public void resetCache() {
        this.m_Schema = null;
        this.m_Timestamp = 0L;
    }

    public IDataSource getParent() {
        return this.m_DataSource;
    }

    public String getFilename() {
        return this.m_Filename;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return "Cache";
    }

    public void setExpiry(long l) {
        this.m_Expiry = l;
    }

    public long getExpiry() {
        return this.m_Expiry;
    }

    @Override
    public List<Parameter> getParameters() {
        ArgumentMap argumentMap = new ArgumentMap();
        argumentMap.extractParameters(this.m_Filename);
        return argumentMap.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Schema == null || this.expired()) {
            this.m_Schema = this.m_DataSource.getSchema();
        }
        return this.m_Schema;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_Mode == Mode.DISABLED) {
            m_Log.debug((Object)"Disabled - bypassing cache");
            this.m_DataSource.pushTo(pushContext, dataListener);
        } else if (this.m_Mode == Mode.CACHE) {
            if (this.m_Schema == null) {
                this.m_Schema = this.m_DataSource.getSchema();
            }
            dataListener.startData(this);
            this.prepareFile(pushContext);
            if (this.expired()) {
                m_Log.debug((Object)"Expired - building cache");
                new CacheBuilder(this, this.m_File, pushContext, dataListener);
                this.m_Timestamp = System.currentTimeMillis();
            } else {
                m_Log.debug((Object)"Reading from cache");
                CacheReader2 cacheReader2 = null;
                try {
                    cacheReader2 = new CacheReader2(this, this.m_File);
                    DataSchema dataSchema = cacheReader2.getSchema();
                    if (dataSchema.equals(this.m_Schema)) {
                        m_Log.debug((Object)"Cache schema is consistent: using cache");
                        cacheReader2.pushTo(pushContext, dataListener);
                        cacheReader2.close();
                    }
                    cacheReader2.close();
                    m_Log.debug((Object)"Cache schema is inconsistent: rebuilding cache");
                    new CacheBuilder(this, this.m_File, pushContext, dataListener);
                    this.m_Timestamp = System.currentTimeMillis();
                }
                catch (Throwable throwable) {
                    boolean bl;
                    if (cacheReader2 != null) {
                        try {
                            cacheReader2.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    m_Log.error((Object)("cache read error: " + throwable), throwable);
                    m_Log.warn((Object)"Error reading from cache. Cache will be deleted");
                    if (this.m_File != null && !(bl = this.m_File.delete())) {
                        m_Log.warn((Object)"Can't delete cache");
                    }
                    this.m_Schema = null;
                    this.m_Timestamp = 0L;
                    throw new RuntimeException("Error reading from cache: " + throwable, throwable);
                }
            }
        } else if (this.m_Mode == Mode.STAGE) {
            dataListener.startData(this);
            this.prepareFile(pushContext);
            m_Log.debug((Object)"Staging");
            new CacheBuilder(this, this.m_File, pushContext, null);
            m_Log.debug((Object)"Forwarding");
            try {
                CacheReader2 cacheReader2 = new CacheReader2(this, this.m_File);
                cacheReader2.pushTo(pushContext, dataListener);
                cacheReader2.close();
            }
            catch (Throwable throwable) {
                m_Log.warn((Object)"Error reading from stage. Stage will be deleted");
                m_Log.error((Object)("cache read error: " + throwable), throwable);
                if (this.m_File != null) {
                    this.m_File.delete();
                }
                this.m_Schema = null;
                this.m_Timestamp = 0L;
                throw new RuntimeException("Error reading from cache: " + throwable, throwable);
            }
        }
    }

    protected boolean expired() {
        long l;
        boolean bl = this.m_Timestamp == 0L ? true : (this.m_Expiry == 0L ? false : (l = System.currentTimeMillis()) - this.m_Timestamp > this.m_Expiry * 1000L);
        m_Log.debug((Object)("Expired: " + bl));
        return bl;
    }

    private void prepareFile(PushContext pushContext) {
        try {
            if (StringUtil.notEmpty(this.m_Filename)) {
                File file = new File(System.getProperty("java.io.tmpdir"));
                String string = pushContext.substitute(this.m_Filename);
                m_Log.debug((Object)("Cache filename resolves to " + string));
                this.m_File = new File(file, string);
            } else {
                File file;
                this.m_File = file = File.createTempFile("Ensemble", "Cache");
                this.m_Filename = file.getName();
            }
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Can't create cache file: " + iOException), (Throwable)iOException);
        }
        if (this.m_File.exists() && this.m_File.length() > 0L) {
            m_Log.debug((Object)"Existing cache found");
            this.m_Timestamp = this.m_File.lastModified();
        } else {
            m_Log.debug((Object)"No existing cache found");
        }
    }
}

