/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.BasicSecurity;
import com.elixirtech.arch.CachedFile;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.NullDataSource;
import com.elixirtech.data2.datasource.composite.CompositeScope;
import com.elixirtech.data2.datasource.composite.DataStore;
import com.elixirtech.data2.datasource.composite.Result;
import com.elixirtech.ensemble.canvas.CompositeDiagram;
import com.elixirtech.ensemble.canvas.DataStoreGO;
import com.elixirtech.ensemble.canvas.InOutGO;
import com.elixirtech.ensemble.canvas.ResultGO;
import com.elixirtech.ensemble.ds.DSBuilder;
import com.elixirtech.js.JavaScriptEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.mozilla.javascript.Scriptable;

public class CompositeDataSource
implements IDataSource,
IDirtyState,
ChangeListener {
    private String m_Name;
    private String m_Description;
    private DataSchema m_DataSchema;
    private CompositeDiagram m_Diagram;
    private String m_Script;
    private IDataSource m_Result;
    private List<Parameter> m_Parameters = new ArrayList<Parameter>();
    private Map<DataStoreGO, DataStore> m_DataStores = new HashMap<DataStoreGO, DataStore>();
    private Map<InOutGO, IDataSource> m_GO2DS = new HashMap<InOutGO, IDataSource>();
    private boolean m_IsDirty;
    private List<IDirtyState.Listener> m_DirtyListeners;
    private ISecurity m_Security = new BasicSecurity();
    private ICachedFile m_CachedFile = new CachedFile();

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDirtyState.class) {
            return clazz.cast(this);
        }
        if (clazz == ICachedFile.class) {
            return clazz.cast(this.m_CachedFile);
        }
        if (clazz == ISecurity.class) {
            return clazz.cast(this.m_Security);
        }
        return null;
    }

    public void rebuildFromDiagram(InOutGO inOutGO) {
        DSBuilder dSBuilder = new DSBuilder(this);
        dSBuilder.buildSpecial(inOutGO);
    }

    public void init() {
        this.m_DataStores.clear();
        this.m_GO2DS.clear();
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    public void setName(String string) {
        assert (string != null) : "name may not be null";
        if (!string.equals(this.m_Name)) {
            this.m_Name = string;
            this.setDirty(true);
        }
    }

    public void setDescription(String string) {
        assert (string != null) : "description may not be null";
        if (!string.equals(this.m_Description)) {
            this.m_Description = string;
            this.setDirty(true);
        }
    }

    @Override
    public String getType() {
        return "Composite";
    }

    public void removeAllDataStores() {
        this.m_DataStores.clear();
    }

    public DataStore getDataStore(DataStoreGO dataStoreGO) {
        return this.m_DataStores.get(dataStoreGO);
    }

    public IDataSource getDataSource(InOutGO inOutGO) {
        DataStore dataStore;
        if (inOutGO instanceof ResultGO) {
            return this;
        }
        if (inOutGO instanceof DataStoreGO && (dataStore = this.getDataStore((DataStoreGO)inOutGO)) != null) {
            return dataStore.getDataSource();
        }
        return this.m_GO2DS.get(inOutGO);
    }

    public IDataSource getDataSource(String string) {
        InOutGO inOutGO = this.getGO(string);
        if (inOutGO != null) {
            return this.m_GO2DS.get(inOutGO);
        }
        return null;
    }

    public InOutGO getGO(String string) {
        for (InOutGO inOutGO : this.m_GO2DS.keySet()) {
            if (!string.equals(inOutGO.getText())) continue;
            return inOutGO;
        }
        return null;
    }

    public Collection<DataStore> getDataStores() {
        return Collections.unmodifiableCollection(this.m_DataStores.values());
    }

    public DataStore getResult() {
        return new Result(this);
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_Result != null) {
            return this.m_Result.getSchema();
        }
        if (this.m_DataSchema != null) {
            return this.m_DataSchema;
        }
        return new DataSchema();
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_DataSchema = dataSchema;
    }

    public void setResult(IDataSource iDataSource) {
        this.m_Result = iDataSource;
    }

    public void addDataStore(DataStoreGO dataStoreGO, DataStore dataStore) {
        this.m_DataStores.put(dataStoreGO, dataStore);
    }

    public void addDataSource(InOutGO inOutGO, IDataSource iDataSource) {
        this.m_GO2DS.put(inOutGO, iDataSource);
    }

    public Map<String, InOutGO> getGOMap() {
        HashMap<String, InOutGO> hashMap = new HashMap<String, InOutGO>();
        for (InOutGO inOutGO : this.m_GO2DS.keySet()) {
            hashMap.put(inOutGO.getText(), inOutGO);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        javaScriptEngine.pushScope((Scriptable)new CompositeScope(this));
        try {
            this.initScript(pushContext);
            if (this.m_Result != null) {
                this.m_Result.pushTo(pushContext, dataListener);
            } else {
                new NullDataSource().pushTo(pushContext, dataListener);
            }
        }
        finally {
            javaScriptEngine.popScope();
        }
    }

    public void initScript(PushContext pushContext) {
        String string = this.getJavaScript();
        if (string != null && string.trim().length() > 0) {
            JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
            try {
                javaScriptEngine.execute("Composite Script", string);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Composite Script Error: " + throwable, throwable);
            }
        }
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.m_Parameters);
    }

    public void setParameters(List<Parameter> list) {
        this.m_Parameters.clear();
        this.m_Parameters.addAll(list);
    }

    public void setDiagram(CompositeDiagram compositeDiagram) {
        this.m_Diagram = compositeDiagram;
    }

    public CompositeDiagram getDiagram() {
        return this.m_Diagram;
    }

    public void setJavaScript(String string) {
        if (StringUtil.isEmpty(this.m_Script) && StringUtil.isEmpty(string)) {
            return;
        }
        if (this.changed(string, this.m_Script)) {
            this.m_Script = string;
            this.setDirty(true);
        }
    }

    public String getJavaScript() {
        return this.m_Script;
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public void setDirty(boolean bl) {
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        if (this.m_DirtyListeners == null) {
            this.m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
        }
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.remove(listener);
    }

    public void setSecurity(ISecurity iSecurity) {
        this.m_Security = iSecurity;
    }

    public ISecurity getSecurity() {
        return this.m_Security;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
    }

    private boolean changed(Object object, Object object2) {
        if (object == null) {
            return object2 != null;
        }
        return !object.equals(object2);
    }

    public DataStoreGO getDataStoreGo(DataStore dataStore) {
        Set<DataStoreGO> set = this.m_DataStores.keySet();
        for (DataStoreGO dataStoreGO : set) {
            DataStore dataStore2 = this.m_DataStores.get(dataStoreGO);
            if (!dataStore2.equals(dataStore)) continue;
            return dataStoreGO;
        }
        return null;
    }
}

