/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.datasource.composite.Result;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public class DataStore
implements Comparable<DataStore> {
    public static final String RESULT = "[Result]";
    public static final String TYPE_XML = "XML File";
    public static final String TYPE_EXCEL = "Excel File";
    public static final String TYPE_XLSX = "XLSX File";
    public static final String TYPE_CSV = "CSV File";
    public static final String TYPE_TEXT = "Text File";
    public static final String TYPE_JDBC = "JDBC";
    public static final String TYPE_CONNECTION_POOL = "Connection Pool";
    public static final String TYPE_JDBC_JNDI = "JDBC JNDI";
    public static final String TYPE_NONE = "None";
    public static final String TYPE_JAVA = "Custom Java DataStore";
    public static final String TYPE_BINARY = "Binary";
    public static final String TYPE_JSON = "JSON File";
    public static final String TYPE_STAVE = "Stave";
    public static final String TYPE_MONGODB = "MongoDB";
    public static final String TYPE_RESULT = "Result";
    public static final String JDBC_CONTEXTFACTORY = "JDBC_ContextFactory";
    public static final String JDBC_RESOURCE = "JDBC_Resource";
    public static final String JDBC_FilEURL = "JDBC_FileURL";
    public static final String JDBC_APPEND = "JDBC_Append";
    public static final String JDBC_DRIVER = "JDBC_Driver";
    public static final String JDBC_DIALECT = "JDBC_Dialect";
    public static final String JDBC_EXISTS = "JDBC_Exists";
    public static final String JDBC_PASSWORD = "JDBC_Password";
    public static final String JDBC_TABLE_NAME = "JDBC_TableName";
    public static final String JDBC_URL = "JDBC_URL";
    public static final String JDBC_USER = "JDBC_User";
    public static final String JDBC_AUTO_COMMIT = "JDBC_AutoCommit";
    public static final String JDBC_UPDATE_INSERT = "JDBC_UpdateInsert";
    public static final String JDBC_RETURN_KEYS = "JDBC_ReturnKeys";
    public static final String JDBC_ERROR_STORE_URL = "JDBC_ErrorStoreURL";
    private IDataSource m_DataSource;
    private String m_Type;
    private String m_Name;
    private Map<String, String> m_Properties = new HashMap<String, String>();
    private List<Parameter> m_Parameters = new ArrayList<Parameter>();

    public DataStore() {
    }

    public DataStore(String string) {
        this.m_Type = string;
    }

    public boolean isResult() {
        return TYPE_RESULT.equals(this.m_Type);
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setType(String string) {
        this.m_Type = string;
    }

    public String getType() {
        return this.m_Type;
    }

    public void setProperty(String string, String string2) {
        this.m_Properties.put(string, string2);
    }

    public String getProperty(String string) {
        return this.m_Properties.get(string);
    }

    public void setDataSource(IDataSource iDataSource) {
        this.m_DataSource = iDataSource;
    }

    public IDataSource getDataSource() {
        return this.m_DataSource;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.m_Parameters);
    }

    public void addParameter(Parameter parameter) {
        this.m_Parameters.add(parameter);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.m_Properties);
    }

    public Icon getRenderableIcon() {
        return null;
    }

    public String getRenderableName() {
        return this.m_Name;
    }

    @Override
    public int compareTo(DataStore dataStore) {
        return this.m_Name.compareTo(dataStore.m_Name);
    }

    public boolean equals(Object object) {
        if (object instanceof Result) {
            return object.equals(this);
        }
        if (!(object instanceof DataStore)) {
            return false;
        }
        DataStore dataStore = (DataStore)object;
        if (!this.m_Type.equals(dataStore.m_Type)) {
            return false;
        }
        if (!this.m_Name.equals(dataStore.m_Name)) {
            return false;
        }
        return this.m_DataSource.getName().equals(dataStore.m_DataSource.getName());
    }

    public int hashCode() {
        return (this.m_Type + this.m_Name + this.m_DataSource.getName()).hashCode();
    }

    public String toString() {
        if (this.m_DataSource != null) {
            return "DataStore: " + this.m_DataSource.getName() + " (" + this.m_Type + ")";
        }
        if (this.m_Name != null) {
            Object object = null;
            object = this.m_Name.contains(this.m_Type) ? this.m_Type : this.m_Type + " (" + this.m_Name + ") ";
            return "DataStore: " + (String)object;
        }
        return "DataStore";
    }
}

