/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.composite;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Scriptable;

public class InputDataSource
extends AbstractDataSource {
    String m_Name;
    String m_Description;
    DataSchema m_Schema;
    IDataSource m_Parent;
    boolean m_IsPushThrough;
    Map<String, DataListener> m_ListenerMap = new HashMap<String, DataListener>();
    List<Test> m_TestList = new ArrayList<Test>();
    static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(InputDataSource.class);
    static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public InputDataSource(String string, IDataSource iDataSource) {
        this.m_Name = string;
        this.m_Parent = iDataSource;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    @Override
    public String getDescription() {
        return this.m_Description;
    }

    @Override
    public String getType() {
        return "Input";
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Parent.getSchema();
    }

    public IDataSource getParent() {
        return this.m_Parent;
    }

    public void addTest(String string, String string2) {
        this.m_TestList.add(new Test(string, string2));
    }

    public List<Test> getTests() {
        return Collections.unmodifiableList(this.m_TestList);
    }

    public String addListener(DataListener dataListener) {
        if (dataListener instanceof DataListener2) {
            IDataSource iDataSource = ((DataListener2)dataListener).getAdapter(IDataSource.class);
            if (iDataSource != null) {
                String string = iDataSource.getName();
                this.m_ListenerMap.put(string, dataListener);
                return string;
            }
            m_Log.error((Object)("DataListener2 " + dataListener.getClass().getName() + " has no IDataSource"));
        } else {
            m_Log.error((Object)("DataListener " + dataListener.getClass().getName() + " is not a DataListener2"));
        }
        return null;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        String string = this.addListener(dataListener);
        if (!this.m_IsPushThrough) {
            this.m_Parent.pushTo(pushContext, new ChoiceProcessor(pushContext, null));
            if (string != null) {
                this.m_ListenerMap.remove(string);
            }
        }
    }

    public void pushThrough(PushContext pushContext, DataListener dataListener) {
        assert (this.m_IsPushThrough);
        if (m_Log.isDebugEnabled()) {
            this.dumpDebugInfo();
        }
        this.m_Parent.pushTo(pushContext, new ChoiceProcessor(pushContext, dataListener));
    }

    public void enablePushThrough(boolean bl) {
        this.m_IsPushThrough = bl;
        this.m_ListenerMap.clear();
    }

    private void dumpDebugInfo() {
        m_Log.debug((Object)("---- Input Processor: " + this.m_Name + " ----"));
        m_Log.debug((Object)"Listener Map");
        int n = 0;
        for (Map.Entry<String, DataListener> object : this.m_ListenerMap.entrySet()) {
            m_Log.debug((Object)(n + "/ " + object.getKey() + "->" + object.getValue()));
            ++n;
        }
        m_Log.debug((Object)"--");
        n = 0;
        m_Log.debug((Object)"Test List");
        for (Test test : this.m_TestList) {
            m_Log.debug((Object)(n + "/ " + test.name + " " + test.test));
            ++n;
        }
    }

    public static class Test {
        public String name;
        public String test;
        public CompiledScript script;

        public Test(String string, String string2) {
            this.name = string;
            this.test = string2;
        }
    }

    private class ChoiceProcessor
    implements DataListener2 {
        private PushContext m_Context;
        private DataListener m_OutputDL;
        private JavaScriptEngine m_Engine;
        private RecordScope m_RecordScope;
        private boolean m_WarnedAlready;

        public ChoiceProcessor(PushContext pushContext, DataListener dataListener) {
            this.m_Context = pushContext;
            this.m_OutputDL = dataListener;
            this.m_Engine = JavaScriptEngine.getInstance();
            int n = InputDataSource.this.m_TestList.size();
            for (int i = 0; i < n; ++i) {
                Test test = InputDataSource.this.m_TestList.get(i);
                if (test.script != null || !StringUtil.notEmpty(test.test)) continue;
                test.script = this.m_Engine.compile("Input " + test.name, test.test);
            }
        }

        @Override
        public <T> T getAdapter(Class<T> clazz) {
            if (clazz == IDataSource.class) {
                return clazz.cast(InputDataSource.this);
            }
            return null;
        }

        private DataListener getTarget(String string) {
            DataListener dataListener = InputDataSource.this.m_ListenerMap.get(string);
            if (dataListener == null) {
                dataListener = InputDataSource.this.m_ListenerMap.get(string + "_discard");
            }
            return dataListener;
        }

        @Override
        public void startData(IDataSource iDataSource) {
            this.m_RecordScope = new RecordScope(InputDataSource.this.getSchema());
            this.m_RecordScope.setContext(this.m_Context);
            this.m_Engine.pushScope((Scriptable)this.m_RecordScope);
            for (DataListener dataListener : InputDataSource.this.m_ListenerMap.values()) {
                dataListener.startData(InputDataSource.this);
            }
            if (this.m_OutputDL != null) {
                this.m_OutputDL.startData(InputDataSource.this);
            }
        }

        @Override
        public void startGroup(DataGroup dataGroup) {
            for (DataListener dataListener : InputDataSource.this.m_ListenerMap.values()) {
                dataListener.startGroup(dataGroup);
            }
            if (this.m_OutputDL != null) {
                this.m_OutputDL.startGroup(dataGroup);
            }
        }

        @Override
        public boolean processRecord(DataRecord dataRecord) {
            int n = InputDataSource.this.m_TestList.size();
            this.m_RecordScope.setData(dataRecord.getData());
            for (int i = 0; i < n; ++i) {
                Test test = InputDataSource.this.m_TestList.get(i);
                if (test.script == null) {
                    DataListener dataListener = this.getTarget(test.name);
                    if (dataListener != null) {
                        return dataListener.processRecord(dataRecord);
                    }
                    return true;
                }
                try {
                    if (!test.script.eval((Scriptable)this.m_RecordScope).equals(Boolean.TRUE)) continue;
                    DataListener dataListener = this.getTarget(test.name);
                    if (dataListener != null) {
                        if (m_Log.isDebugEnabled()) {
                            m_Log.debug((Object)("Record following flow " + i));
                        }
                        return dataListener.processRecord(dataRecord);
                    }
                    if (m_Log.isDebugEnabled()) {
                        m_Log.debug((Object)"Record matches no tests");
                    }
                    return true;
                }
                catch (ScriptException scriptException) {
                    if (this.m_WarnedAlready) continue;
                    m_JSLog.error((Object)("ScriptException: (" + test.name + ") \"" + test.test + "\" : " + scriptException), (Throwable)scriptException);
                    this.m_WarnedAlready = true;
                }
            }
            return true;
        }

        @Override
        public void endGroup(DataGroup dataGroup) {
            for (DataListener dataListener : InputDataSource.this.m_ListenerMap.values()) {
                dataListener.endGroup(dataGroup);
            }
            if (this.m_OutputDL != null) {
                this.m_OutputDL.endGroup(dataGroup);
            }
        }

        @Override
        public void endData(IDataSource iDataSource) {
            for (DataListener dataListener : InputDataSource.this.m_ListenerMap.values()) {
                dataListener.endData(InputDataSource.this);
            }
            if (this.m_OutputDL != null) {
                this.m_OutputDL.endData(InputDataSource.this);
            }
            this.m_Engine.popScope();
        }
    }
}

